/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.api.DataStoreKeyHelper;
import org.shoal.ha.cache.api.ObjectInputOutputStreamFactory;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;

public class ObjectKeyHelper<K>
implements DataStoreKeyHelper<K> {
    private ObjectInputOutputStreamFactory factory;
    private ClassLoader loader;

    public ObjectKeyHelper(ClassLoader loader, ObjectInputOutputStreamFactory factory) {
        this.loader = loader;
        if (this.loader == null) {
            this.loader = ClassLoader.getSystemClassLoader();
        }
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void writeKey(ReplicationOutputStream ros, K k) throws IOException {
        block20: {
            byte[] data = null;
            ByteArrayOutputStream bos = null;
            ObjectOutputStream oos = null;
            bos = new ByteArrayOutputStream();
            oos = this.factory.createObjectOutputStream(bos);
            oos.writeObject(k);
            oos.flush();
            data = bos.toByteArray();
            if (oos == null) break block20;
            try {
                oos.close();
            }
            catch (IOException ioEx) {
                // empty catch block
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException ioEx) {
                    // empty catch block
                }
            }
            ros.writeLengthPrefixedBytes(data);
            break block20;
            catch (Exception ex) {
                if (oos == null) break block20;
                try {
                    oos.close();
                }
                catch (IOException ioEx) {
                    // empty catch block
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException ioEx) {
                        // empty catch block
                    }
                }
                ros.writeLengthPrefixedBytes(data);
                catch (Throwable throwable) {
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (IOException ioEx) {
                            // empty catch block
                        }
                        if (bos != null) {
                            try {
                                bos.close();
                            }
                            catch (IOException ioEx) {
                                // empty catch block
                            }
                        }
                        ros.writeLengthPrefixedBytes(data);
                    }
                    throw throwable;
                }
            }
        }
    }

    @Override
    public K readKey(ReplicationInputStream ris) throws DataStoreException {
        Object object;
        ByteArrayInputStream bis = new ByteArrayInputStream(ris.readLengthPrefixedBytes());
        ObjectInputStream ois = null;
        try {
            ois = this.factory.createObjectInputStream(bis, this.loader);
            object = ois.readObject();
        }
        catch (Exception ex) {
            throw new DataStoreException("Exception during readKey", ex);
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception ex1) {}
            try {
                bis.close();
            }
            catch (Exception ex2) {}
        }
        return (K)object;
    }
}

