/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.CommandManager;

public abstract class Command<K, V>
implements Serializable {
    private static final transient Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.save");
    private byte opcode;
    private K key;
    protected transient DataStoreContext<K, V> dsc;
    private transient CommandManager<K, V> cm;
    private transient byte[] cachedSerializedState;
    private transient String commandName;
    protected transient String targetInstanceName;

    protected Command(byte opcode) {
        this.opcode = opcode;
    }

    public final void initialize(DataStoreContext<K, V> rs) {
        this.dsc = rs;
        this.cm = rs.getCommandManager();
        this.commandName = this.getClass().getName();
        int index = this.commandName.lastIndexOf(46);
        this.commandName = this.commandName.substring(index + 1);
    }

    public void setKey(K key) {
        this.key = key;
    }

    public K getKey() {
        return this.key;
    }

    protected final DataStoreContext<K, V> getDataStoreContext() {
        return this.dsc;
    }

    protected final CommandManager<K, V> getCommandManager() {
        return this.cm;
    }

    public String getTargetName() {
        return this.targetInstanceName;
    }

    public final byte getOpcode() {
        return this.opcode;
    }

    protected void setTargetName(String val) {
        this.targetInstanceName = val;
    }

    public final void prepareTransmit(DataStoreContext<K, V> ctx) throws IOException {
        if (this.beforeTransmit()) {
            ByteArrayOutputStream bos = null;
            ObjectOutputStream oos = null;
            try {
                bos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(bos);
                oos.writeObject(this);
                oos.close();
                this.cachedSerializedState = bos.toByteArray();
            }
            catch (Exception ex) {
                throw new DataStoreException("Error during prepareToTransmit()", ex);
            }
            finally {
                try {
                    oos.close();
                }
                catch (Exception ex) {}
                try {
                    bos.close();
                }
                catch (Exception ex) {}
            }
        }
        _logger.log(Level.WARNING, "Aborting command transmission for " + this.getName() + " because beforeTransmit returned false");
    }

    public final byte[] getSerializedState() {
        return this.cachedSerializedState;
    }

    public String getKeyMappingInfo() {
        return this.targetInstanceName == null ? "" : this.targetInstanceName;
    }

    public final String getName() {
        return this.commandName + ":" + this.opcode;
    }

    public abstract void execute(String var1) throws DataStoreException;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(this.opcode);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.opcode = in.readByte();
    }

    public void onSuccess() {
    }

    public void onFailure() {
    }

    protected abstract boolean beforeTransmit();
}

