/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.interceptor;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.adapter.store.commands.NoOpCommand;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.interceptor.ReplicationFramePayloadCommand;
import org.shoal.ha.cache.impl.util.ASyncReplicationManager;

public class ReplicationCommandTransmitterWithMap<K, V>
implements Runnable {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.interceptor.transmit");
    private DataStoreContext<K, V> dsc;
    private volatile String targetName;
    private ScheduledFuture future;
    private static final String TRANSMITTER_FREQUECNCY_PROP_NAME = "org.shoal.cache.transmitter.frequency.in.millis";
    private static final String MAX_BATCH_SIZE_PROP_NAME = "org.shoal.cache.transmitter.max.batch.size";
    private static int TRANSMITTER_FREQUECNCY_IN_MILLIS = 100;
    private int MAX_BATCH_SIZE = 20;
    private AtomicReference<BatchedCommandListDataFrame> mapRef;
    ASyncReplicationManager asyncReplicationManager = ASyncReplicationManager._getInstance();
    private long timeStamp = System.currentTimeMillis();
    ThreadPoolExecutor executor;

    public void initialize(String targetName, DataStoreContext<K, V> rsInfo) {
        this.executor = ASyncReplicationManager._getInstance().getExecutorService();
        this.targetName = targetName;
        this.dsc = rsInfo;
        try {
            TRANSMITTER_FREQUECNCY_IN_MILLIS = Integer.getInteger(System.getProperty(TRANSMITTER_FREQUECNCY_PROP_NAME, "" + TRANSMITTER_FREQUECNCY_IN_MILLIS));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.MAX_BATCH_SIZE = Integer.getInteger(System.getProperty(MAX_BATCH_SIZE_PROP_NAME, "" + this.MAX_BATCH_SIZE));
        }
        catch (Exception ex) {
            // empty catch block
        }
        BatchedCommandListDataFrame batch = new BatchedCommandListDataFrame();
        this.mapRef = new AtomicReference<BatchedCommandListDataFrame>(batch);
        this.future = this.asyncReplicationManager.getScheduledThreadPoolExecutor().scheduleAtFixedRate(this, TRANSMITTER_FREQUECNCY_IN_MILLIS, TRANSMITTER_FREQUECNCY_IN_MILLIS, TimeUnit.MILLISECONDS);
    }

    public void close() {
        try {
            this.future.cancel(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addCommand(Command<K, V> cmd) {
        boolean done = false;
        while (!done) {
            BatchedCommandListDataFrame batch = this.mapRef.get();
            done = batch.addCommand(cmd);
            if (done) continue;
            BatchedCommandListDataFrame frame = new BatchedCommandListDataFrame();
            frame.addCommand(cmd);
            done = this.mapRef.compareAndSet(batch, frame);
        }
    }

    @Override
    public void run() {
        BatchedCommandListDataFrame batch = this.mapRef.get();
        batch.flushAndTransmit();
    }

    private class BatchedCommandListDataFrame
    implements Runnable {
        private AtomicInteger inFlightCount = new AtomicInteger(0);
        private AtomicBoolean batchThresholdReached = new AtomicBoolean(false);
        private AtomicBoolean alreadySent = new AtomicBoolean(false);
        private transient ConcurrentHashMap map = new ConcurrentHashMap();
        private long lastTS = System.currentTimeMillis();

        private BatchedCommandListDataFrame() {
        }

        public boolean addCommand(Command cmd) {
            int size;
            boolean result = false;
            this.inFlightCount.incrementAndGet();
            if (!this.batchThresholdReached.get() && (size = this.map.size()) < ReplicationCommandTransmitterWithMap.this.MAX_BATCH_SIZE) {
                Object key = cmd.getKey();
                this.map.put(key, cmd);
                result = true;
                if (this.map.size() >= ReplicationCommandTransmitterWithMap.this.MAX_BATCH_SIZE) {
                    this.batchThresholdReached.compareAndSet(false, true);
                }
            }
            int count = this.inFlightCount.decrementAndGet();
            if (this.batchThresholdReached.get() && count == 0 && this.alreadySent.compareAndSet(false, true)) {
                ReplicationCommandTransmitterWithMap.this.asyncReplicationManager.getExecutorService().submit(this);
            }
            return result;
        }

        void flushAndTransmit() {
            if (this.map.size() > 0) {
                if (this.lastTS == ReplicationCommandTransmitterWithMap.this.timeStamp) {
                    boolean completed = false;
                    int index = 0;
                    NoOpCommand nc = null;
                    do {
                        nc = new NoOpCommand();
                        nc.setKey("DummyKey:" + index++);
                    } while (this.addCommand(nc));
                } else {
                    ReplicationCommandTransmitterWithMap.this.timeStamp = this.lastTS;
                }
            }
        }

        @Override
        public void run() {
            ReplicationFramePayloadCommand rfCmd = new ReplicationFramePayloadCommand();
            rfCmd.setTargetInstance(ReplicationCommandTransmitterWithMap.this.targetName);
            try {
                int size = this.map.size();
                for (Object obj : this.map.values()) {
                    Command cmd = (Command)obj;
                    if (cmd.getOpcode() == 102) continue;
                    rfCmd.addComamnd(cmd);
                }
                ReplicationCommandTransmitterWithMap.this.dsc.getCommandManager().execute(rfCmd);
            }
            catch (IOException ioEx) {
                _logger.log(Level.WARNING, "Batch operation (ASyncCommandList failed...", ioEx);
            }
        }
    }
}

