/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import org.shoal.ha.cache.impl.util.ASyncThreadPool;

public class ASyncReplicationManager {
    private static final Object _lock = new Object();
    private static volatile ASyncReplicationManager _me = new ASyncReplicationManager();
    private static volatile ASyncThreadPool _asyncPool;
    private static ScheduledThreadPoolExecutor _scheduledTP;

    public static ASyncReplicationManager _getInstance() {
        return _me;
    }

    private ASyncReplicationManager() {
        int corePoolSize = ASyncReplicationManager.getSystemProp("org.shoal.ha.threadpool.core.pool.size", 16);
        int maxPoolSize = ASyncReplicationManager.getSystemProp("org.shoal.ha.threadpool.max.pool.size", 16);
        int keepAliveInSeconds = ASyncReplicationManager.getSystemProp("org.shoal.ha.threadpool.keepalive.in.seconds", 300);
        int boundedPoolSize = ASyncReplicationManager.getSystemProp("org.shoal.ha.threadpool.max.pending.replication.limit", 32768);
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(boundedPoolSize);
        _asyncPool = new ASyncThreadPool(corePoolSize, maxPoolSize, keepAliveInSeconds, queue);
        _scheduledTP = new ScheduledThreadPoolExecutor(2);
        System.out.println("Created ExecutorService with: core=" + corePoolSize + "; max=" + maxPoolSize + "; keepAlive=" + keepAliveInSeconds + "; maxLimit=" + boundedPoolSize);
    }

    private static final int getSystemProp(String propName, int defaultValue) {
        int value = defaultValue;
        try {
            value = Integer.parseInt(System.getProperty(propName, "" + defaultValue));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public ThreadPoolExecutor getExecutorService() {
        return _asyncPool;
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return _scheduledTP;
    }
}

