/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport;

import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.mgmt.transport.AbstractMulticastMessageSender;
import com.sun.enterprise.mgmt.transport.Message;
import com.sun.enterprise.mgmt.transport.MessageIOException;
import com.sun.enterprise.mgmt.transport.MessageImpl;
import com.sun.enterprise.mgmt.transport.NetworkManager;
import com.sun.enterprise.mgmt.transport.NetworkUtility;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockingIOMulticastSender
extends AbstractMulticastMessageSender
implements Runnable {
    private static final Logger LOG = GMSLogDomain.getLogger("ShoalLogger");
    private static final Logger monitorLog = GMSLogDomain.getMonitorLogger();
    private static final Logger mcastLog = GMSLogDomain.getMcastLogger();
    private final InetSocketAddress localSocketAddress;
    private final InetAddress multicastAddress;
    private final int multicastPort;
    private final InetSocketAddress multicastSocketAddress;
    private final Executor executor;
    private final NetworkManager networkManager;
    private NetworkInterface anInterface;
    private int multicastPacketSize;
    private MulticastSocket multicastSocket;
    private Thread multicastThread;
    private volatile boolean running;
    private CountDownLatch endGate = new CountDownLatch(1);
    private long shutdownTimeout = 5000L;
    private static final String DEFAULT_MULTICAST_ADDRESS = "230.30.1.1";
    private static final int DEFAULT_MULTICAST_PACKET_SIZE = 16384;
    private int multicastTimeToLive = -1;
    private final ThreadPoolExecutor threadPoolExecutor;
    private long maxExecutorQueueSize = 0L;
    private long rejectedExecution = 0L;
    private final boolean monitoringEnabled;

    public BlockingIOMulticastSender(String host, String multicastAddress, int multicastPort, String networkInterfaceName, int multicastPacketSize, PeerID localPeerID, Executor executor, int multicastTimeToLive, NetworkManager networkManager) throws IOException {
        NetworkInterface anInterface;
        if (host != null) {
            this.localSocketAddress = new InetSocketAddress(host, multicastPort);
        } else {
            InetAddress firstInetAddress = null;
            InetAddress multicastInetAddress = InetAddress.getByName(multicastAddress);
            firstInetAddress = multicastInetAddress instanceof Inet6Address ? NetworkUtility.getFirstInetAddress(true) : NetworkUtility.getFirstInetAddress(false);
            this.localSocketAddress = firstInetAddress != null ? new InetSocketAddress(firstInetAddress, multicastPort) : null;
        }
        this.multicastPort = multicastPort;
        if (multicastAddress == null) {
            multicastAddress = DEFAULT_MULTICAST_ADDRESS;
        }
        this.multicastAddress = InetAddress.getByName(multicastAddress);
        this.multicastSocketAddress = new InetSocketAddress(multicastAddress, multicastPort);
        if (networkInterfaceName != null && NetworkUtility.supportsMulticast(anInterface = NetworkInterface.getByName(networkInterfaceName))) {
            this.anInterface = anInterface;
        }
        if (this.anInterface == null) {
            this.anInterface = NetworkUtility.getFirstNetworkInterface();
        }
        this.multicastPacketSize = multicastPacketSize < 16384 ? 16384 : multicastPacketSize;
        this.localPeerID = localPeerID;
        this.executor = executor;
        this.threadPoolExecutor = executor instanceof ThreadPoolExecutor ? (ThreadPoolExecutor)executor : null;
        this.networkManager = networkManager;
        this.multicastTimeToLive = multicastTimeToLive;
        this.monitoringEnabled = monitorLog.isLoggable(Level.FINE);
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.running) {
            return;
        }
        super.start();
        this.multicastSocket = new MulticastSocket(this.multicastPort);
        if (this.anInterface != null) {
            this.multicastSocket.setNetworkInterface(this.anInterface);
        } else if (this.localSocketAddress != null) {
            this.multicastSocket.setInterface(this.localSocketAddress.getAddress());
        }
        this.multicastSocket.setLoopbackMode(false);
        if (this.multicastTimeToLive > 0) {
            try {
                this.multicastSocket.setTimeToLive(this.multicastTimeToLive);
                LOG.config("set via property: MulticastSocket.getTimeToLive()=" + this.multicastSocket.getTimeToLive());
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, "blockingiomcast.fail.set.timetolive", new Object[]{this.multicastTimeToLive});
            }
            catch (IllegalArgumentException iae) {
                LOG.log(Level.WARNING, "blockingiomcast.fail.set.timetolive", new Object[]{this.multicastTimeToLive});
            }
        } else {
            int timeToLive = this.multicastSocket.getTimeToLive();
            if (timeToLive < 4) {
                try {
                    this.multicastTimeToLive = 4;
                    this.multicastSocket.setTimeToLive(this.multicastTimeToLive);
                    LOG.config("Set via default minimum: MulticastSocket.getTimeToLive()=" + this.multicastSocket.getTimeToLive());
                }
                catch (IOException ioe) {
                    LOG.log(Level.WARNING, "blockingiomcast.fail.set.timetolive", new Object[]{this.multicastTimeToLive});
                }
            }
        }
        this.running = true;
        this.multicastThread = new Thread((Runnable)this, "IP Multicast Listener for " + this.multicastSocketAddress);
        this.multicastThread.setDaemon(true);
        this.multicastThread.start();
        LOG.config("MulticastSocket configuration: local socket address: " + this.multicastSocket.getLocalSocketAddress() + " network interface: " + this.multicastSocket.getNetworkInterface() + " multicast address:" + this.multicastAddress + " timeToLive=" + this.multicastSocket.getTimeToLive());
        if (this.anInterface != null) {
            this.multicastSocket.joinGroup(this.multicastSocketAddress, this.anInterface);
        } else {
            this.multicastSocket.joinGroup(this.multicastAddress);
        }
    }

    @Override
    public synchronized void stop() throws IOException {
        if (!this.running) {
            return;
        }
        this.running = false;
        super.stop();
        if (this.multicastSocket != null) {
            try {
                if (this.anInterface != null) {
                    this.multicastSocket.leaveGroup(this.multicastSocketAddress, this.anInterface);
                } else {
                    this.multicastSocket.leaveGroup(this.multicastAddress);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            this.multicastSocket.close();
        }
        this.printStats(Level.INFO);
        boolean finished = false;
        try {
            finished = this.endGate.await(this.shutdownTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.multicastThread != null) {
            this.multicastThread.interrupt();
        }
    }

    private void printStats(Level level) {
        if (this.threadPoolExecutor != null) {
            try {
                StringBuffer sb = new StringBuffer();
                sb.append("BlockingIOMulicastSender monitoring stats: ");
                sb.append("received: ").append(this.threadPoolExecutor.getCompletedTaskCount()).append(" core poolsize:").append(this.threadPoolExecutor.getCorePoolSize());
                sb.append(" largest pool size:").append(this.threadPoolExecutor.getLargestPoolSize()).append(" task count:").append(this.threadPoolExecutor.getTaskCount());
                sb.append(" max queue size:").append(this.maxExecutorQueueSize).append(" rejected execution:").append(this.rejectedExecution);
                monitorLog.log(level, sb.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (this.running) {
                DatagramPacket packet;
                block12: {
                    byte[] buffer = new byte[this.multicastPacketSize];
                    packet = new DatagramPacket(buffer, buffer.length);
                    this.multicastSocket.receive(packet);
                    if (this.running) break block12;
                    this.multicastThread = null;
                    this.endGate.countDown();
                    LOG.log(Level.INFO, "mgmt.blockingiomulticast.threadcomplete", new Object[]{Thread.currentThread().getName()});
                    return;
                }
                try {
                    MessageProcessTask processor = new MessageProcessTask(packet);
                    if (this.executor != null) {
                        int qsize;
                        this.executor.execute(processor);
                        if (this.threadPoolExecutor == null || (long)(qsize = this.threadPoolExecutor.getQueue().size()) <= this.maxExecutorQueueSize) continue;
                        this.maxExecutorQueueSize = qsize;
                        continue;
                    }
                    processor.run();
                }
                catch (InterruptedIOException iie) {
                    Thread.interrupted();
                }
                catch (IOException e) {
                    if (!this.running) break;
                    LOG.log(Level.SEVERE, "blockingiomcast.mcastreceivefailure", new Object[]{e.getLocalizedMessage()});
                    break;
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "blockingiomcast.mcastreceivefailure", new Object[]{t.getLocalizedMessage()});
                    if (!(t instanceof RejectedExecutionException)) continue;
                    ++this.rejectedExecution;
                }
            }
            this.multicastThread = null;
            this.endGate.countDown();
        }
        catch (Throwable t) {
            try {
                LOG.log(Level.SEVERE, "blockingiomcast.receiveprocess.uncaughtthrowable", new Object[]{t.getLocalizedMessage(), Thread.currentThread().getName()});
                LOG.log(Level.SEVERE, "stack trace", t);
                this.multicastThread = null;
                this.endGate.countDown();
            }
            catch (Throwable throwable) {
                this.multicastThread = null;
                this.endGate.countDown();
                LOG.log(Level.INFO, "mgmt.blockingiomulticast.threadcomplete", new Object[]{Thread.currentThread().getName()});
                throw throwable;
            }
            LOG.log(Level.INFO, "mgmt.blockingiomulticast.threadcomplete", new Object[]{Thread.currentThread().getName()});
            return;
        }
        LOG.log(Level.INFO, "mgmt.blockingiomulticast.threadcomplete", new Object[]{Thread.currentThread().getName()});
        return;
    }

    @Override
    protected boolean doBroadcast(Message message) throws IOException {
        DatagramPacket packet;
        if (!this.running || this.multicastSocket == null) {
            throw new IOException("multicast server is not running");
        }
        if (message == null) {
            throw new IOException("message is null");
        }
        byte[] messageBytes = message.getPlainBytes();
        int numBytesInPacket = messageBytes.length;
        if (numBytesInPacket > this.multicastPacketSize) {
            LOG.log(Level.WARNING, "blockingiomcast.exceedsmaxsize", new Object[]{numBytesInPacket, this.multicastPacketSize});
        }
        if (this.localSocketAddress != null) {
            if (this.multicastSocketAddress == null) {
                throw new IOException("multicast address can not be null");
            }
            packet = new DatagramPacket(messageBytes, numBytesInPacket, this.multicastSocketAddress);
        } else {
            if (this.multicastAddress == null) {
                throw new IOException("multicast address can not be null");
            }
            packet = new DatagramPacket(messageBytes, numBytesInPacket, this.multicastAddress, this.multicastPort);
        }
        if (this.multicastSocket != null) {
            this.multicastSocket.send(packet);
            return true;
        }
        return false;
    }

    private class MessageProcessTask
    implements Runnable {
        private final DatagramPacket packet;

        public MessageProcessTask(DatagramPacket packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            block13: {
                MessageImpl message = null;
                if (this.packet == null) {
                    return;
                }
                try {
                    message = new MessageImpl();
                    byte[] byteMessage = this.packet.getData();
                    try {
                        int messageLen = message.parseHeader(byteMessage, 0);
                        message.parseMessage(byteMessage, 16, messageLen);
                    }
                    catch (IllegalArgumentException iae) {
                        if (LOG.isLoggable(Level.WARNING)) {
                            LOG.log(Level.WARNING, "blockingiomcast.damaged", iae);
                        }
                        return;
                    }
                    catch (MessageIOException mie) {
                        if (LOG.isLoggable(Level.WARNING)) {
                            LOG.log(Level.WARNING, "blockingiomcast.damaged", mie);
                        }
                        return;
                    }
                    if (BlockingIOMulticastSender.this.networkManager != null) {
                        BlockingIOMulticastSender.this.networkManager.receiveMessage(message, null);
                        if (message.getType() != 2 && mcastLog.isLoggable(Level.FINER)) {
                            mcastLog.log(Level.FINER, "BlockingIOMulticastSender.receiveMessage processed multicast message " + ((Object)message).toString());
                        }
                    }
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(Level.WARNING)) break block13;
                    String msgOutput = "";
                    try {
                        if (message != null) {
                            msgOutput = ((Object)message).toString();
                        }
                    }
                    catch (Throwable tt) {
                        LOG.log(Level.WARNING, "blockingiomcast.failprocessing", new Object[]{msgOutput});
                        LOG.log(Level.WARNING, "stack trace", tt);
                    }
                }
            }
        }
    }
}

