/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.interceptor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.adapter.store.commands.NoOpCommand;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.interceptor.CommandCollector;
import org.shoal.ha.cache.impl.interceptor.ReplicationFramePayloadCommand;
import org.shoal.ha.cache.impl.util.ASyncReplicationManager;

public class ReplicationCommandTransmitterWithMap<K, V>
implements Runnable,
CommandCollector<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.interceptor.transmit");
    private static final Logger _statsLogger = Logger.getLogger("org.shoal.ha.cache.stats");
    private DataStoreContext<K, V> dsc;
    private volatile String targetName;
    private ScheduledFuture future;
    private static final String TRANSMITTER_FREQUECNCY_PROP_NAME = "org.shoal.cache.transmitter.frequency.in.millis";
    private static final String MAX_BATCH_SIZE_PROP_NAME = "org.shoal.cache.transmitter.max.batch.size";
    private static int TRANSMITTER_FREQUECNCY_IN_MILLIS = 100;
    private static int MAX_BATCH_SIZE = 30;
    private AtomicReference<BatchedCommandMapDataFrame> mapRef;
    ASyncReplicationManager asyncReplicationManager = ASyncReplicationManager._getInstance();
    private long timeStamp = System.currentTimeMillis();
    ThreadPoolExecutor executor;
    private static AtomicInteger _sendBatchCount;

    @Override
    public void initialize(String targetName, DataStoreContext<K, V> rsInfo) {
        this.executor = ASyncReplicationManager._getInstance().getExecutorService();
        this.targetName = targetName;
        this.dsc = rsInfo;
        BatchedCommandMapDataFrame batch = new BatchedCommandMapDataFrame();
        this.mapRef = new AtomicReference<BatchedCommandMapDataFrame>(batch);
        this.future = this.asyncReplicationManager.getScheduledThreadPoolExecutor().scheduleAtFixedRate(this, TRANSMITTER_FREQUECNCY_IN_MILLIS, TRANSMITTER_FREQUECNCY_IN_MILLIS, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        try {
            this.future.cancel(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void addCommand(Command<K, V> cmd) {
        boolean done = false;
        while (!done) {
            BatchedCommandMapDataFrame batch = this.mapRef.get();
            done = batch.doAddOrRemove(cmd, true);
            if (done) continue;
            BatchedCommandMapDataFrame frame = new BatchedCommandMapDataFrame();
            frame.doAddOrRemove(cmd, true);
            done = this.mapRef.compareAndSet(batch, frame);
        }
    }

    @Override
    public void removeCommand(Command<K, V> cmd) {
        boolean done = false;
        while (!done) {
            BatchedCommandMapDataFrame batch = this.mapRef.get();
            done = batch.doAddOrRemove(cmd, false);
            if (done) continue;
            BatchedCommandMapDataFrame frame = new BatchedCommandMapDataFrame();
            frame.doAddOrRemove(cmd, false);
            done = this.mapRef.compareAndSet(batch, frame);
        }
    }

    @Override
    public void run() {
        BatchedCommandMapDataFrame batch = this.mapRef.get();
        batch.flushAndTransmit();
    }

    static {
        try {
            TRANSMITTER_FREQUECNCY_IN_MILLIS = Integer.valueOf(System.getProperty(TRANSMITTER_FREQUECNCY_PROP_NAME, "" + TRANSMITTER_FREQUECNCY_IN_MILLIS));
            _statsLogger.log(Level.CONFIG, "USING org.shoal.cache.transmitter.frequency.in.millis = " + TRANSMITTER_FREQUECNCY_IN_MILLIS);
        }
        catch (Exception ex) {
            _statsLogger.log(Level.CONFIG, "USING org.shoal.cache.transmitter.frequency.in.millis = " + TRANSMITTER_FREQUECNCY_IN_MILLIS);
        }
        try {
            MAX_BATCH_SIZE = Integer.valueOf(System.getProperty(MAX_BATCH_SIZE_PROP_NAME, "" + MAX_BATCH_SIZE));
            _statsLogger.log(Level.CONFIG, "USING org.shoal.cache.transmitter.max.batch.size = " + MAX_BATCH_SIZE);
        }
        catch (Exception ex) {
            _statsLogger.log(Level.CONFIG, "USING org.shoal.cache.transmitter.max.batch.size = " + MAX_BATCH_SIZE);
        }
        _logger.log(Level.FINE, "USING ReplicationCommandTransmitterWithMap");
        _sendBatchCount = new AtomicInteger(0);
    }

    private class BatchedCommandMapDataFrame
    implements Runnable {
        private int myBatchNumber;
        private AtomicInteger inFlightCount = new AtomicInteger(0);
        private AtomicBoolean batchThresholdReached = new AtomicBoolean(false);
        private AtomicBoolean alreadySent = new AtomicBoolean(false);
        private volatile ConcurrentHashMap map = new ConcurrentHashMap();
        private volatile List removedKeys = new ArrayList();
        private volatile long lastTS = System.currentTimeMillis();

        BatchedCommandMapDataFrame() {
            this.myBatchNumber = _sendBatchCount.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doAddOrRemove(Command cmd, boolean isAdd) {
            boolean result = false;
            if (!this.batchThresholdReached.get()) {
                int inCount = 0;
                try {
                    this.inFlightCount.incrementAndGet();
                    if (!this.batchThresholdReached.get()) {
                        if (isAdd) {
                            this.map.put(cmd.getKey(), cmd);
                            result = true;
                            if (this.map.size() >= MAX_BATCH_SIZE) {
                                this.batchThresholdReached.compareAndSet(false, true);
                            }
                        } else {
                            this.map.remove(cmd.getKey());
                            this.removedKeys.add(cmd.getKey());
                            result = true;
                            if (this.removedKeys.size() >= 2 * MAX_BATCH_SIZE) {
                                this.batchThresholdReached.compareAndSet(false, true);
                            }
                        }
                    }
                }
                finally {
                    inCount = this.inFlightCount.decrementAndGet();
                }
                if (this.batchThresholdReached.get() && inCount == 0 && this.alreadySent.compareAndSet(false, true)) {
                    if (_statsLogger.isLoggable(Level.FINE)) {
                        _statsLogger.log(Level.FINE, "doAddOrRemove batchThresholdReached.get()=" + this.batchThresholdReached.get() + "; inFlightCount = " + inCount + "; ");
                        _statsLogger.log(Level.FINE, "Sending batch# " + this.myBatchNumber + " to " + ReplicationCommandTransmitterWithMap.this.targetName + "; wasActive for (" + (System.currentTimeMillis() - this.lastTS) + " millis");
                    }
                    ReplicationCommandTransmitterWithMap.this.asyncReplicationManager.getExecutorService().submit(this);
                    ReplicationCommandTransmitterWithMap.this.dsc.getDataStoreMBean().incrementBatchSentCount();
                }
            }
            return result;
        }

        void flushAndTransmit() {
            ReplicationCommandTransmitterWithMap.this.dsc.getDataStoreMBean().incrementFlushThreadWakeupCount();
            if (!(this.alreadySent.get() || this.map.size() <= 0 && this.removedKeys.size() <= 0)) {
                if (this.lastTS == ReplicationCommandTransmitterWithMap.this.timeStamp) {
                    if (_statsLogger.isLoggable(Level.FINE)) {
                        _statsLogger.log(Level.FINE, "flushAndTransmit will flush data because lastTS = " + this.lastTS + "; timeStamp = " + ReplicationCommandTransmitterWithMap.this.timeStamp + "; lastTS = " + this.lastTS + "; map.size() = " + this.map.size() + "; removedKeys.size() = " + this.removedKeys.size());
                    }
                    boolean completed = false;
                    boolean index = false;
                    NoOpCommand nc = null;
                    while (this.doAddOrRemove(nc = new NoOpCommand(), true)) {
                    }
                    ReplicationCommandTransmitterWithMap.this.dsc.getDataStoreMBean().incrementFlushThreadFlushedCount();
                } else {
                    if (_statsLogger.isLoggable(Level.FINER)) {
                        _statsLogger.log(Level.FINER, "flushAndTransmit will NOT flush data because lastTS = " + this.lastTS + "; timeStamp = " + ReplicationCommandTransmitterWithMap.this.timeStamp + "; lastTS = " + this.lastTS + "; map.size() = " + this.map.size() + "; removedKeys.size() = " + this.removedKeys.size());
                    }
                    ReplicationCommandTransmitterWithMap.this.timeStamp = this.lastTS;
                }
            }
        }

        @Override
        public void run() {
            ReplicationFramePayloadCommand rfCmd = new ReplicationFramePayloadCommand();
            rfCmd.setTargetInstance(ReplicationCommandTransmitterWithMap.this.targetName);
            try {
                int size = this.map.size();
                for (Object obj : this.map.values()) {
                    Command cmd = (Command)obj;
                    if (cmd.getOpcode() == 102) continue;
                    rfCmd.addComamnd(cmd);
                }
                rfCmd.setRemovedKeys(this.removedKeys);
                ReplicationCommandTransmitterWithMap.this.dsc.getCommandManager().execute(rfCmd);
            }
            catch (IOException ioEx) {
                _logger.log(Level.WARNING, "Batch operation (ASyncCommandList failed...", ioEx);
            }
        }
    }
}

