/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.adapter.store.commands.LoadResponseCommand;
import org.shoal.adapter.store.commands.SaveCommand;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.api.ObjectInputStreamWithLoader;
import org.shoal.ha.cache.impl.store.DataStoreEntry;

public abstract class DataStoreEntryUpdater<K, V> {
    protected static final transient Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.save");
    protected DataStoreContext<K, V> ctx;

    public void initialize(DataStoreContext<K, V> ctx) {
        this.ctx = ctx;
        _logger.log(Level.FINE, "** INITIALIZED DSEUpdater: " + this.getClass().getName());
    }

    protected byte[] captureState(V v) throws DataStoreException {
        byte[] result = null;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(v);
            oos.close();
            result = bos.toByteArray();
        }
        catch (Exception ex) {
            throw new DataStoreException("Error during prepareToTransmit()", ex);
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception ex) {}
            try {
                bos.close();
            }
            catch (Exception ex) {}
        }
        return result;
    }

    protected V deserializeV(byte[] rawV) throws DataStoreException {
        ClassLoader loader = this.ctx.getClassLoader();
        Object v = null;
        ByteArrayInputStream bis = new ByteArrayInputStream(rawV);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStreamWithLoader(bis, loader);
            v = ois.readObject();
        }
        catch (Exception ex) {
            throw new DataStoreException(ex);
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception ex) {}
            try {
                bis.close();
            }
            catch (Exception ex) {}
        }
        return (V)v;
    }

    protected void updateMetaInfoInDataStoreEntry(DataStoreEntry<K, V> entry, SaveCommand<K, V> cmd) {
        entry.setVersion(cmd.getVersion());
        entry.setLastAccessedAt(cmd.getLastAccessedAt());
        entry.setMaxIdleTime(cmd.getMaxIdleTime());
    }

    protected void printEntryInfo(String msg, DataStoreEntry<K, V> entry, K key) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "executeSave:" + msg + " key = " + key + "; entry.version = " + entry.getVersion() + " ; entry.lastAccess = " + entry.getLastAccessedAt() + "; entry.maxIdle = " + entry.getMaxIdleTime());
        }
    }

    public abstract SaveCommand<K, V> createSaveCommand(DataStoreEntry<K, V> var1, K var2, V var3);

    public abstract LoadResponseCommand<K, V> createLoadResponseCommand(DataStoreEntry<K, V> var1, K var2, long var3) throws DataStoreException;

    public abstract void executeSave(DataStoreEntry<K, V> var1, SaveCommand<K, V> var2) throws DataStoreException;

    public abstract V getV(DataStoreEntry<K, V> var1) throws DataStoreException;

    public abstract V extractVFrom(LoadResponseCommand<K, V> var1) throws DataStoreException;

    public abstract byte[] getState(V var1) throws DataStoreException;
}

