/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.grizzly;

import com.sun.enterprise.mgmt.transport.BufferUtils;
import com.sun.enterprise.mgmt.transport.ByteBuffersBuffer;
import com.sun.enterprise.mgmt.transport.Message;
import com.sun.enterprise.mgmt.transport.MessageImpl;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyUtil;
import com.sun.enterprise.mgmt.transport.grizzly.ParserFilter;
import com.sun.grizzly.ProtocolParser;
import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.util.WorkerThread;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GrizzlyMessageProtocolParser
implements ProtocolParser<Message> {
    private static final Logger LOG = GrizzlyUtil.getLogger();
    private static final int MIN_BUFFER_FREE_SPACE = 1024;
    private SSLConfig sslConfig;
    private final ByteBuffersBuffer workBuffer = new ByteBuffersBuffer();
    private Message message;
    private ByteBuffer lastBuffer;
    private boolean error;
    private int messageLength;
    private boolean justParsedMessage;
    static volatile Level DEBUG_LEVEL = Level.FINE;
    static volatile boolean DEBUG_ENABLED = false;

    protected GrizzlyMessageProtocolParser() {
    }

    protected GrizzlyMessageProtocolParser(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        if (sslConfig != null) {
            throw new UnsupportedOperationException("GrizzlyMessageProtocolParser: sslConfig is not yet supported");
        }
    }

    public static ParserFilter createParserProtocolFilter(final SSLConfig sslConfig) {
        return new ParserFilter(){

            public ProtocolParser newProtocolParser() {
                return new GrizzlyMessageProtocolParser(sslConfig);
            }
        };
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isExpectingMoreData() {
        boolean isExpectingMoreData;
        boolean bl = isExpectingMoreData = this.workBuffer.hasRemaining() && !this.justParsedMessage && !this.error;
        if (DEBUG_ENABLED && LOG.isLoggable(DEBUG_LEVEL)) {
            LOG.log(DEBUG_LEVEL, this.logState("isExpectingMoreData() return " + isExpectingMoreData));
        }
        return isExpectingMoreData;
    }

    public boolean hasMoreBytesToParse() {
        boolean hasMoreBytesToParse;
        boolean bl = hasMoreBytesToParse = this.workBuffer.hasRemaining() && this.justParsedMessage && !this.error;
        if (DEBUG_ENABLED && LOG.isLoggable(DEBUG_LEVEL)) {
            LOG.log(DEBUG_LEVEL, this.logState("hasMoreBytesToParse() return " + hasMoreBytesToParse));
        }
        return hasMoreBytesToParse;
    }

    public Message getNextMessage() {
        if (DEBUG_ENABLED && LOG.isLoggable(DEBUG_LEVEL)) {
            LOG.log(DEBUG_LEVEL, this.logState("getNextMessage() - enter"));
        }
        Message nextMsg = null;
        if (this.error) {
            this.workBuffer.dispose();
        } else {
            nextMsg = this.message;
            this.justParsedMessage = true;
        }
        this.message = null;
        this.messageLength = 0;
        if (DEBUG_ENABLED && LOG.isLoggable(DEBUG_LEVEL)) {
            LOG.log(DEBUG_LEVEL, this.logState("getNextMessage() - exit"));
        }
        return nextMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNextMessage() {
        this.justParsedMessage = false;
        String partialReason = "";
        boolean hasMessage = false;
        if (DEBUG_ENABLED && LOG.isLoggable(DEBUG_LEVEL)) {
            LOG.log(DEBUG_LEVEL, this.logState("hasNextMessage() - enter"));
        }
        try {
            if (this.message == null) {
                if (this.workBuffer.remaining() < 16) {
                    this.messageLength = 0;
                    if (DEBUG_ENABLED && LOG.isLoggable(DEBUG_LEVEL)) {
                        partialReason = "isPartialMsg:not enough buffer for msg header";
                    }
                } else {
                    MessageImpl incomingMessage = new MessageImpl();
                    this.messageLength = incomingMessage.parseHeader(this.workBuffer, this.workBuffer.position());
                    this.message = incomingMessage;
                }
            }
            if (this.message != null && this.messageLength > 0) {
                if (this.messageLength + 16 > MessageImpl.getMaxMessageLength()) {
                    throw new Exception("too large message. request-size=" + (this.messageLength + 16) + " max-size=" + MessageImpl.getMaxMessageLength());
                }
                int totalMsgLength = 16 + this.messageLength;
                if (this.workBuffer.remaining() < totalMsgLength) {
                    if (DEBUG_ENABLED && LOG.isLoggable(DEBUG_LEVEL)) {
                        partialReason = "isPartialMsg:not enough buffer for msg length";
                    }
                } else {
                    int pos = this.workBuffer.position();
                    this.message.parseMessage(this.workBuffer, this.workBuffer.position() + 16, this.messageLength);
                    this.workBuffer.position(pos + totalMsgLength);
                    hasMessage = true;
                }
            }
        }
        catch (Throwable t) {
            if (DEBUG_ENABLED && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, this.logState("hasNextMessage() - exit with error"), t);
            }
            this.error = true;
        }
        finally {
            if (!this.error && DEBUG_ENABLED && LOG.isLoggable(DEBUG_LEVEL)) {
                LOG.log(DEBUG_LEVEL, this.logState("hasNextMessage() - exit" + partialReason));
            }
        }
        return hasMessage;
    }

    public void startBuffer(ByteBuffer bb) {
        this.justParsedMessage = false;
        this.error = false;
        bb.flip();
        if (bb == this.lastBuffer) {
            this.workBuffer.calcCapacity();
            this.workBuffer.limit(this.workBuffer.capacity());
        } else {
            this.lastBuffer = bb;
            this.workBuffer.append(this.lastBuffer);
        }
        if (DEBUG_ENABLED && LOG.isLoggable(DEBUG_LEVEL)) {
            LOG.log(DEBUG_LEVEL, this.logState("startBuffer"));
        }
    }

    public boolean releaseBuffer() {
        boolean hasRemaining;
        if (DEBUG_ENABLED && LOG.isLoggable(DEBUG_LEVEL)) {
            LOG.log(DEBUG_LEVEL, this.logState("releaseBuffer - enter"));
        }
        if (!(hasRemaining = this.workBuffer.hasRemaining()) || this.error) {
            if (this.lastBuffer != null) {
                this.lastBuffer.clear();
            }
            this.workBuffer.dispose();
            this.messageLength = 0;
            this.lastBuffer = null;
            this.error = false;
        } else {
            this.compactBuffers();
        }
        if (DEBUG_ENABLED && LOG.isLoggable(DEBUG_LEVEL)) {
            LOG.log(DEBUG_LEVEL, this.logState("releaseBuffer - exit"));
        }
        return hasRemaining;
    }

    private void compactBuffers() {
        this.workBuffer.trimLeft();
        int workerBufferRemaining = this.workBuffer.remaining();
        int lastBufferRemaining = this.lastBuffer.remaining();
        int lastBufferFreeSpace = this.lastBuffer.capacity() - lastBufferRemaining;
        if (lastBufferFreeSpace < 1024) {
            ((WorkerThread)Thread.currentThread()).setByteBuffer(null);
        } else {
            if (workerBufferRemaining < lastBufferRemaining) {
                this.lastBuffer.position(this.lastBuffer.limit() - workerBufferRemaining);
                this.lastBuffer.compact();
                this.lastBuffer.flip();
                BufferUtils.setPositionLimit(this.workBuffer, 0, workerBufferRemaining);
                this.workBuffer.calcCapacity();
            }
            this.lastBuffer.position(this.lastBuffer.limit());
            this.lastBuffer.limit(this.lastBuffer.capacity());
        }
    }

    private String logState(String where) {
        StringBuilder result = new StringBuilder(40);
        result.append(where);
        result.append(" Thread:" + Thread.currentThread().getName());
        if (this.workBuffer != null) {
            result.append(",workerBuffer:" + this.workBuffer);
            result.append(",lastBuffer:" + this.lastBuffer);
        }
        result.append(",justParsedMessage:" + this.justParsedMessage);
        result.append(",error:" + this.error);
        result.append(",msg size:" + this.messageLength);
        result.append(",message: " + this.message);
        return result.toString();
    }
}

