/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.grizzly;

import com.sun.enterprise.mgmt.transport.NetworkUtility;
import com.sun.enterprise.mgmt.transport.grizzly.MulticastConnectorHandler;
import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.CallbackHandlerSelectionKeyAttachment;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.ConnectorInstanceHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.ReusableUDPSelectorHandler;
import com.sun.grizzly.Role;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.async.UDPAsyncQueueReader;
import com.sun.grizzly.async.UDPAsyncQueueWriter;
import com.sun.grizzly.util.Copyable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.Callable;
import java.util.logging.Level;

public class MulticastSelectorHandler
extends ReusableUDPSelectorHandler {
    private volatile InetAddress multicastAddress;
    private volatile NetworkInterface anInterface;
    private Object membershipKey;
    private final Method joinMethod;
    private final Method openMethod;
    private final Class standardProtocolFamilyClass;
    private Object protocolFamilyOfMulticastAddress;

    public MulticastSelectorHandler() {
        Method method;
        block10: {
            try {
                this.anInterface = NetworkUtility.getFirstNetworkInterface();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            method = null;
            try {
                method = DatagramChannel.class.getMethod("join", InetAddress.class, NetworkInterface.class);
            }
            catch (Throwable t) {
                method = null;
                if (!this.logger.isLoggable(Level.FINEST)) break block10;
                this.logger.log(Level.FINEST, "this JDK doesn't support DatagramChannel#join(InetAddress, NetworkInterface)", t);
            }
        }
        this.joinMethod = method;
        Class<?> standardProtocolFamily = null;
        Class<?> protocolFamilyClass = null;
        if (this.joinMethod != null) {
            method = null;
            try {
                standardProtocolFamily = Class.forName("java.net.StandardProtocolFamily");
                protocolFamilyClass = Class.forName("java.net.ProtocolFamily");
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            if (standardProtocolFamily != null) {
                try {
                    method = DatagramChannel.class.getMethod("open", protocolFamilyClass);
                }
                catch (NoSuchMethodException nsme) {
                    this.logger.warning("unable to find method DatagramChannel.open(" + protocolFamilyClass.getCanonicalName());
                }
            }
        }
        this.standardProtocolFamilyClass = standardProtocolFamily;
        this.openMethod = method;
    }

    public void copyTo(Copyable copy) {
        super.copyTo(copy);
        MulticastSelectorHandler copyHandler = (MulticastSelectorHandler)copy;
        copyHandler.anInterface = this.anInterface;
        copyHandler.membershipKey = this.membershipKey;
    }

    public void preSelect(Context ctx) throws IOException {
        if (this.asyncQueueReader == null) {
            this.asyncQueueReader = new UDPAsyncQueueReader((SelectorHandler)this);
        }
        if (this.asyncQueueWriter == null) {
            this.asyncQueueWriter = new UDPAsyncQueueWriter((SelectorHandler)this);
        }
        if (this.selector == null) {
            this.initSelector(ctx);
        } else {
            this.processPendingOperations(ctx);
        }
    }

    private void initSelector(Context ctx) throws IOException {
        try {
            this.isShutDown.set(false);
            this.connectorInstanceHandler = new ConnectorInstanceHandler.ConcurrentQueueDelegateCIH(this.getConnectorInstanceHandlerDelegate());
            try {
                this.datagramChannel = (DatagramChannel)this.openMethod.invoke((Object)this.datagramChannel, this.protocolFamilyOfMulticastAddress);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Exception occured when tried to open datagram channel with protocol family:" + this.protocolFamilyOfMulticastAddress + " multicastaddress=" + this.multicastAddress, t);
            }
            this.selector = Selector.open();
            if (this.role != Role.CLIENT) {
                this.datagramSocket = this.datagramChannel.socket();
                this.datagramSocket.setReuseAddress(this.reuseAddress);
                this.datagramSocket.bind(new InetSocketAddress(this.getPort()));
                this.datagramChannel.configureBlocking(false);
                this.datagramChannel.register(this.selector, 1);
                this.datagramSocket.setSoTimeout(this.serverTimeout);
                if (this.multicastAddress != null && this.joinMethod != null) {
                    try {
                        this.membershipKey = this.joinMethod.invoke((Object)this.datagramChannel, this.multicastAddress, this.anInterface);
                    }
                    catch (Throwable t) {
                        this.logger.log(Level.WARNING, "Exception occured when tried to join datagram channel with multicast group address" + this.multicastAddress, t);
                    }
                }
            }
            ctx.getController().notifyReady();
        }
        catch (SocketException ex) {
            throw new BindException(ex.getMessage() + ": " + this.getPort());
        }
    }

    public void setMulticastAddress(String multicastAddr) throws UnknownHostException {
        if (multicastAddr != null) {
            this.multicastAddress = InetAddress.getByName(multicastAddr);
            if (this.standardProtocolFamilyClass != null) {
                T[] pfe = this.standardProtocolFamilyClass.getEnumConstants();
                if (this.multicastAddress instanceof Inet4Address) {
                    this.protocolFamilyOfMulticastAddress = pfe[0];
                } else if (this.multicastAddress instanceof Inet6Address) {
                    this.protocolFamilyOfMulticastAddress = pfe[1];
                }
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("setMulticastAddress: multicastAddress=" + this.multicastAddress + " protocolFamilyOfMulticastAddress=" + this.protocolFamilyOfMulticastAddress);
                }
            }
        }
    }

    public void setNetworkInterface(String networkInterfaceName) throws SocketException {
        NetworkInterface anInterface;
        if (networkInterfaceName != null && NetworkUtility.supportsMulticast(anInterface = NetworkInterface.getByName(networkInterfaceName))) {
            this.anInterface = anInterface;
        }
    }

    protected void onConnectOp(Context ctx, TCPSelectorHandler.ConnectChannelOperation connectChannelOp) throws IOException {
        DatagramChannel newDatagramChannel = (DatagramChannel)connectChannelOp.getChannel();
        SocketAddress remoteAddress = connectChannelOp.getRemoteAddress();
        CallbackHandler callbackHandler = connectChannelOp.getCallbackHandler();
        CallbackHandlerSelectionKeyAttachment attachment = new CallbackHandlerSelectionKeyAttachment(callbackHandler);
        SelectionKey key = newDatagramChannel.register(this.selector, 5, attachment);
        attachment.associateKey(key);
        try {
            InetAddress remoteInetAddress = InetAddress.getByName(((InetSocketAddress)remoteAddress).getHostName());
            if (remoteInetAddress.isMulticastAddress()) {
                if (this.role == Role.CLIENT && this.joinMethod != null) {
                    this.joinMethod.invoke((Object)newDatagramChannel, remoteInetAddress, this.anInterface);
                }
            } else {
                newDatagramChannel.connect(remoteAddress);
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, "Exception occured when tried to join datagram channel with multicast group address" + this.multicastAddress, t);
        }
        this.onConnectInterest(key, ctx);
    }

    protected Callable<ConnectorHandler> getConnectorInstanceHandlerDelegate() {
        return new Callable<ConnectorHandler>(){

            @Override
            public ConnectorHandler call() throws Exception {
                return new MulticastConnectorHandler();
            }
        };
    }
}

