/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.base;

import com.sun.enterprise.ee.cms.core.DistributedStateCache;
import com.sun.enterprise.ee.cms.core.GMSCacheable;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSMember;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.RejoinSubevent;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.base.CustomTagNames;
import com.sun.enterprise.ee.cms.impl.base.DistributedStateCacheImpl;
import com.sun.enterprise.ee.cms.impl.base.EventPacket;
import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.ee.cms.impl.base.SystemAdvertisement;
import com.sun.enterprise.ee.cms.impl.base.Utility;
import com.sun.enterprise.ee.cms.impl.common.FailureNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.FailureRecoverySignalImpl;
import com.sun.enterprise.ee.cms.impl.common.FailureSuspectedSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.impl.common.GroupLeadershipNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.JoinNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.JoinedAndReadyNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.PlannedShutdownSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.RecoveryTargetSelector;
import com.sun.enterprise.ee.cms.impl.common.Router;
import com.sun.enterprise.ee.cms.impl.common.SignalPacket;
import com.sun.enterprise.ee.cms.impl.common.ViewWindow;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.ee.cms.spi.MemberStates;
import com.sun.enterprise.mgmt.ClusterView;
import com.sun.enterprise.mgmt.ClusterViewEvents;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class ViewWindowImpl
implements ViewWindow,
Runnable {
    private GMSContext ctx;
    private static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private static final ResourceBundle gmsRb = logger.getResourceBundle();
    private static final int MAX_VIEWS = 100;
    private static final List<GMSMember> EMPTY_GMS_MEMBER_LIST = new ArrayList<GMSMember>();
    private final List<List<GMSMember>> views = new Vector<List<GMSMember>>();
    private List<Signal> signals = new Vector<Signal>();
    private final List<String> currentCoreMembers = new ArrayList<String>();
    private final List<String> allCurrentMembers = new ArrayList<String>();
    private static final String CORETYPE = "CORE";
    private static final int SYNCWAITMILLIS = 3000;
    private static final String REC_PROGRESS_STATE = GroupManagementService.RECOVERY_STATE.RECOVERY_IN_PROGRESS.toString();
    private static final String REC_APPOINTED_STATE = GroupManagementService.RECOVERY_STATE.RECOVERY_SERVER_APPOINTED.toString();
    private final ArrayBlockingQueue<EventPacket> viewQueue;
    private final String groupName;
    private ConcurrentHashMap<String, MemberStates> pendingGroupJoins = new ConcurrentHashMap();

    ViewWindowImpl(String groupName, ArrayBlockingQueue<EventPacket> viewQueue) {
        this.groupName = groupName;
        this.viewQueue = viewQueue;
    }

    private GMSContext getGMSContext() {
        if (this.ctx == null) {
            this.ctx = GMSContextFactory.getGMSContext(this.groupName);
        }
        return this.ctx;
    }

    public void setPendingGroupJoins(Set<String> memberTokens) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("setPendingGroupJoins: members:" + memberTokens);
        }
        for (String member : memberTokens) {
            this.pendingGroupJoins.put(member, MemberStates.UNKNOWN);
        }
    }

    public boolean isGroupStartup(String member) {
        boolean result = false;
        MemberStates state = null;
        if (member != null) {
            state = this.pendingGroupJoins.get(member);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("pendingGroupJoins member:" + member + " state=" + state);
            }
            if (state != null) {
                switch (state) {
                    case UNKNOWN: 
                    case ALIVE: {
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("isGroupStartup: member: " + member + " result:" + result + " isGroupStartupComplete:" + this.isGroupStartupComplete());
        }
        return result;
    }

    public boolean setGroupStartupState(String member, MemberStates state) {
        boolean result = false;
        switch (state) {
            case READY: 
            case ALIVEANDREADY: {
                MemberStates value = this.pendingGroupJoins.remove(member);
                result = value != null;
                break;
            }
            case ALIVE: {
                result = this.pendingGroupJoins.replace(member, MemberStates.UNKNOWN, MemberStates.ALIVE);
                break;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("setGroupStartupState: member: " + member + " newState:" + state + " result:" + result + " isGroupStartupComplete:" + this.isGroupStartupComplete() + " pendingMembers:" + this.pendingGroupJoins.keySet().toString());
        }
        return result;
    }

    public boolean isGroupStartupComplete() {
        boolean result;
        boolean bl = result = this.pendingGroupJoins.size() == 0;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("isGroupStartupComplete: result=" + result + " pendingJoinedAndReadys=" + this.pendingGroupJoins.size());
        }
        return result;
    }

    @Override
    public void run() {
        boolean alreadyLogged = false;
        while (!this.getGMSContext().isShuttingDown()) {
            EventPacket packet = null;
            try {
                int vqSize = this.viewQueue.size();
                if (vqSize > 0) {
                    logger.log(Level.FINE, "viewQueue size before take " + vqSize + " for group: " + this.groupName);
                }
                if ((packet = this.viewQueue.take()) != null) {
                    logger.log(Level.FINE, "ViewWindow : processing a received view " + (Object)((Object)packet.getClusterViewEvent()) + " for group:" + this.groupName);
                    this.newViewObserved(packet);
                    alreadyLogged = false;
                    continue;
                }
                if (alreadyLogged || !logger.isLoggable(Level.FINER)) continue;
                logger.finer("viewQueue poll timeout after 30 seconds for group: " + this.groupName);
                alreadyLogged = true;
            }
            catch (InterruptedException e) {
                logger.log(Level.FINEST, e.getLocalizedMessage());
            }
            catch (Throwable t) {
                String packetInfo = packet == null ? "<null>" : packet.toString();
                logger.log(Level.WARNING, "view.window.eventhandler.exception", new Object[]{packetInfo});
                logger.log(Level.WARNING, "stack trace", t);
            }
        }
        logger.log(Level.INFO, "view.window.thread.terminated", new Object[]{this.groupName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newViewObserved(EventPacket packet) {
        GMSMember member = Utility.getGMSMember(packet.getSystemAdvertisement());
        List<List<GMSMember>> list = this.views;
        synchronized (list) {
            this.views.add(Collections.unmodifiableList(this.getMemberTokens(packet)));
            if (this.views.size() > 100) {
                this.views.remove(0);
            }
            logger.log(Level.INFO, "membership.snapshot.analysis", new Object[]{packet.getClusterViewEvent().toString(), member.getMemberToken(), member.getGroupName()});
            Signal[] activeSignals = this.analyzeViewChange(packet);
            if (activeSignals.length != 0) {
                this.getGMSContext().getRouter().queueSignals(new SignalPacket(activeSignals));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<GMSMember> getMemberTokens(EventPacket packet) {
        ArrayList<GMSMember> tokens = new ArrayList<GMSMember>();
        StringBuffer sb = new StringBuffer(100);
        List<String> list = this.currentCoreMembers;
        synchronized (list) {
            List<String> list2 = this.allCurrentMembers;
            synchronized (list2) {
                this.currentCoreMembers.clear();
                this.allCurrentMembers.clear();
                ClusterView view = packet.getClusterView();
                int count = 0;
                Iterator<SystemAdvertisement> i$ = view.getView().iterator();
                while (i$.hasNext()) {
                    SystemAdvertisement systemAdvertisement;
                    SystemAdvertisement advert = systemAdvertisement = i$.next();
                    GMSMember member = Utility.getGMSMember(advert);
                    member.setSnapShotId(view.getClusterViewId());
                    sb.append(++count).append(": MemberId: ").append(member.getMemberToken()).append(", MemberType: ").append(member.getMemberType()).append(", Address: ").append(advert.getID().toString()).append('\n');
                    if (member.getMemberType().equals(CORETYPE)) {
                        this.currentCoreMembers.add(new StringBuffer(member.getMemberToken()).append("::").append(member.getStartTime()).toString());
                    }
                    tokens.add(member);
                    this.allCurrentMembers.add(new StringBuffer().append(member.getMemberToken()).append("::").append(member.getStartTime()).toString());
                }
            }
        }
        logger.log(Level.INFO, "view.window.view.change", new Object[]{this.groupName, packet.getClusterViewEvent().toString(), sb.toString()});
        return tokens;
    }

    private Signal[] analyzeViewChange(EventPacket packet) {
        ((Vector)this.signals).removeAllElements();
        ClusterViewEvents events = packet.getClusterViewEvent();
        switch (events) {
            case ADD_EVENT: 
            case NO_LONGER_INDOUBT_EVENT: {
                this.addNewMemberJoins(packet);
                break;
            }
            case CLUSTER_STOP_EVENT: {
                this.addPlannedShutdownSignals(packet);
                break;
            }
            case FAILURE_EVENT: {
                this.addFailureSignals(packet);
                break;
            }
            case IN_DOUBT_EVENT: {
                this.addInDoubtMemberSignals(packet);
                break;
            }
            case JOINED_AND_READY_EVENT: {
                this.addReadyMembers(packet);
                break;
            }
            case MASTER_CHANGE_EVENT: {
                this.analyzeMasterChangeView(packet);
                break;
            }
            case PEER_STOP_EVENT: {
                this.addPlannedShutdownSignals(packet);
                break;
            }
        }
        Signal[] s = new Signal[this.signals.size()];
        return this.signals.toArray(s);
    }

    private void analyzeMasterChangeView(EventPacket packet) {
        SystemAdvertisement advert = packet.getSystemAdvertisement();
        GMSMember member = Utility.getGMSMember(advert);
        String token = member.getMemberToken();
        if (!this.getGMSContext().isWatchdog()) {
            this.addGroupLeadershipNotificationSignal(token, member.getGroupName(), member.getStartTime());
        }
        if (this.views.size() == 1 && !this.getGMSContext().getGroupCommunicationProvider().isDiscoveryInProgress()) {
            this.addNewMemberJoins(packet);
        }
        if (this.views.size() > 1 && packet.getClusterView().getSize() != this.getPreviousView().size()) {
            this.determineAndAddNewMemberJoins();
        }
    }

    private void determineAndAddNewMemberJoins() {
        block5: {
            List<GMSMember> newMembership;
            block4: {
                newMembership = this.getCurrentView();
                if (this.views.size() != 1) break block4;
                if (newMembership.size() <= 1) break block5;
                for (GMSMember member : newMembership) {
                    String token = member.getMemberToken();
                    if (!token.equals(this.getGMSContext().getServerIdentityToken())) {
                        this.syncDSC(token);
                    }
                    if (!member.getMemberType().equalsIgnoreCase(CORETYPE)) continue;
                    this.addJoinNotificationSignal(token, member.getGroupName(), member.getStartTime());
                }
                break block5;
            }
            if (this.views.size() > 1) {
                List<String> oldMembers = this.getTokens(this.getPreviousView());
                for (GMSMember member : newMembership) {
                    String token = member.getMemberToken();
                    if (oldMembers.contains(token)) continue;
                    this.syncDSC(token);
                    if (!member.getMemberType().equalsIgnoreCase(CORETYPE)) continue;
                    this.addJoinNotificationSignal(token, member.getGroupName(), member.getStartTime());
                }
            }
        }
    }

    private List<String> getTokens(List<GMSMember> oldMembers) {
        ArrayList<String> tokens = new ArrayList<String>();
        for (GMSMember member : oldMembers) {
            tokens.add(member.getMemberToken());
        }
        return tokens;
    }

    private void addPlannedShutdownSignals(EventPacket packet) {
        GMSConstants.shutdownType shutdownType2;
        SystemAdvertisement advert = packet.getSystemAdvertisement();
        String token = advert.getName();
        DistributedStateCache dsc = this.getGMSContext().getDistributedStateCache();
        if (packet.getClusterViewEvent().equals((Object)ClusterViewEvents.CLUSTER_STOP_EVENT)) {
            shutdownType2 = GMSConstants.shutdownType.GROUP_SHUTDOWN;
        } else {
            shutdownType2 = GMSConstants.shutdownType.INSTANCE_SHUTDOWN;
            if (dsc != null) {
                dsc.removeAllForMember(token);
            }
        }
        logger.log(Level.INFO, "plannedshutdownevent.announcement", new Object[]{token, shutdownType2, this.groupName});
        String gName = Utility.getGroupName(advert);
        if (gName == null) {
            logger.log(Level.WARNING, "systemadv.not.contain.customtag", (Object)CustomTagNames.GROUP_NAME);
            return;
        }
        long startTime = Utility.getStartTime(advert);
        if (startTime == -1L) {
            logger.log(Level.WARNING, "systemadv.not.contain.customtag", (Object)CustomTagNames.START_TIME);
            return;
        }
        this.signals.add((Signal)new PlannedShutdownSignalImpl(token, gName, startTime, shutdownType2));
    }

    private void addInDoubtMemberSignals(EventPacket packet) {
        SystemAdvertisement advert = packet.getSystemAdvertisement();
        GMSMember member = Utility.getGMSMember(advert);
        String token = member.getMemberToken();
        this.getGMSContext().addToSuspectList(token);
        logger.log(Level.INFO, "gms.failureSuspectedEventReceived", new Object[]{token, this.groupName});
        this.signals.add((Signal)new FailureSuspectedSignalImpl(token, member.getGroupName(), member.getStartTime()));
    }

    private void addFailureSignals(EventPacket packet) {
        SystemAdvertisement advert = packet.getSystemAdvertisement();
        GMSMember member = Utility.getGMSMember(advert);
        String failedMember = member.getMemberToken();
        if (member.getMemberType().equalsIgnoreCase(CORETYPE)) {
            List<GMSMember> previousView = this.getPreviousViewContaining(failedMember);
            logger.log(Level.INFO, "member.failed", new Object[]{failedMember, member.getGroupName()});
            this.generateFailureRecoverySignals(previousView, failedMember, member.getGroupName(), member.getStartTime());
            if (this.getGMSContext().getRouter().isFailureNotificationAFRegistered()) {
                this.signals.add((Signal)new FailureNotificationSignalImpl(failedMember, member.getGroupName(), member.getStartTime()));
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("removing newly added node from the suspected list..." + failedMember);
            }
            this.getGMSContext().removeFromSuspectList(failedMember);
        }
    }

    private List<GMSMember> getPreviousViewContaining(String member) {
        int MAX_VIEWS_IN_PAST = 10;
        List<GMSMember> found = this.getPreviousView();
        for (int i = 2; i < 12 && this.views.size() - i >= 0; ++i) {
            List<GMSMember> current = this.views.get(this.views.size() - i);
            if (!ViewWindowImpl.viewContains(current, member)) continue;
            found = current;
            break;
        }
        return found;
    }

    private static boolean viewContains(List<GMSMember> view, String member) {
        boolean found = false;
        for (GMSMember current : view) {
            if (current.getMemberToken().compareTo(member) != 0) continue;
            found = true;
            break;
        }
        return found;
    }

    private void generateFailureRecoverySignals(List<GMSMember> oldMembership, String token, String groupName, Long startTime) {
        Router router = this.getGMSContext().getRouter();
        if (router.isFailureRecoveryAFRegistered()) {
            logger.log(Level.FINE, "Determining the recovery server..");
            if (RecoveryTargetSelector.resolveRecoveryTarget(null, oldMembership, token, this.getGMSContext())) {
                List<String> recInProgressMembers = this.getRecoveriesInProgressByFailedMember(token);
                List<String> recApptsHeldByFailedMember = this.getRecApptsHeldByFailedMember(token);
                for (String comp : router.getFailureRecoveryComponents()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, new StringBuffer("adding failure recovery signal for component=").append(comp).toString());
                    }
                    this.signals.add((Signal)new FailureRecoverySignalImpl(comp, token, groupName, startTime));
                    if (!recInProgressMembers.isEmpty()) {
                        for (String fToken : recInProgressMembers) {
                            this.signals.add((Signal)new FailureRecoverySignalImpl(comp, fToken, groupName, 0L));
                        }
                    }
                    if (recApptsHeldByFailedMember.isEmpty()) continue;
                    for (String fToken : recApptsHeldByFailedMember) {
                        this.signals.add((Signal)new FailureRecoverySignalImpl(comp, fToken, groupName, 0L));
                    }
                }
            }
        }
    }

    private List<String> getRecApptsHeldByFailedMember(String token) {
        ArrayList<String> tokens = new ArrayList<String>();
        DistributedStateCache dsc = this.getGMSContext().getDistributedStateCache();
        Map entries = dsc.getFromCache((Object)token);
        for (Map.Entry entry : entries.entrySet()) {
            GMSCacheable gmsCacheable = (GMSCacheable)entry.getKey();
            if (!token.equals(gmsCacheable.getMemberTokenId()) || token.equals(gmsCacheable.getKey()) || !(entry.getValue() instanceof String) || !((String)entry.getValue()).startsWith(REC_APPOINTED_STATE) || this.currentCoreMembers.contains(gmsCacheable.getKey())) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, new StringBuffer("Failed Member ").append(token).append(" was appointed for recovery of ").append(gmsCacheable.getKey()).append(" when ").append(token).append(" failed. ").append("Adding to recovery-appointed list...").toString());
            }
            tokens.add((String)gmsCacheable.getKey());
            try {
                dsc.removeFromCache(gmsCacheable.getComponentName(), gmsCacheable.getMemberTokenId(), (Serializable)gmsCacheable.getKey());
                RecoveryTargetSelector.setRecoverySelectionState(this.getGMSContext().getServerIdentityToken(), (String)gmsCacheable.getKey(), this.getGMSContext().getGroupName());
            }
            catch (GMSException e) {
                logger.log(Level.INFO, e.getLocalizedMessage(), e);
            }
        }
        return tokens;
    }

    private List<String> getRecoveriesInProgressByFailedMember(String token) {
        ArrayList<String> tokens = new ArrayList<String>();
        DistributedStateCache dsc = this.getGMSContext().getDistributedStateCache();
        Map entries = dsc.getFromCache((Object)token);
        for (Map.Entry entry : entries.entrySet()) {
            GMSCacheable gmsCacheable = (GMSCacheable)entry.getKey();
            if (!token.equals(gmsCacheable.getMemberTokenId()) || token.equals(gmsCacheable.getKey()) || !(entry.getValue() instanceof String) || !((String)entry.getValue()).startsWith(REC_PROGRESS_STATE)) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, new StringBuffer("Failed Member ").append(token).append(" had recovery-in-progress for ").append(gmsCacheable.getKey()).append(" when ").append(token).append(" failed. ").toString());
            }
            tokens.add((String)gmsCacheable.getKey());
            RecoveryTargetSelector.setRecoverySelectionState(this.getGMSContext().getServerIdentityToken(), (String)gmsCacheable.getKey(), this.getGMSContext().getGroupName());
        }
        return tokens;
    }

    private void addNewMemberJoins(EventPacket packet) {
        SystemAdvertisement advert = packet.getSystemAdvertisement();
        GMSMember member = Utility.getGMSMember(advert);
        String token = member.getMemberToken();
        List<String> oldMembers = this.getTokens(this.getPreviousView());
        RejoinSubevent rjse = this.getGMSContext().getInstanceRejoins().get(packet.getSystemAdvertisement().getName());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "addNewMemberJoins: member: " + member + " joined group time:" + new Date(Utility.getStartTime(advert)) + " rejoin subevent=" + rjse);
        }
        if (this.isCoordinator() || !oldMembers.contains(token) || rjse != null || token.compareTo(this.getGMSContext().getServerIdentityToken()) == 0) {
            if (packet.getClusterView().getSize() > 1) {
                this.syncDSC(advert.getID());
            }
            if (member.isCore()) {
                this.addJoinNotificationSignal(token, member.getGroupName(), member.getStartTime());
            }
        }
    }

    private void addReadyMembers(EventPacket packet) {
        SystemAdvertisement advert = packet.getSystemAdvertisement();
        String token = advert.getName();
        GMSMember member = Utility.getGMSMember(advert);
        if (member.isCore()) {
            this.addJoinedAndReadyNotificationSignal(token, member.getGroupName(), member.getStartTime());
        }
    }

    private void addJoinedAndReadyNotificationSignal(String token, String groupName, long startTime) {
        String rejoinTxt = "";
        RejoinSubevent rse = this.ctx.getInstanceRejoins().get(token);
        if (rse != null) {
            rejoinTxt = gmsRb.getString("viewwindow.rejoining") + " " + rse.toString();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("addJoinedAndReadyNotificationSignal setting rejoin subevent for token '%s'", token));
            }
        }
        GMSConstants.startupType startupState = this.isGroupStartup(token) ? GMSConstants.startupType.GROUP_STARTUP : GMSConstants.startupType.INSTANCE_STARTUP;
        String msg = MessageFormat.format(gmsRb.getString("viewwindow.adding.joined.ready.member"), token, groupName, startupState.toString(), rejoinTxt);
        logger.log(Level.INFO, msg);
        JoinedAndReadyNotificationSignalImpl jarSignal = new JoinedAndReadyNotificationSignalImpl(token, this.getCurrentCoreMembers(), this.getAllCurrentMembers(), groupName, startTime, startupState, rse);
        this.signals.add((Signal)jarSignal);
    }

    private void addJoinNotificationSignal(String token, String groupName, long startTime) {
        String rejoinTxt = "";
        RejoinSubevent rse = this.ctx.getInstanceRejoins().get(token);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "addJoinNotificationSignal member:" + token + " RejoinSubevent:" + rse);
        }
        if (rse != null) {
            rejoinTxt = MessageFormat.format(gmsRb.getString("viewwindow.rejoining"), rse.toString());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("addJoinNotificationSignal setting rejoin subevent for token '%s'", token));
            }
        }
        GMSConstants.startupType startupState = this.isGroupStartup(token) ? GMSConstants.startupType.GROUP_STARTUP : GMSConstants.startupType.INSTANCE_STARTUP;
        this.setGroupStartupState(token, MemberStates.ALIVE);
        String msg = MessageFormat.format(gmsRb.getString("viewwindow.adding.join.member"), token, groupName, startupState.toString(), rejoinTxt);
        logger.log(Level.INFO, msg);
        JoinNotificationSignalImpl jnSignal = new JoinNotificationSignalImpl(token, this.getCurrentCoreMembers(), this.getAllCurrentMembers(), groupName, startTime, startupState, rse);
        this.signals.add((Signal)jnSignal);
    }

    private void addGroupLeadershipNotificationSignal(String token, String groupName, long startTime) {
        logger.log(Level.INFO, "view.window.groupleader.notify", new Object[]{token, groupName});
        this.signals.add((Signal)new GroupLeadershipNotificationSignalImpl(token, this.getPreviousView(), this.getCurrentView(), this.getCurrentCoreMembers(), this.getAllCurrentMembers(), groupName, startTime));
    }

    private void syncDSC(String token) {
        block8: {
            if (this.isCoordinator()) {
                logger.log(Level.FINE, "I am coordinator, performing sync ops on " + token);
                try {
                    DistributedStateCacheImpl dsc = (DistributedStateCacheImpl)this.getGMSContext().getDistributedStateCache();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "got DSC ref " + dsc.toString());
                    }
                    Thread.sleep(3000L);
                    logger.log(Level.FINER, "Syncing...");
                    dsc.syncCache(token, true);
                    logger.log(Level.FINER, "Sync request sent..");
                }
                catch (GMSException e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "GMSException during DSC sync " + e.getLocalizedMessage(), e);
                    }
                }
                catch (InterruptedException e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINE)) break block8;
                    logger.log(Level.FINE, "Exception during DSC sync:" + e, e);
                }
            }
        }
    }

    private void syncDSC(PeerID peerid) {
        block9: {
            if (this.isCoordinator()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "I am coordinator, performing sync ops on member:" + peerid.getInstanceName() + " peerid:" + peerid);
                }
                try {
                    DistributedStateCacheImpl dsc = (DistributedStateCacheImpl)this.getGMSContext().getDistributedStateCache();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "got DSC ref " + dsc.toString());
                    }
                    Thread.sleep(3000L);
                    logger.log(Level.FINER, "Syncing...");
                    dsc.syncCache(peerid, true);
                    logger.log(Level.FINER, "Sync request sent..");
                }
                catch (GMSException e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "GMSException during DSC sync " + e.getLocalizedMessage(), e);
                    }
                }
                catch (InterruptedException e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINE)) break block9;
                    logger.log(Level.FINE, "Exception during DSC sync:" + e, e);
                }
            }
        }
    }

    @Override
    public boolean isCoordinator() {
        return this.getGMSContext().getGroupCommunicationProvider().isGroupLeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GMSMember> getPreviousView() {
        List<GMSMember> result = EMPTY_GMS_MEMBER_LIST;
        List<List<GMSMember>> list = this.views;
        synchronized (list) {
            int INDEX = this.views.size() - 2;
            if (INDEX >= 0) {
                result = this.views.get(INDEX);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GMSMember> getCurrentView() {
        List<GMSMember> result = EMPTY_GMS_MEMBER_LIST;
        List<List<GMSMember>> list = this.views;
        synchronized (list) {
            int INDEX = this.views.size() - 1;
            if (INDEX >= 0) {
                result = this.views.get(INDEX);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getCurrentCoreMembers() {
        ArrayList<String> retVal = new ArrayList<String>();
        List<String> list = this.currentCoreMembers;
        synchronized (list) {
            for (String member : this.currentCoreMembers) {
                member = member.substring(0, member.indexOf("::"));
                retVal.add(member);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllCurrentMembers() {
        ArrayList<String> retVal = new ArrayList<String>();
        List<String> list = this.allCurrentMembers;
        synchronized (list) {
            for (String member : this.allCurrentMembers) {
                member = member.substring(0, member.indexOf("::"));
                retVal.add(member);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getCurrentCoreMembersWithStartTimes() {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> list = this.currentCoreMembers;
        synchronized (list) {
            ret.addAll(this.currentCoreMembers);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllCurrentMembersWithStartTimes() {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> list = this.allCurrentMembers;
        synchronized (list) {
            ret.addAll(this.allCurrentMembers);
        }
        return ret;
    }
}

