/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.bridge;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.v3.server.ApplicationLoaderService;
import com.sun.enterprise.web.WebApplication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class EndpointInfoCollector {
    @Inject
    private Logger logger;
    @Inject
    private Applications allApplications;
    @Inject
    private Habitat habitat;
    @Inject
    private ApplicationLoaderService appLoaderService;
    private static Map<String, List<WebServiceEndpoint>> endpoints = new HashMap<String, List<WebServiceEndpoint>>();

    public void initialize() {
        List applications = this.allApplications.getApplications();
        if (applications != null) {
            for (Application application : applications) {
                this.updateEndpoints(application.getName());
            }
        }
    }

    public List<WebServiceEndpoint> getEndpoints(String appName) {
        this.updateEndpoints(appName);
        return endpoints.get(appName);
    }

    private void updateEndpoints(String appName) {
        ApplicationRegistry appRegistry = (ApplicationRegistry)this.habitat.getComponent(ApplicationRegistry.class);
        ApplicationInfo appInfo = appRegistry.get(appName);
        if (appInfo != null) {
            Collection moduleInfos = appInfo.getModuleInfos();
            Set engineRefs = null;
            ArrayList list = new ArrayList();
            for (ModuleInfo moduleInfo : moduleInfos) {
                engineRefs = moduleInfo.getEngineRefs();
                for (EngineRef engineRef : engineRefs) {
                    WebApplication webApp;
                    WebServicesDescriptor webServices;
                    if (!(engineRef.getApplicationContainer() instanceof WebApplication) || (webServices = (webApp = (WebApplication)engineRef.getApplicationContainer()).getDescriptor().getWebServices()) == null || list.containsAll(webServices.getEndpoints())) continue;
                    list.addAll(webServices.getEndpoints());
                }
            }
            if (!list.isEmpty()) {
                endpoints.put(appName, list);
                this.logger.log(Level.FINE, "serviceengine.websvc_endpoints_added", new Object[]{appName});
            }
        }
    }

    public void removeEndpoints(String appName) {
        if (endpoints.containsKey(appName)) {
            endpoints.remove(appName);
        }
    }

    public void mergeEndpointRegistry(Map<String, List<WebServiceEndpoint>> ws_endpoints) {
        ws_endpoints.putAll(endpoints);
        endpoints = ws_endpoints;
    }
}

