/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.bridge;

import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.bridge.JAXRPCRuntimeEndpointHelper;
import com.sun.enterprise.jbi.serviceengine.bridge.RuntimeEndpointInfoRegistry;
import com.sun.enterprise.jbi.serviceengine.core.EndpointRegistry;
import com.sun.enterprise.jbi.serviceengine.core.ServiceEngineEndpoint;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;

public class RuntimeEndpointInfoRegistryImpl
implements RuntimeEndpointInfoRegistry {
    private Hashtable store = new Hashtable(5);
    private static RuntimeEndpointInfoRegistry registry = new RuntimeEndpointInfoRegistryImpl();
    private EndpointRegistry endpointRegistry = EndpointRegistry.getInstance();

    private RuntimeEndpointInfoRegistryImpl() {
    }

    public static RuntimeEndpointInfoRegistry getInstance() {
        return registry;
    }

    public Object getRuntimeEndpointInfo(QName service, String endpoint) throws ServiceEngineException {
        ServiceEngineEndpoint endpt = this.endpointRegistry.get(service, endpoint);
        if (endpt != null) {
            Object runtimeInfo;
            Hashtable runtimeEndpointInfoTable = (Hashtable)this.store.get(service);
            if (runtimeEndpointInfoTable == null) {
                runtimeEndpointInfoTable = new Hashtable();
                this.store.put(service, runtimeEndpointInfoTable);
            }
            if ((runtimeInfo = runtimeEndpointInfoTable.get(endpoint)) == null) {
                runtimeInfo = JAXRPCRuntimeEndpointHelper.populateRuntimeInfo(endpt);
                runtimeEndpointInfoTable.put(endpoint, runtimeInfo);
            }
            return runtimeInfo;
        }
        throw new ServiceEngineException("Endpoint " + endpoint + "not deployed in JBI");
    }

    public void deleteRuntimeEndpointInfo(QName service, String endpoint) {
        Map runtimeInfoTable;
        if (endpoint != null && (runtimeInfoTable = (Map)this.store.get(service)) != null && runtimeInfoTable.get(endpoint) != null) {
            runtimeInfoTable.remove(endpoint);
        }
    }
}

