/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.comm;

import com.sun.enterprise.jbi.serviceengine.comm.MessageExchangeTransportImpl;
import com.sun.enterprise.jbi.serviceengine.comm.UnWrappedMessage;
import com.sun.enterprise.jbi.serviceengine.comm.WrappedMessage;
import com.sun.enterprise.jbi.serviceengine.util.soap.EndpointMetaData;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import java.util.logging.Level;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;

public class ProviderInOnly
extends MessageExchangeTransportImpl {
    protected InOnly me;

    public ProviderInOnly(InOnly me) {
        super((MessageExchange)me);
        this.me = me;
    }

    public NormalizedMessage receiveNormalized() {
        this.msg = this.me.getInMessage();
        this.preReceive();
        return this.msg;
    }

    public UnWrappedMessage receive(EndpointMetaData emd) {
        NormalizedMessage normalizedMessage = this.receiveNormalized();
        UnWrappedMessage unwrappedMessage = null;
        if (normalizedMessage != null) {
            try {
                String operationName = this.me.getOperation().getLocalPart();
                unwrappedMessage = new UnWrappedMessage();
                unwrappedMessage.setNormalizedMessage(normalizedMessage);
                if (normalizedMessage instanceof Fault) {
                    unwrappedMessage.unwrapFault();
                } else {
                    unwrappedMessage.setWSDLMessageType(new QName(emd.getInputMessage(operationName).getQName().getNamespaceURI(), operationName));
                    unwrappedMessage.setWSDLBindingStyle(emd.getBindingStyle(operationName));
                    unwrappedMessage.setWSDLOrderedParts(emd.getInputMessage(operationName).getOrderedParts(null));
                    unwrappedMessage.setWSDLPartBindings(emd.getInputPartBindings(operationName));
                    unwrappedMessage.unwrap();
                }
            }
            catch (Exception ex) {
                logger.log(Level.INFO, ex.getMessage());
            }
        }
        return unwrappedMessage;
    }

    public void sendNormalized() throws Exception {
        this.me.setStatus(ExchangeStatus.DONE);
        this.send();
    }

    public void send(Packet packet, EndpointMetaData emd) throws Exception {
        Message abstractMessage = packet.getMessage();
        if (abstractMessage != null && abstractMessage.isFault()) {
            RuntimeException exObj = null;
            try {
                String operationName = this.me.getOperation().getLocalPart();
                WrappedMessage wrappedMessage = new WrappedMessage();
                wrappedMessage.setAbstractMessage(abstractMessage);
                wrappedMessage.wrapFault(operationName, emd);
            }
            catch (RuntimeException e) {
                exObj = e;
            }
            this.sendError(exObj);
        } else {
            this.sendNormalized();
        }
    }
}

