/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.bridge.transport;

import com.sun.enterprise.jbi.serviceengine.bridge.ServiceEngineFacade;
import com.sun.enterprise.jbi.serviceengine.bridge.ServiceEngineRtObjectFactory;
import com.sun.enterprise.jbi.serviceengine.core.ServiceEngineRuntimeHelper;
import com.sun.xml.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.TransportPipeFactory;
import java.net.URL;
import javax.xml.namespace.QName;
import org.glassfish.api.ContractProvider;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class JBITransportPipeFactory
extends TransportPipeFactory
implements ContractProvider {
    public Pipe doCreate(ClientPipeAssemblerContext context) {
        ServiceEngineFacade facade = ServiceEngineRtObjectFactory.getInstance().getFacade();
        if (facade == null) {
            return null;
        }
        ServiceEngineRuntimeHelper helper = ServiceEngineRuntimeHelper.getRuntime();
        InvocationManager invmgr = helper.getInvocationManager();
        ComponentInvocation inv = invmgr.getCurrentInvocation();
        if (inv == null || inv.getInstance() == null) {
            return null;
        }
        if (this.hasRegisteredEndpointInJBI(facade, context)) {
            return this.createJBITransportPipe(facade, context);
        }
        return null;
    }

    private boolean hasRegisteredEndpointInJBI(ServiceEngineFacade facade, ClientPipeAssemblerContext context) {
        QName serviceName = context.getService().getServiceName();
        String endpointName = context.getWsdlModel().getName().getLocalPart();
        return facade.hasConsumerEP(serviceName, endpointName);
    }

    private Pipe createJBITransportPipe(ServiceEngineFacade facade, ClientPipeAssemblerContext context) {
        URL wsdlURL = context.getService().getWSDLDocumentLocation();
        QName service = context.getService().getServiceName();
        return facade.createJBITransportPipe(context.getBinding(), wsdlURL, service, context.getWsdlModel());
    }
}

