/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.util;

import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMUtil {
    public static final DOMUtil UTIL = new DOMUtil();

    void writeAttributes(XMLStreamReader reader, XMLStreamWriter writer) throws Exception {
        int i;
        int namespaceCount = reader.getNamespaceCount();
        int attributeCount = reader.getAttributeCount();
        for (i = 0; i < namespaceCount; ++i) {
            writer.writeNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
        }
        for (i = 0; i < attributeCount; ++i) {
            String attrNs = reader.getAttributeNamespace(i);
            if (attrNs != null) {
                writer.writeAttribute(attrNs, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
    }

    private void writeAncestorNamespaceAttrs(XMLStreamReader reader, XMLStreamWriter writer, Map<String, String> ancestorNamespaceAttrs) {
        try {
            String prefix = reader.getPrefix();
            String namespace = ancestorNamespaceAttrs.remove(prefix);
            if (namespace != null) {
                writer.writeNamespace(prefix, namespace);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String fixNull(String s) {
        return s == null ? "" : s;
    }

    private String resolvePrefix(Element e, Map<String, String> resolvedPrefixes) {
        String nodePrefix = this.fixNull(e.getPrefix());
        String nodeNamespace = e.getNamespaceURI();
        if (nodeNamespace != null && !resolvedPrefixes.containsKey(nodePrefix)) {
            String attrName = nodePrefix.trim().length() == 0 ? "xmlns" : "xmlns:" + nodePrefix;
            e.setAttribute(attrName, nodeNamespace);
            resolvedPrefixes.put(nodePrefix, nodeNamespace);
        }
        return nodePrefix;
    }

    public void writeNode(XMLStreamReader reader, XMLStreamWriter writer) throws Exception {
        this.writeNode(reader, writer, new HashMap<String, String>());
    }

    public void writeChildren(XMLStreamReader reader, XMLStreamWriter writer) throws Exception {
        this.writeChildren(reader, writer, new HashMap<String, String>());
    }

    public void writeNode(XMLStreamReader reader, XMLStreamWriter writer, Map<String, String> ancestorNamespaceAttrs) throws Exception {
        HashMap<String, String> copyOfANSA = new HashMap<String, String>(ancestorNamespaceAttrs.size());
        copyOfANSA.putAll(ancestorNamespaceAttrs);
        int depth = 0;
        int event = reader.getEventType();
        do {
            switch (event) {
                case 7: {
                    reader.next();
                    this.writeNode(reader, writer, copyOfANSA);
                    break;
                }
                case 1: {
                    String tagName = reader.getPrefix() != null && reader.getPrefix().length() != 0 ? reader.getPrefix() + ":" + reader.getLocalName() : reader.getLocalName();
                    writer.writeStartElement(tagName);
                    this.writeAttributes(reader, writer);
                    this.writeAncestorNamespaceAttrs(reader, writer, copyOfANSA);
                    ++depth;
                    break;
                }
                case 4: {
                    writer.writeCharacters(reader.getText());
                    break;
                }
                case 2: {
                    writer.writeEndElement();
                    --depth;
                }
            }
            event = reader.next();
        } while (depth > 0);
    }

    public void writeChildren(XMLStreamReader reader, XMLStreamWriter writer, Map<String, String> ancestorNamespaceAttrs) throws Exception {
        reader.next();
        while (reader.getEventType() != 2) {
            this.writeNode(reader, writer, ancestorNamespaceAttrs);
        }
        reader.next();
    }

    public void writeNode(Node node, XMLStreamWriter writer) throws Exception {
        this.writeNode(node, writer, new HashMap<String, String>());
    }

    public void writeChildren(XMLStreamWriter writer, Node node) throws Exception {
        NodeList l = node.getChildNodes();
        int size = l.getLength();
        for (int i = 0; i < size; ++i) {
            this.writeNode(l.item(i), writer, new HashMap<String, String>());
        }
    }

    public void writeNode(Node node, XMLStreamWriter writer, Map<String, String> resolvedPrefixes) throws Exception {
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                writer.writeStartDocument();
                this.writeChildren(writer, node, resolvedPrefixes);
                break;
            }
            case 11: {
                this.writeChildren(writer, node, resolvedPrefixes);
                break;
            }
            case 1: {
                Element e = (Element)node;
                String n = e.getTagName();
                String resolvedPrefix = this.resolvePrefix(e, resolvedPrefixes);
                writer.writeStartElement(n);
                NamedNodeMap a = e.getAttributes();
                int size = a.getLength();
                for (int i = 0; i < size; ++i) {
                    Attr att = (Attr)a.item(i);
                    this.writeNode(att, writer, resolvedPrefixes);
                }
                if (e.hasChildNodes()) {
                    this.writeChildren(writer, node, resolvedPrefixes);
                    writer.writeEndElement();
                    resolvedPrefixes.remove(resolvedPrefix);
                    break;
                }
                writer.writeEndElement();
                resolvedPrefixes.remove(resolvedPrefix);
                break;
            }
            case 2: {
                Attr a = (Attr)node;
                writer.writeAttribute(a.getName(), a.getValue());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                writer.writeProcessingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            case 3: {
                writer.writeCharacters(node.getNodeValue());
                break;
            }
            case 4: {
                writer.writeCData(node.getNodeValue());
                break;
            }
            case 8: {
                writer.writeComment(node.getNodeValue());
            }
        }
    }

    private void writeChildren(XMLStreamWriter writer, Node node, Map<String, String> resolvedPrefixes) throws Exception {
        NodeList l = node.getChildNodes();
        int size = l.getLength();
        for (int i = 0; i < size; ++i) {
            this.writeNode(l.item(i), writer, resolvedPrefixes);
        }
    }

    public Element getElement(Document aParentDocument, String aTagName) {
        NodeList nodeList = aParentDocument.getElementsByTagName(aTagName);
        return nodeList != null ? (Element)nodeList.item(0) : null;
    }

    public Element getElement(Element elem, String tagName) {
        NodeList nl = elem.getElementsByTagName(tagName);
        Element childElem = (Element)nl.item(0);
        return childElem;
    }

    public String getElementValue(Document doc, String elemName) {
        String elemVal = null;
        Element elem = this.getElement(doc, elemName);
        elemVal = this.getTextData(elem);
        return elemVal;
    }

    private Text getText(Element aElement) {
        Node node = null;
        aElement.normalize();
        node = aElement.getFirstChild();
        if (node == null || !(node instanceof Text)) {
            node = aElement.getOwnerDocument().createTextNode("");
            aElement.appendChild(node);
        }
        return (Text)node;
    }

    public void setTextData(Element aElement, String aData) {
        this.getText(aElement).setData(aData);
    }

    public String getTextData(Element aElement) {
        return this.getText(aElement).getData();
    }

    public String DOM2String(Document aDocument, Writer aWriter) throws Exception {
        Transformer transformer2;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer2 = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            Object transformer2 = null;
            throw e;
        }
        transformer2.setOutputProperty("method", "xml");
        transformer2.setOutputProperty("omit-xml-declaration", "no");
        transformer2.setOutputProperty("standalone", "yes");
        transformer2.setOutputProperty("cdata-section-elements", "");
        transformer2.setOutputProperty("indent", "no");
        try {
            transformer2.transform(new DOMSource(aDocument), new StreamResult(aWriter));
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw e;
        }
        return aWriter.toString();
    }

    public NodeList getElements(Element aParentElement, String aTagName) {
        return aParentElement.getElementsByTagNameNS(aParentElement.getNamespaceURI(), aTagName);
    }

    public NodeList getElements(Document aParentDocument, String aTagName) {
        return aParentDocument.getElementsByTagNameNS("*", aTagName);
    }

    public NodeList getChildElements(Element aElement, String aElementTagName) {
        NodeList nodeList = aElement.getChildNodes();
        NodeListImpl list = new NodeListImpl();
        int count = nodeList.getLength();
        for (int i = 0; i < count; ++i) {
            String tagName;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(tagName = this.getElementName((Element)node)).equals(aElementTagName)) continue;
            list.add(node);
        }
        return list;
    }

    public String getElementName(Element aElement) {
        String tagName = aElement.getTagName();
        return this.getName(tagName);
    }

    public String getName(String aName) {
        int lastIdx = aName.lastIndexOf(58);
        if (lastIdx >= 0) {
            return aName.substring(lastIdx + 1);
        }
        return aName;
    }

    public static class NodeListImpl
    extends ArrayList
    implements NodeList {
        public int getLength() {
            return this.size();
        }

        public Node item(int aIndex) {
            return (Node)this.get(aIndex);
        }
    }
}

