/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.handlers;

import com.sun.enterprise.jbi.serviceengine.comm.MessageExchangeTransport;
import com.sun.enterprise.jbi.serviceengine.core.ServiceEngineRuntimeHelper;
import com.sun.enterprise.jbi.serviceengine.handlers.JBIHandler;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class JBITransactionHandler
implements JBIHandler {
    private String tx_enable = System.getProperty("com.sun.enterprise.jbi.tx.enable");

    public void handleInbound(MessageExchangeTransport meTransport) throws Exception {
        MessageExchange me = meTransport.getMessageExchange();
        if (!this.isTxEnabled(me)) {
            return;
        }
        this.suspendTx(me);
    }

    public void handleOutbound(MessageExchangeTransport meTransport) throws Exception {
        MessageExchange me = meTransport.getMessageExchange();
        if (!this.isTxEnabled(me)) {
            return;
        }
        this.resumeTx(me);
    }

    protected boolean isTxEnabled(MessageExchange me) {
        return this.tx_enable == null || this.tx_enable.equalsIgnoreCase("true");
    }

    private void suspendTx(MessageExchange me) throws SystemException {
        ServiceEngineRuntimeHelper runtimeHelper = ServiceEngineRuntimeHelper.getRuntime();
        JavaEETransactionManager tm = runtimeHelper.getTransactionManager();
        Transaction tx = tm.getTransaction();
        if (tx != null) {
            if (me.getStatus().equals(ExchangeStatus.ERROR)) {
                tx.setRollbackOnly();
            }
            tx = tm.suspend();
            me.setProperty("javax.jbi.transaction.jta", (Object)tx);
        }
    }

    private void resumeTx(MessageExchange me) throws SystemException, InvalidTransactionException {
        ServiceEngineRuntimeHelper runtimeHelper = ServiceEngineRuntimeHelper.getRuntime();
        JavaEETransactionManager tm = runtimeHelper.getTransactionManager();
        Transaction tx = (Transaction)me.getProperty("javax.jbi.transaction.jta");
        if (tx != null) {
            if (me.getStatus().equals(ExchangeStatus.ERROR)) {
                tx.setRollbackOnly();
            }
            tm.resume(tx);
        }
    }

    private TransactionManager getTM() {
        return null;
    }
}

