/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.util.soap;

import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.comm.DefaultMessageExchangeTransport;
import com.sun.enterprise.jbi.serviceengine.comm.MessageExchangeTransport;
import com.sun.enterprise.jbi.serviceengine.comm.MessageSender;
import com.sun.enterprise.jbi.serviceengine.core.JavaEEServiceEngineContext;
import com.sun.enterprise.jbi.serviceengine.handlers.JBIHandler;
import com.sun.enterprise.jbi.serviceengine.handlers.JBIHandlerFactory;
import com.sun.enterprise.jbi.serviceengine.util.soap.EndpointMetaData;
import com.sun.enterprise.jbi.serviceengine.util.soap.MessageDenormalizerImpl;
import com.sun.enterprise.jbi.serviceengine.util.soap.MessageNormalizerImpl;
import com.sun.enterprise.jbi.serviceengine.util.soap.Operation;
import com.sun.enterprise.jbi.serviceengine.util.soap.SOAPWrapper;
import com.sun.logging.LogDomains;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class MessageExchangeHelper {
    private static Logger logger = LogDomains.getLogger(MessageExchangeHelper.class, (String)"javax.enterprise.system");
    private MessageExchange messageExchange;
    private URL wsdlLocation;
    private QName serviceName;
    private String endpointName;
    private List<JBIHandler> handlers = JBIHandlerFactory.getInstance().getHandlers();
    private static ConcurrentHashMap<String, EndpointMetaData> wsdlCache = new ConcurrentHashMap(11, 0.75f, 4);
    private static String WSDL11 = "http://schemas.xmlsoap.org/wsdl/";

    public void setMessageExchange(MessageExchange messageExchange) {
        this.messageExchange = messageExchange;
    }

    public SOAPMessage denormalizeMessage(boolean inFlag) throws ServiceEngineException {
        SOAPWrapper wrapper;
        this.validateMessageExchange();
        Fault normalizedMsg = null;
        if (inFlag) {
            if (this.isInOutMessageExchange()) {
                InOut inOutExchange = (InOut)this.messageExchange;
                normalizedMsg = inOutExchange.getInMessage();
            } else {
                InOnly inOnlyExchange = (InOnly)this.messageExchange;
                normalizedMsg = inOnlyExchange.getInMessage();
            }
        } else {
            normalizedMsg = this.messageExchange.getFault() != null ? this.messageExchange.getFault() : ((InOut)this.messageExchange).getOutMessage();
        }
        DefaultMessageExchangeTransport meTransport = new DefaultMessageExchangeTransport(this.messageExchange);
        meTransport.setMessage((NormalizedMessage)normalizedMsg);
        this.invokeHandlersForOutbound(meTransport);
        QName operationQName = this.messageExchange.getOperation();
        String pattern = this.messageExchange.getPattern().toString();
        Operation operation = new Operation(operationQName.getLocalPart(), pattern);
        MessageDenormalizerImpl d = new MessageDenormalizerImpl();
        if (this.messageExchange.getFault() != null) {
            wrapper = d.denormalizeFaultMessage(normalizedMsg);
        } else {
            this.unWrapMessage((NormalizedMessage)normalizedMsg, inFlag);
            wrapper = d.denormalizeMessage((NormalizedMessage)normalizedMsg, operation, !inFlag);
        }
        SOAPMessage message = wrapper.getMessage();
        this.printSOAPMessage("Denormalizing in ? " + inFlag + "message :", message);
        return message;
    }

    public boolean isInOutMessageExchange() {
        return this.messageExchange instanceof InOut;
    }

    public void normalizeMessage(SOAPMessage soapMessage, boolean inFlag) throws ServiceEngineException {
        this.validateMessageExchange();
        if (soapMessage != null) {
            this.printSOAPMessage("normalizing in ? " + inFlag + "message :", soapMessage);
            Fault normalizedMsg = null;
            try {
                boolean isFault = soapMessage.getSOAPBody().getFault() != null;
                Object object = normalizedMsg = isFault ? this.messageExchange.createFault() : this.messageExchange.createMessage();
                if (isFault) {
                    SOAPWrapper wrapper = new SOAPWrapper(soapMessage);
                    MessageNormalizerImpl normalizer = new MessageNormalizerImpl();
                    normalizer.normalizeFaultMessage(wrapper, (NormalizedMessage)normalizedMsg);
                } else {
                    this.normalizeAndWrapMessage((NormalizedMessage)normalizedMsg, soapMessage, !inFlag);
                }
                if (isFault) {
                    this.messageExchange.setFault(normalizedMsg);
                } else if (inFlag) {
                    if (this.isInOutMessageExchange()) {
                        ((InOut)this.messageExchange).setInMessage((NormalizedMessage)normalizedMsg);
                    } else {
                        ((InOnly)this.messageExchange).setInMessage((NormalizedMessage)normalizedMsg);
                    }
                } else {
                    ((InOut)this.messageExchange).setOutMessage((NormalizedMessage)normalizedMsg);
                }
                DefaultMessageExchangeTransport meTransport = new DefaultMessageExchangeTransport(this.messageExchange);
                meTransport.setMessage((NormalizedMessage)normalizedMsg);
                this.invokeHandlersForInbound(meTransport);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void unWrapMessage(NormalizedMessage normalizedMsg, boolean server) {
    }

    private void normalizeAndWrapMessage(NormalizedMessage normalizedMsg, SOAPMessage soapMessage, boolean server) {
    }

    private Definition getWsdlDefinition(String wsdl) throws Exception {
        WSDLFactory mFactory = WSDLFactory.newInstance();
        WSDLReader mReader = mFactory.newWSDLReader();
        return mReader.readWSDL(wsdl);
    }

    public MessageExchange getMessageExchange() {
        return this.messageExchange;
    }

    public void initializeMessageExchange(ServiceRefPortInfo portInfo, boolean oneWay) throws ServiceEngineException {
        ServiceReferenceDescriptor serviceRef = portInfo.getServiceReference();
        QName serviceName = serviceRef.getServiceName();
        String endpointName = portInfo.hasWsdlPort() ? portInfo.getWsdlPort().getLocalPart() : portInfo.getName();
        URL wsdlFileUrl = serviceRef.getWsdlFileUrl();
        this.initializeMessageExchange(wsdlFileUrl, serviceName, endpointName, oneWay);
    }

    public void initializeMessageExchange(URL wsdlLocation, QName service, String endpointName, boolean oneWay) throws ServiceEngineException {
        try {
            this.wsdlLocation = wsdlLocation;
            this.serviceName = service;
            this.endpointName = endpointName;
            DeliveryChannel channel = JavaEEServiceEngineContext.getInstance().getDeliveryChannel();
            MessageExchangeFactory factory = channel.createExchangeFactoryForService(this.serviceName);
            InOnly msgExchange = null;
            NormalizedMessage inMsg = null;
            if (oneWay) {
                InOnly inMessageExchange = factory.createInOnlyExchange();
                inMsg = inMessageExchange.createMessage();
                inMessageExchange.setInMessage(inMsg);
                msgExchange = inMessageExchange;
            } else {
                InOut inOutMessageExchange = factory.createInOutExchange();
                inMsg = inOutMessageExchange.createMessage();
                inOutMessageExchange.setInMessage(inMsg);
                msgExchange = inOutMessageExchange;
            }
            msgExchange.setService(this.serviceName);
            this.setMessageExchange((MessageExchange)msgExchange);
        }
        catch (Exception e) {
            throw new ServiceEngineException(e);
        }
    }

    public void handleException(Exception exception) {
        try {
            this.messageExchange.setStatus(ExchangeStatus.ERROR);
            if (this.messageExchange instanceof InOut || this.messageExchange instanceof RobustInOnly) {
                this.normalizeException(exception);
            }
            this.dispatchMessage();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
    }

    public void handleResponse(SOAPMessage response, boolean flag) {
        try {
            if (this.messageExchange instanceof InOut) {
                this.normalizeMessage(response, flag);
            } else if (this.messageExchange instanceof InOnly || this.messageExchange instanceof RobustInOnly) {
                this.messageExchange.setStatus(ExchangeStatus.DONE);
            }
            this.dispatchMessage();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
    }

    public void normalizeException(Exception exception) {
        if (exception != null) {
            try {
                MessageDenormalizerImpl d = new MessageDenormalizerImpl();
                SOAPWrapper soapWrapper = d.denormalizeMessage(exception);
                this.normalizeMessage(soapWrapper.getMessage(), false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void dispatchMessage() throws ServiceEngineException {
        if (this.messageExchange != null) {
            MessageSender messageSender = new MessageSender();
            messageSender.setMessageExchange(this.messageExchange);
            messageSender.send();
            Exception exception = messageSender.getException();
            if (exception != null) {
                throw new ServiceEngineException(exception);
            }
        }
    }

    private void validateMessageExchange() throws ServiceEngineException {
        if (this.messageExchange == null) {
            throw new ServiceEngineException("MessageExchange not set, use setMessageExchange()");
        }
    }

    private Operation getOperation(SOAPMessage soapMessage, QName svcQName, String opName) throws ServiceEngineException {
        try {
            SOAPPart sp = soapMessage.getSOAPPart();
            SOAPEnvelope env = sp.getEnvelope();
            SOAPBody body = env.getBody();
            Node firstChild = body.getFirstChild();
            String namespacePrefix = firstChild.getPrefix();
            String svcNamespace = svcQName.getNamespaceURI();
            String namespaceURI = null;
            namespaceURI = namespacePrefix != null ? env.getNamespaceURI(namespacePrefix) : svcNamespace;
            Operation operation = new Operation(opName, "in-out");
            operation.setStyle("rpc");
            operation.setInputNamespace(namespaceURI);
            operation.setOutputNamespace(namespaceURI);
            return operation;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceEngineException(e.getMessage());
        }
    }

    private void invokeHandlersForInbound(MessageExchangeTransport meTransport) throws ServiceEngineException {
        for (JBIHandler handler : this.handlers) {
            try {
                handler.handleInbound(meTransport);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                throw new ServiceEngineException(e);
            }
        }
    }

    private void invokeHandlersForOutbound(MessageExchangeTransport meTransport) throws ServiceEngineException {
        for (JBIHandler handler : this.handlers) {
            try {
                handler.handleOutbound(meTransport);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                throw new ServiceEngineException(e);
            }
        }
    }

    private EndpointMetaData getEndPointMetaData(String wsdlPath, QName serviceName, String epName) throws Exception {
        String clientCache = System.getProperty("com.sun.enterprise.jbi.se.clientcache");
        if ("false".equalsIgnoreCase(clientCache)) {
            return this.createEndpointMetaData(wsdlPath, serviceName, epName);
        }
        EndpointMetaData emd = wsdlCache.get(wsdlPath);
        if (emd == null) {
            emd = this.createEndpointMetaData(wsdlPath, serviceName, epName);
            wsdlCache.put(wsdlPath, emd);
        }
        return emd;
    }

    private EndpointMetaData createEndpointMetaData(String wsdlPath, QName serviceName, String epName) throws Exception {
        EndpointMetaData emd = new EndpointMetaData(this.getWsdlDefinition(wsdlPath), serviceName, epName);
        emd.resolve();
        return emd;
    }

    protected void printSOAPMessage(String message, SOAPMessage soapMessage) {
        try {
            if (logger.isLoggable(Level.FINE)) {
                System.out.print(message);
                soapMessage.writeTo((OutputStream)System.out);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    protected void printSOAPContent(String message, NormalizedMessage normalizedMessage) {
        Source source;
        if (logger.isLoggable(Level.FINE) && normalizedMessage != null && (source = normalizedMessage.getContent()) != null) {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                System.out.print(message);
                StreamResult result = new StreamResult(System.out);
                transformer.transform(source, result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

