/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.bridge.transport;

import com.sun.enterprise.jbi.serviceengine.bridge.transport.NMRClientConnection;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractPipeImpl;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.namespace.QName;

public class JBITransportPipe
extends AbstractPipeImpl {
    private URL wsdlLocation;
    private QName service;
    private WSDLPort wsdlPort;

    public JBITransportPipe(WSBinding binding, URL wsdlLocation, QName service, WSDLPort wsdlPort) {
        this.setWSDLLocation(wsdlLocation);
        this.setWSDLPort(wsdlPort);
        this.setServiceName(service);
    }

    private JBITransportPipe(JBITransportPipe that, PipeCloner cloner) {
        super((Pipe)that, cloner);
        if (that != null) {
            this.setWSDLLocation(that.getWSDLLocation());
            this.setWSDLPort(that.getWSDLPort());
            this.setServiceName(that.getServiceName());
        }
    }

    public Packet process(Packet request) {
        try {
            boolean isOneWay = request.expectReply == false;
            QName operation = request.getMessage().getOperation(this.wsdlPort).getName();
            String endpointName = this.wsdlPort.getName().getLocalPart();
            NMRClientConnection con = new NMRClientConnection(this.wsdlLocation, this.service, endpointName, operation, isOneWay);
            con.initialize();
            con.sendRequest(request);
            Packet reply = null;
            if (System.getSecurityManager() == null) {
                reply = con.receiveResponse(request);
            } else {
                final NMRClientConnection fcon = con;
                final Packet frequest = request;
                reply = (Packet)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return fcon.receiveResponse(frequest);
                    }
                });
            }
            if (!isOneWay) {
                con.sendStatus();
            }
            return reply;
        }
        catch (Exception wex) {
            RuntimeException ex = new RuntimeException(wex.getMessage());
            ex.setStackTrace(wex.getStackTrace());
            throw ex;
        }
    }

    public Pipe copy(PipeCloner cloner) {
        return new JBITransportPipe(this, cloner);
    }

    private void setWSDLLocation(URL wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    private void setWSDLPort(WSDLPort wsdlPort) {
        this.wsdlPort = wsdlPort;
    }

    private void setServiceName(QName service) {
        this.service = service;
    }

    public URL getWSDLLocation() {
        return this.wsdlLocation;
    }

    public WSDLPort getWSDLPort() {
        return this.wsdlPort;
    }

    public QName getServiceName() {
        return this.service;
    }
}

