/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.core;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.jbi.serviceengine.bridge.EndpointHelper;
import com.sun.enterprise.jbi.serviceengine.bridge.EndpointInfoCollector;
import com.sun.enterprise.jbi.serviceengine.core.DescriptorEndpointInfo;
import com.sun.enterprise.jbi.serviceengine.core.EndpointRegistry;
import com.sun.enterprise.jbi.serviceengine.core.JBIDescriptorReader;
import com.sun.enterprise.jbi.serviceengine.core.ServiceEngineEndpoint;
import com.sun.enterprise.jbi.serviceengine.core.ServiceEngineRuntimeHelper;
import com.sun.enterprise.jbi.serviceengine.util.soap.StringTranslator;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.glassfish.webservices.WsUtil;
import org.w3c.dom.Document;

public class JBIEndpointManager {
    private RegistryManager registryManager;
    private final Logger logger = LogDomains.getLogger(JBIEndpointManager.class, (String)"javax.enterprise.system");
    private StringTranslator translator;

    JBIEndpointManager() {
        this.registryManager = new RegistryManager();
        this.translator = new StringTranslator(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
    }

    void storeAllEndpoints(String appLocation, String su_Name) throws Exception {
        InputStream jbi_xml = null;
        try {
            if (new File(appLocation).isDirectory()) {
                jbi_xml = new FileInputStream(appLocation + File.separator + "META-INF" + File.separator + "jbi.xml");
            } else {
                ZipFile zipFile = new ZipFile(appLocation);
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry zipEntry = e.nextElement();
                    if (!"META-INF/jbi.xml".equals(zipEntry.getName())) continue;
                    jbi_xml = zipFile.getInputStream(zipEntry);
                    break;
                }
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            Document doc = factory.newDocumentBuilder().parse(jbi_xml);
            JBIDescriptorReader reader = new JBIDescriptorReader(su_Name);
            reader.init(doc);
            this.registryManager.addAllEndpointInfo(reader.getEndpoints());
            this.registryManager.addServiceUnit(su_Name);
        }
        catch (Exception e) {
            String exceptionText = this.translator.getString("serviceengine.jbixml_readerror", su_Name);
            this.logger.log(Level.SEVERE, exceptionText, e);
            throw new Exception(exceptionText, e);
        }
        finally {
            if (jbi_xml != null) {
                jbi_xml.close();
            }
        }
    }

    void removeAllEndpoints(String su_Name) {
        this.registryManager.removeAllConsumerEP(su_Name);
        this.registryManager.removeAllProviderEP(su_Name);
        this.registryManager.removeServiceUnit(su_Name);
    }

    void startAllEndpoints(String su_Name) throws Exception {
        EndpointHelper epHelper = EndpointHelper.getInstance();
        for (DescriptorEndpointInfo ep : this.registryManager.getAllConsumerEP(su_Name)) {
            ep.setStarted(true);
        }
        for (DescriptorEndpointInfo ep : this.registryManager.getAllProviderEP(su_Name)) {
            if (this.registryManager.getSEEndpoint(ep) == null) {
                WebServiceEndpoint ws_endpoint = this.registryManager.getWSEndpoint(ep, su_Name);
                if (ws_endpoint == null) {
                    EndpointInfoCollector endpointInfoCollector = ServiceEngineRuntimeHelper.getRuntime().getEndpointInfoCollector();
                    List<WebServiceEndpoint> endpoints = endpointInfoCollector.getEndpoints(su_Name);
                    for (WebServiceEndpoint endpoint : endpoints) {
                        String endpointName;
                        String string = endpointName = endpoint.hasWsdlPort() ? endpoint.getWsdlPort().getLocalPart() : endpoint.getEndpointName();
                        if (!endpoint.getServiceName().equals(ep.getServiceName()) || !endpointName.equals(ep.getEndpointName())) continue;
                        ws_endpoint = endpoint;
                    }
                }
                if (ws_endpoint == null) {
                    throw new Exception(this.translator.getString("serviceengine.endpoint_mismatch", ep.getServiceName().getLocalPart(), su_Name));
                }
                this.createEndpoint(ws_endpoint, ep);
            }
            ep.setStarted(true);
            epHelper.enableEndpoint(ep.getServiceName(), ep.getEndpointName());
        }
    }

    void stopAllEndpoints(String su_Name) {
        EndpointHelper epHelper = EndpointHelper.getInstance();
        for (DescriptorEndpointInfo ep : this.registryManager.getAllConsumerEP(su_Name)) {
            ep.setStarted(false);
        }
        for (DescriptorEndpointInfo ep : this.registryManager.getAllProviderEP(su_Name)) {
            ep.setStarted(false);
            epHelper.disableEndpoint(ep.getServiceName(), ep.getEndpointName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEndpoint(WebServiceEndpoint endpoint, DescriptorEndpointInfo ep) throws Exception {
        BundleDescriptor bundledesc = endpoint.getBundleDescriptor();
        ClassLoader cl = bundledesc.getClassLoader();
        ClassLoader origCl = Utility.setContextClassLoader((ClassLoader)cl);
        try {
            WsUtil wsu = new WsUtil();
            Class<?> serviceEndpointClass = Class.forName(endpoint.getServletImplClass(), true, cl);
            String givenBinding = endpoint.getProtocolBinding();
            SDDocumentSource primaryWsdl = null;
            Collection docs = null;
            if (endpoint.getWebService().hasWsdlFile()) {
                String deployedDir = null;
                File pkgedWsdl = deployedDir != null ? (bundledesc.getApplication().isVirtual() ? new File(deployedDir + File.separator + endpoint.getWebService().getWsdlFileUri()) : new File(deployedDir + File.separator + bundledesc.getModuleDescriptor().getArchiveUri().replaceAll("\\.", "_") + File.separator + endpoint.getWebService().getWsdlFileUri())) : new File(endpoint.getWebService().getWsdlFileUrl().getFile());
                if (pkgedWsdl.exists()) {
                    primaryWsdl = SDDocumentSource.create((URL)pkgedWsdl.toURL());
                    docs = wsu.getWsdlsAndSchemas(pkgedWsdl);
                }
            }
            URL catalogURL = null;
            File catalogFile = new File(bundledesc.getDeploymentDescriptorDir() + File.separator + "jax-ws-catalog.xml");
            if (catalogFile.exists()) {
                catalogURL = catalogFile.toURL();
            }
            WSBinding binding = BindingID.parse((String)givenBinding).createBinding();
            wsu.configureJAXWSServiceHandlers(endpoint, givenBinding, binding);
            WSEndpoint wsep = WSEndpoint.create(serviceEndpointClass, (boolean)false, null, (QName)endpoint.getServiceName(), (QName)endpoint.getWsdlPort(), null, (WSBinding)binding, (SDDocumentSource)primaryWsdl, (Collection)docs, (URL)catalogURL);
            EndpointHelper epHelper = EndpointHelper.getInstance();
            epHelper.registerEndpoint(endpoint);
            this.registryManager.getSEEndpoint(ep).setWsep(wsep);
        }
        finally {
            Utility.setContextClassLoader((ClassLoader)origCl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RegistryManager {
        private ConcurrentHashMap<String, DescriptorEndpointInfo> provider_endpoints;
        private ConcurrentHashMap<String, DescriptorEndpointInfo> consumer_endpoints;
        private EndpointRegistry epRegistry = EndpointRegistry.getInstance();

        RegistryManager() {
            this.provider_endpoints = this.epRegistry.getProviders();
            this.consumer_endpoints = this.epRegistry.getConsumers();
        }

        void addAllEndpointInfo(DescriptorEndpointInfo[] endpoints) {
            for (DescriptorEndpointInfo ep : endpoints) {
                if (ep.isProvider()) {
                    this.provider_endpoints.put(ep.getKey(), ep);
                    continue;
                }
                this.consumer_endpoints.put(ep.getKey(), ep);
            }
        }

        void addServiceUnit(String su_Name) {
            this.epRegistry.getCompApps().add(su_Name);
        }

        void removeServiceUnit(String su_Name) {
            this.epRegistry.getCompApps().remove(su_Name);
        }

        void removeAllProviderEP(String su_Name) {
            for (String key : this.provider_endpoints.keySet()) {
                DescriptorEndpointInfo ep = this.provider_endpoints.get(key);
                if (ep == null || !ep.getSu_Name().equals(su_Name)) continue;
                this.provider_endpoints.remove(key);
            }
        }

        void removeAllConsumerEP(String su_Name) {
            for (String key : this.consumer_endpoints.keySet()) {
                DescriptorEndpointInfo ep = this.consumer_endpoints.get(key);
                if (ep == null || !ep.getSu_Name().equals(su_Name)) continue;
                this.consumer_endpoints.remove(key);
            }
        }

        List<DescriptorEndpointInfo> getAllProviderEP(String su_Name) {
            LinkedList<DescriptorEndpointInfo> list = new LinkedList<DescriptorEndpointInfo>();
            for (String key : this.provider_endpoints.keySet()) {
                DescriptorEndpointInfo ep = this.provider_endpoints.get(key);
                if (ep == null || !ep.getSu_Name().equals(su_Name)) continue;
                list.add(ep);
            }
            return list;
        }

        List<DescriptorEndpointInfo> getAllConsumerEP(String su_Name) {
            LinkedList<DescriptorEndpointInfo> list = new LinkedList<DescriptorEndpointInfo>();
            for (String key : this.consumer_endpoints.keySet()) {
                DescriptorEndpointInfo ep = this.consumer_endpoints.get(key);
                if (ep == null || !ep.getSu_Name().equals(su_Name)) continue;
                list.add(ep);
            }
            return list;
        }

        ServiceEngineEndpoint getSEEndpoint(DescriptorEndpointInfo ep) {
            return this.epRegistry.get(ep.getServiceName(), ep.getEndpointName());
        }

        private WebServiceEndpoint getWSEndpoint(DescriptorEndpointInfo ep, String appName) {
            List<WebServiceEndpoint> endpoints = this.epRegistry.getWSEndpoints().get(appName);
            if (endpoints == null) {
                return null;
            }
            for (WebServiceEndpoint endpoint : endpoints) {
                String endpointName;
                String string = endpointName = endpoint.hasWsdlPort() ? endpoint.getWsdlPort().getLocalPart() : endpoint.getEndpointName();
                if (!endpoint.getServiceName().equals(ep.getServiceName()) || !endpointName.equals(ep.getEndpointName())) continue;
                return endpoint;
            }
            return null;
        }
    }
}

