/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.handlers;

import com.sun.enterprise.jbi.serviceengine.comm.MessageExchangeTransport;
import com.sun.enterprise.jbi.serviceengine.handlers.JBIHandler;
import com.sun.enterprise.security.SecurityContext;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.security.auth.Subject;

public class JBISecurityHandler
implements JBIHandler {
    private final String SECURITY_PROPERTY = "javax.jbi.security.subject";
    private String sc_enable = System.getProperty("com.sun.enterprise.jbi.sc.enable");

    public void handleInbound(MessageExchangeTransport meTransport) throws Exception {
        if (!this.isSecurityEnabled()) {
            return;
        }
        Subject subject = SecurityContext.getCurrent().getSubject();
        NormalizedMessage msg = meTransport.getMessage();
        if (msg == null) {
            return;
        }
        MessageExchange me = meTransport.getMessageExchange();
        if (me.getRole().equals(MessageExchange.Role.PROVIDER) && msg.getProperty("javax.jbi.security.subject") != null) {
            SecurityContext.setUnauthenticatedContext();
        }
        msg.setProperty("javax.jbi.security.subject", (Object)subject);
    }

    public void handleOutbound(MessageExchangeTransport meTransport) throws Exception {
        if (!this.isSecurityEnabled()) {
            return;
        }
        NormalizedMessage msg = meTransport.getMessage();
        if (msg == null) {
            return;
        }
        Subject subject = (Subject)msg.getProperty("javax.jbi.security.subject");
        if (subject != null) {
            SecurityContext sc = new SecurityContext(subject);
            SecurityContext.setCurrent((SecurityContext)sc);
        }
    }

    protected boolean isSecurityEnabled() {
        return this.sc_enable == null || this.sc_enable.equalsIgnoreCase("true");
    }
}

