/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.bridge;

import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.bridge.EndpointInfoCollector;
import com.sun.enterprise.jbi.serviceengine.bridge.transport.JBIAdapter;
import com.sun.enterprise.jbi.serviceengine.core.EndpointRegistry;
import com.sun.enterprise.jbi.serviceengine.core.ServiceEngineEndpoint;
import com.sun.enterprise.jbi.serviceengine.core.ServiceEngineRuntimeHelper;
import com.sun.enterprise.web.WebComponentInvocation;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.server.Adapter;
import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.webservices.AdapterInvocationInfo;
import org.glassfish.webservices.EjbRuntimeEndpointInfo;
import org.glassfish.webservices.JAXWSAdapterRegistry;
import org.glassfish.webservices.WebServiceEjbEndpointRegistry;
import org.w3c.dom.Document;

public class JBIAdapterBuilder {
    private EndpointRegistry endpointRegistry = EndpointRegistry.getInstance();
    private final Logger logger = LogDomains.getLogger(JBIAdapterBuilder.class, (String)"javax.enterprise.system");

    JBIAdapterBuilder() {
    }

    public JBIAdapter createAdapter(QName service, String endpointName, MessageExchange me) throws ServiceEngineException {
        ServiceEngineEndpoint endpt = this.endpointRegistry.get(service, endpointName);
        if (endpt != null) {
            return this.createWSAdapter(endpt, me);
        }
        throw new ServiceEngineException("Endpoint " + endpointName + "not deployed in JBI");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JBIAdapter createWSAdapter(ServiceEngineEndpoint endpt, MessageExchange me) {
        try {
            AdapterInvocationInfo adapterInfo = null;
            EjbRuntimeEndpointInfo ejbEndPtInfo = null;
            WebComponentInvocation inv = null;
            if (endpt.isImplementedByEJB()) {
                WebServiceEjbEndpointRegistry registry = ServiceEngineRuntimeHelper.getRuntime().getWebServiceEjbEndpointRegistry();
                ejbEndPtInfo = registry.getEjbWebServiceEndpoint(endpt.getURI(), "POST", null);
                adapterInfo = (AdapterInvocationInfo)ejbEndPtInfo.prepareInvocation(true);
                ServletAdapter sadapter = adapterInfo.getAdapter();
                endpt.setWsep(sadapter.getEndpoint());
            } else {
                String url = endpt.getURI();
                String contextRoot = endpt.getContextRoot();
                Adapter adapter = JAXWSAdapterRegistry.getInstance().getAdapter(contextRoot, url, url);
                if (endpt.getWebModule() == null) {
                    EndpointInfoCollector infoCollector = ServiceEngineRuntimeHelper.getRuntime().getEndpointInfoCollector();
                    endpt.setWebModule(infoCollector.getWebModule(endpt.getEndpointDesc()));
                }
                InvocationManager invocationMgr = ServiceEngineRuntimeHelper.getRuntime().getInvocationManager();
                inv = new WebComponentInvocation(endpt.getWebModule());
                invocationMgr.preInvoke((ComponentInvocation)inv);
                if (adapter != null) {
                    endpt.setWsep(adapter.getEndpoint());
                }
            }
            this.logger.log(Level.FINE, "Successfully created JBIAdapter for endpoint:" + endpt.getWsep());
            if (endpt.getWsdlDocument() == null) {
                SDDocument sdDocument;
                SDDocument sDDocument = sdDocument = endpt.getWsep().getServiceDefinition().getPrimary();
                synchronized (sDDocument) {
                    if (endpt.getWsdlDocument() == null) {
                        Document doc = this.getWSDLDocument(sdDocument);
                        endpt.setWsdlDocument(doc);
                    }
                }
            }
            return new JBIAdapter(endpt.getWsep(), endpt, me, endpt.getClassLoader(), ejbEndPtInfo, adapterInfo, inv);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception in creating JBIAdapter:" + e.getMessage(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getWSDLDocument(SDDocument document) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        document.writeTo(null, this.getResolver(), (OutputStream)baos);
        baos.flush();
        ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder db = factory.newDocumentBuilder();
            Document document2 = db.parse(in, document.getURL().toString());
            return document2;
        }
        finally {
            ((InputStream)in).close();
            baos.close();
        }
    }

    private DocumentAddressResolver getResolver() {
        return new DocumentAddressResolver(){

            public String getRelativeAddressFor(SDDocument current, SDDocument referenced) {
                JBIAdapterBuilder.this.logger.log(Level.FINE, "Current SDDocument URL = " + current.getURL() + ", isWSDL = " + current.isWSDL());
                JBIAdapterBuilder.this.logger.log(Level.FINE, "Referenced SDDocument URL = " + referenced.getURL() + ", isWSDL = " + referenced.isWSDL());
                if (referenced.isWSDL()) {
                    JBIAdapterBuilder.this.logger.log(Level.FINE, "Relative address for referenced SDDocument = " + referenced.getURL().toString());
                    return referenced.getURL().toString();
                }
                return "";
            }
        };
    }
}

