/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.work;

import com.sun.corba.se.impl.orbutil.threadpool.ThreadPoolManagerImpl;
import com.sun.corba.se.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPoolManager;
import com.sun.corba.se.spi.orbutil.threadpool.Work;
import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.comm.MessageAcceptor;
import com.sun.enterprise.jbi.serviceengine.config.ComponentConfiguration;
import com.sun.enterprise.jbi.serviceengine.work.OneWork;
import com.sun.enterprise.jbi.serviceengine.work.WorkManager;
import com.sun.logging.LogDomains;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorkManagerImpl
implements WorkManager,
Runnable {
    private ComponentConfiguration config = null;
    private String threadPoolName = null;
    private ThreadPoolManager tpm = null;
    private ThreadPool tp = null;
    private MessageAcceptor acceptor = null;
    private static Logger logger = LogDomains.getLogger(WorkManagerImpl.class, (String)"javax.enterprise.system");

    public WorkManagerImpl(ComponentConfiguration config) {
        this.config = config;
        this.threadPoolName = this.config.getCommonThreadPoolName();
    }

    public void setPoolName(String poolName) {
        this.threadPoolName = poolName;
    }

    public String getPoolName() {
        return this.threadPoolName;
    }

    public MessageAcceptor getMessageAcceptor() {
        return this.acceptor;
    }

    public void submitWork(OneWork work) {
        this.tp.getAnyWorkQueue().addWork((Work)work);
    }

    public void startAcceptor() throws ServiceEngineException {
        this.tpm = WorkManagerImpl.getThreadPoolManager();
        if (this.getPoolName() == null) {
            this.tp = this.tpm.getDefaultThreadPool();
        } else {
            try {
                this.tp = this.tpm.getThreadPool(this.getPoolName());
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Got the thread pool for :" + this.getPoolName());
                }
            }
            catch (NoSuchThreadPoolException e) {
                logger.log(Level.SEVERE, "workmanager.threadpool_not_found", this.getPoolName());
                throw new ServiceEngineException(e.getMessage());
            }
        }
        this.acceptor = new MessageAcceptor();
        this.acceptor.startAccepting();
    }

    public void stop() {
        this.acceptor.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.startAcceptor();
        }
        catch (ServiceEngineException se) {
            se.printStackTrace();
        }
        finally {
            this.stop();
        }
    }

    private static ThreadPoolManager getThreadPoolManager() throws ServiceEngineException {
        try {
            Constructor defaultConstructor = ThreadPoolManagerImpl.class.getConstructor(new Class[0]);
            defaultConstructor.setAccessible(true);
            return (ThreadPoolManager)defaultConstructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Constructor threadGroupParamConstructor = ThreadPoolManagerImpl.class.getConstructor(ThreadGroup.class);
            threadGroupParamConstructor.setAccessible(true);
            Object tg = null;
            return (ThreadPoolManager)threadGroupParamConstructor.newInstance(tg);
        }
        catch (Exception e) {
            throw new ServiceEngineException("Service Engine unable to provide thread pool manager");
        }
    }
}

