/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.comm;

import com.sun.enterprise.jbi.serviceengine.comm.MessageProcessor;
import com.sun.enterprise.jbi.serviceengine.comm.MessageReceiver;
import com.sun.enterprise.jbi.serviceengine.core.JavaEEServiceEngineContext;
import com.sun.enterprise.jbi.serviceengine.work.OneWork;
import java.util.HashMap;
import java.util.logging.Level;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;

public class MessageAcceptor
extends OneWork {
    private HashMap<String, MessageReceiver> receivers = new HashMap();
    private boolean released = false;

    public void startAccepting() {
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(MessageReceiver receiver) {
        String id = receiver.getMessageExchange().getExchangeId();
        logger.log(Level.FINER, "Adding recever for " + id);
        HashMap<String, MessageReceiver> hashMap = this.receivers;
        synchronized (hashMap) {
            this.receivers.put(id, receiver);
        }
    }

    public void release() {
        this.released = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doWork() {
        try {
            while (true) {
                MessageExchange me = this.getDeliveryChannel().accept();
                if (this.released) {
                    return;
                }
                if (me == null || this.ignoreMessageExchange(me)) continue;
                String id = me.getExchangeId();
                if (this.receivers.containsKey(id)) {
                    HashMap<String, MessageReceiver> hashMap = this.receivers;
                    synchronized (hashMap) {
                        MessageReceiver receiver = this.receivers.remove(id);
                        receiver.setMessageExchange(me);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Releasing MessageReceiver:" + id + ",MEP :" + me);
                        }
                        receiver.release();
                        continue;
                    }
                }
                MessageProcessor processor = JavaEEServiceEngineContext.getInstance().getBridge().getMessageProcessor(me);
                processor.setUseCurrentThread(false);
                processor.setMessageExchange(me);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Spawning MessageProcessorfor MEP :" + me);
                }
                processor.process();
            }
        }
        catch (MessagingException ie) {
            logger.log(Level.FINE, "Stopping the acceptor thread");
            return;
        }
    }

    private boolean ignoreMessageExchange(MessageExchange me) {
        if (me.getRole().equals(MessageExchange.Role.PROVIDER)) {
            if (me.getStatus().equals(ExchangeStatus.ACTIVE)) {
                return false;
            }
            if (me.getStatus().equals(ExchangeStatus.DONE)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Message Exchange Completed " + me);
                }
                return true;
            }
            if (me.getStatus().equals(ExchangeStatus.ERROR)) {
                logger.warning("JavaEE Service Engine received unsupported Message Exchange " + me);
                return true;
            }
        }
        return false;
    }
}

