/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.ext;

import java.lang.reflect.ReflectPermission;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.FactoryFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RuntimeDelegate {
    public static final String JAXRS_RUNTIME_DELEGATE_PROPERTY = "javax.ws.rs.ext.RuntimeDelegate";
    private static final String JAXRS_DEFAULT_RUNTIME_DELEGATE = "com.sun.ws.rs.ext.RuntimeDelegateImpl";
    private static AtomicReference<RuntimeDelegate> rdr = new AtomicReference();
    private static ReflectPermission rp = new ReflectPermission("suppressAccessChecks");

    protected RuntimeDelegate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RuntimeDelegate getInstance() {
        RuntimeDelegate rd = rdr.get();
        if (rd != null) {
            return rd;
        }
        AtomicReference<RuntimeDelegate> atomicReference = rdr;
        synchronized (atomicReference) {
            rd = rdr.get();
            if (rd != null) {
                return rd;
            }
            try {
                Object delegate = FactoryFinder.find(JAXRS_RUNTIME_DELEGATE_PROPERTY, JAXRS_DEFAULT_RUNTIME_DELEGATE);
                if (!(delegate instanceof RuntimeDelegate)) {
                    Class<RuntimeDelegate> pClass = RuntimeDelegate.class;
                    String classnameAsResource = pClass.getName().replace('.', '/') + ".class";
                    ClassLoader loader = pClass.getClassLoader();
                    if (loader == null) {
                        loader = ClassLoader.getSystemClassLoader();
                    }
                    URL targetTypeURL = loader.getResource(classnameAsResource);
                    throw new LinkageError("ClassCastException: attempting to cast" + delegate.getClass().getClassLoader().getResource(classnameAsResource) + "to" + targetTypeURL.toString());
                }
                rd = (RuntimeDelegate)delegate;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            rdr.compareAndSet(null, rd);
        }
        return rdr.get();
    }

    public static void setInstance(RuntimeDelegate rd) throws SecurityException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(rp);
        }
        rdr.set(rd);
    }

    public abstract UriBuilder createUriBuilder();

    public abstract Response.ResponseBuilder createResponseBuilder();

    public abstract Variant.VariantListBuilder createVariantListBuilder();

    public abstract <T> T createEndpoint(Application var1, Class<T> var2) throws IllegalArgumentException, UnsupportedOperationException;

    public abstract <T> HeaderDelegate<T> createHeaderDelegate(Class<T> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface HeaderDelegate<T> {
        public T fromString(String var1) throws IllegalArgumentException;

        public String toString(T var1);
    }
}

