/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client;

import com.sun.jersey.api.client.AsyncUniformInterface;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.PartialRequestBuilder;
import com.sun.jersey.api.client.RequestBuilder;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.Filterable;
import com.sun.jersey.client.impl.ClientRequestImpl;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncWebResource
extends Filterable
implements RequestBuilder<Builder>,
AsyncUniformInterface {
    private final URI u;

    AsyncWebResource(ClientHandler c, URI u) {
        super(c);
        this.u = u;
    }

    private AsyncWebResource(AsyncWebResource that, UriBuilder ub) {
        super(that);
        this.u = ub.build(new Object[0]);
    }

    public URI getURI() {
        return this.u;
    }

    public UriBuilder getBuilder() {
        return UriBuilder.fromUri((URI)this.u);
    }

    public String toString() {
        return this.u.toString();
    }

    public int hashCode() {
        return this.u.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof WebResource) {
            AsyncWebResource that = (AsyncWebResource)obj;
            return that.u.equals(this.u);
        }
        return false;
    }

    @Override
    public Future<ClientResponse> head() {
        return this.handle(ClientResponse.class, (ClientRequest)new ClientRequestImpl(this.getURI(), "HEAD"));
    }

    @Override
    public <T> Future<T> options(Class<T> c) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "OPTIONS"));
    }

    @Override
    public <T> Future<T> options(GenericType<T> gt) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "OPTIONS"));
    }

    @Override
    public <T> Future<T> get(Class<T> c) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "GET"));
    }

    @Override
    public <T> Future<T> get(GenericType<T> gt) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "GET"));
    }

    @Override
    public Future<?> put() throws UniformInterfaceException {
        return this.voidHandle(new ClientRequestImpl(this.getURI(), "PUT", null));
    }

    @Override
    public Future<?> put(Object requestEntity) throws UniformInterfaceException {
        return this.voidHandle(new ClientRequestImpl(this.getURI(), "PUT", requestEntity));
    }

    @Override
    public <T> Future<T> put(Class<T> c) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT"));
    }

    @Override
    public <T> Future<T> put(GenericType<T> gt) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT"));
    }

    @Override
    public <T> Future<T> put(Class<T> c, Object requestEntity) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT", requestEntity));
    }

    @Override
    public <T> Future<T> put(GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT", requestEntity));
    }

    @Override
    public Future<?> post() throws UniformInterfaceException {
        return this.voidHandle(new ClientRequestImpl(this.getURI(), "POST"));
    }

    @Override
    public Future<?> post(Object requestEntity) throws UniformInterfaceException {
        return this.voidHandle(new ClientRequestImpl(this.getURI(), "POST", requestEntity));
    }

    @Override
    public <T> Future<T> post(Class<T> c) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST"));
    }

    @Override
    public <T> Future<T> post(GenericType<T> gt) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST"));
    }

    @Override
    public <T> Future<T> post(Class<T> c, Object requestEntity) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST", requestEntity));
    }

    @Override
    public <T> Future<T> post(GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST", requestEntity));
    }

    @Override
    public Future<?> delete() throws UniformInterfaceException {
        return this.voidHandle(new ClientRequestImpl(this.getURI(), "DELETE"));
    }

    @Override
    public Future<?> delete(Object requestEntity) throws UniformInterfaceException {
        return this.voidHandle(new ClientRequestImpl(this.getURI(), "DELETE", requestEntity));
    }

    @Override
    public <T> Future<T> delete(Class<T> c) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE"));
    }

    @Override
    public <T> Future<T> delete(GenericType<T> gt) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE"));
    }

    @Override
    public <T> Future<T> delete(Class<T> c, Object requestEntity) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE", requestEntity));
    }

    @Override
    public <T> Future<T> delete(GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE", requestEntity));
    }

    @Override
    public Future<?> method(String method) throws UniformInterfaceException {
        return this.voidHandle(new ClientRequestImpl(this.getURI(), method));
    }

    @Override
    public Future<?> method(String method, Object requestEntity) throws UniformInterfaceException {
        return this.voidHandle(new ClientRequestImpl(this.getURI(), method, requestEntity));
    }

    @Override
    public <T> Future<T> method(String method, Class<T> c) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), method));
    }

    @Override
    public <T> Future<T> method(String method, GenericType<T> gt) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), method));
    }

    @Override
    public <T> Future<T> method(String method, Class<T> c, Object requestEntity) throws UniformInterfaceException {
        return this.handle(c, (ClientRequest)new ClientRequestImpl(this.getURI(), method, requestEntity));
    }

    @Override
    public <T> Future<T> method(String method, GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), method, requestEntity));
    }

    @Override
    public Builder entity(Object entity) {
        return (Builder)new Builder(this.getURI()).entity(entity);
    }

    @Override
    public Builder entity(Object entity, MediaType type) {
        return (Builder)new Builder(this.getURI()).entity(entity, type);
    }

    @Override
    public Builder entity(Object entity, String type) {
        return (Builder)new Builder(this.getURI()).entity(entity, type);
    }

    @Override
    public Builder type(MediaType type) {
        return (Builder)new Builder(this.getURI()).type(type);
    }

    @Override
    public Builder type(String type) {
        return (Builder)new Builder(this.getURI()).type(type);
    }

    @Override
    public Builder accept(MediaType ... types) {
        return (Builder)new Builder(this.getURI()).accept(types);
    }

    @Override
    public Builder accept(String ... types) {
        return (Builder)new Builder(this.getURI()).accept(types);
    }

    @Override
    public Builder acceptLanguage(Locale ... locales) {
        return (Builder)new Builder(this.getURI()).acceptLanguage(locales);
    }

    @Override
    public Builder acceptLanguage(String ... locales) {
        return (Builder)new Builder(this.getURI()).acceptLanguage(locales);
    }

    @Override
    public Builder cookie(Cookie cookie) {
        return (Builder)new Builder(this.getURI()).cookie(cookie);
    }

    @Override
    public Builder header(String name, Object value) {
        return (Builder)new Builder(this.getURI()).header(name, value);
    }

    public AsyncWebResource path(String path) {
        return new AsyncWebResource(this, this.getBuilder().path(path));
    }

    public AsyncWebResource uri(URI uri) {
        String query;
        UriBuilder b = this.getBuilder();
        String path = uri.getRawPath();
        if (path != null && path.length() > 0) {
            if (path.startsWith("/")) {
                b.replacePath(path);
            } else {
                b.path(path);
            }
        }
        if ((query = uri.getRawQuery()) != null && query.length() > 0) {
            b.replaceQuery(query);
        }
        return new AsyncWebResource(this, b);
    }

    public AsyncWebResource queryParams(MultivaluedMap<String, String> params) {
        UriBuilder b = this.getBuilder();
        for (Map.Entry e : params.entrySet()) {
            for (String value : (List)e.getValue()) {
                b.queryParam((String)e.getKey(), new Object[]{value});
            }
        }
        return new AsyncWebResource(this, b);
    }

    private <T> Future<T> handle(final Class<T> c, final ClientRequest ro) {
        FutureTask ft = new FutureTask(new Callable<T>(){

            @Override
            public T call() throws Exception {
                ClientResponse r = AsyncWebResource.this.getHeadHandler().handle(ro);
                if (c == ClientResponse.class) {
                    return c.cast(r);
                }
                if (r.getStatus() < 300) {
                    return r.getEntity(c);
                }
                throw new UniformInterfaceException("Status: " + r.getStatus(), r);
            }
        });
        new Thread(ft).start();
        return ft;
    }

    private <T> Future<T> handle(final GenericType<T> gt, final ClientRequest ro) {
        FutureTask ft = new FutureTask(new Callable<T>(){

            @Override
            public T call() throws Exception {
                ClientResponse r = AsyncWebResource.this.getHeadHandler().handle(ro);
                if (gt.getRawClass() == ClientResponse.class) {
                    gt.getRawClass().cast(r);
                }
                if (r.getStatus() < 300) {
                    return r.getEntity(gt);
                }
                throw new UniformInterfaceException("Status: " + r.getStatus(), r);
            }
        });
        new Thread(ft).start();
        return ft;
    }

    private Future<?> voidHandle(final ClientRequest ro) {
        FutureTask<Object> ft = new FutureTask<Object>(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ClientResponse r = AsyncWebResource.this.getHeadHandler().handle(ro);
                if (r.getStatus() >= 300) {
                    throw new UniformInterfaceException("Status: " + r.getStatus(), r);
                }
                return null;
            }
        });
        new Thread(ft).start();
        return ft;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Builder
    extends PartialRequestBuilder<Builder>
    implements AsyncUniformInterface {
        private final URI u;

        private Builder(URI u) {
            this.u = u;
        }

        private ClientRequest build(String method) {
            ClientRequestImpl ro = new ClientRequestImpl(this.u, method, this.entity, (MultivaluedMap<String, Object>)this.metadata);
            this.entity = null;
            this.metadata = null;
            return ro;
        }

        private ClientRequest build(String method, Object e) {
            ClientRequestImpl ro = new ClientRequestImpl(this.u, method, e, (MultivaluedMap<String, Object>)this.metadata);
            this.entity = null;
            this.metadata = null;
            return ro;
        }

        @Override
        public Future<ClientResponse> head() {
            return AsyncWebResource.this.handle(ClientResponse.class, this.build("HEAD"));
        }

        @Override
        public <T> Future<T> options(Class<T> c) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(c, this.build("OPTIONS"));
        }

        @Override
        public <T> Future<T> options(GenericType<T> gt) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(gt, this.build("OPTIONS"));
        }

        @Override
        public <T> Future<T> get(Class<T> c) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(c, this.build("GET"));
        }

        @Override
        public <T> Future<T> get(GenericType<T> gt) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(gt, this.build("GET"));
        }

        @Override
        public Future<?> put() throws UniformInterfaceException {
            return AsyncWebResource.this.voidHandle(this.build("PUT"));
        }

        @Override
        public Future<?> put(Object requestEntity) throws UniformInterfaceException {
            return AsyncWebResource.this.voidHandle(this.build("PUT", requestEntity));
        }

        @Override
        public <T> Future<T> put(Class<T> c) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(c, this.build("PUT"));
        }

        @Override
        public <T> Future<T> put(GenericType<T> gt) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(gt, this.build("PUT"));
        }

        @Override
        public <T> Future<T> put(Class<T> c, Object requestEntity) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(c, this.build("PUT", requestEntity));
        }

        @Override
        public <T> Future<T> put(GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(gt, this.build("PUT", requestEntity));
        }

        @Override
        public Future<?> post() throws UniformInterfaceException {
            return AsyncWebResource.this.voidHandle(this.build("POST"));
        }

        @Override
        public Future<?> post(Object requestEntity) throws UniformInterfaceException {
            return AsyncWebResource.this.voidHandle(this.build("POST", requestEntity));
        }

        @Override
        public <T> Future<T> post(Class<T> c) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(c, this.build("POST"));
        }

        @Override
        public <T> Future<T> post(GenericType<T> gt) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(gt, this.build("POST"));
        }

        @Override
        public <T> Future<T> post(Class<T> c, Object requestEntity) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(c, this.build("POST", requestEntity));
        }

        @Override
        public <T> Future<T> post(GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(gt, this.build("POST", requestEntity));
        }

        @Override
        public Future<?> delete() throws UniformInterfaceException {
            return AsyncWebResource.this.voidHandle(this.build("DELETE"));
        }

        @Override
        public Future<?> delete(Object requestEntity) throws UniformInterfaceException {
            return AsyncWebResource.this.voidHandle(this.build("DELETE", requestEntity));
        }

        @Override
        public <T> Future<T> delete(Class<T> c) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(c, this.build("DELETE"));
        }

        @Override
        public <T> Future<T> delete(GenericType<T> gt) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(gt, this.build("DELETE"));
        }

        @Override
        public <T> Future<T> delete(Class<T> c, Object requestEntity) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(c, this.build("DELETE", requestEntity));
        }

        @Override
        public <T> Future<T> delete(GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(gt, this.build("DELETE", requestEntity));
        }

        @Override
        public Future<?> method(String method) throws UniformInterfaceException {
            return AsyncWebResource.this.voidHandle(this.build(method));
        }

        @Override
        public Future<?> method(String method, Object requestEntity) throws UniformInterfaceException {
            return AsyncWebResource.this.voidHandle(this.build(method, requestEntity));
        }

        @Override
        public <T> Future<T> method(String method, Class<T> c) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(c, this.build(method));
        }

        @Override
        public <T> Future<T> method(String method, GenericType<T> gt) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(gt, this.build(method));
        }

        @Override
        public <T> Future<T> method(String method, Class<T> c, Object requestEntity) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(c, this.build(method, requestEntity));
        }

        @Override
        public <T> Future<T> method(String method, GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
            return AsyncWebResource.this.handle(gt, this.build(method, requestEntity));
        }
    }
}

