/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.spi.component;

import com.sun.jersey.core.spi.component.ComponentProvider;
import com.sun.jersey.core.spi.component.ProviderFactory;
import com.sun.jersey.core.spi.factory.InjectableProviderFactory;
import com.sun.jersey.spi.service.ServiceFinder;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderServices {
    private static final Logger LOGGER = Logger.getLogger(ProviderServices.class.getName());
    private final InjectableProviderFactory injectableFactory;
    private final ProviderFactory componentProviderFactory;
    private final Set<Class<?>> providers;
    private final Set<?> providerInstances;

    public ProviderServices(InjectableProviderFactory injectableFactory, ProviderFactory componentProviderFactory, Set<Class<?>> providers, Set<?> providerInstances) {
        this.injectableFactory = injectableFactory;
        this.componentProviderFactory = componentProviderFactory;
        this.providers = providers;
        this.providerInstances = providerInstances;
    }

    public ProviderFactory getComponentProviderFactory() {
        return this.componentProviderFactory;
    }

    public <T> Set<T> getProviders(Class<T> provider) {
        LinkedHashSet<T> ps = new LinkedHashSet<T>();
        ps.addAll(this.getProviderInstances(provider));
        for (Class pc : this.getProviderClasses(provider)) {
            Object o = this.getComponent(pc);
            if (o == null) continue;
            ps.add(provider.cast(o));
        }
        return ps;
    }

    public <T> Set<T> getServices(Class<T> provider) {
        LinkedHashSet<T> ps = new LinkedHashSet<T>();
        for (Class pc : this.getServiceClasses(provider)) {
            Object o = this.getComponent(pc);
            if (o == null) continue;
            ps.add(provider.cast(o));
        }
        return ps;
    }

    public <T> Set<T> getProvidersAndServices(Class<T> provider) {
        LinkedHashSet<T> ps = new LinkedHashSet<T>();
        ps.addAll(this.getProviderInstances(provider));
        for (Class pc : this.getProviderAndServiceClasses(provider)) {
            Object o = this.getComponent(pc);
            if (o == null) continue;
            ps.add(provider.cast(o));
        }
        return ps;
    }

    public <T> List<T> getInstances(Class<T> provider, String[] classNames) {
        LinkedList<T> ps = new LinkedList<T>();
        for (String className : classNames) {
            try {
                Class<?> c = Class.forName(className, true, this.getClassLoader());
                if (provider.isAssignableFrom(c)) {
                    Object o = this.getComponent(c);
                    if (o == null) continue;
                    ps.add(provider.cast(o));
                    continue;
                }
                LOGGER.severe("The class " + className + " is not assignable to the class " + provider.getName() + ". This class is ignored.");
            }
            catch (ClassNotFoundException e) {
                LOGGER.severe("The class " + className + " could not be found" + ". This class is ignored.");
            }
        }
        return ps;
    }

    private ClassLoader getClassLoader() {
        ClassLoader l = Thread.currentThread().getContextClassLoader();
        if (l == null) {
            l = ClassLoader.getSystemClassLoader();
        }
        return l;
    }

    private Object getComponent(Class provider) {
        ComponentProvider cp = this.componentProviderFactory.getComponentProvider(provider);
        return cp != null ? cp.getInstance() : null;
    }

    private <T> Set<T> getProviderInstances(Class<T> service) {
        LinkedHashSet<T> sp = new LinkedHashSet<T>();
        for (Object p : this.providerInstances) {
            if (!service.isInstance(p)) continue;
            sp.add(service.cast(p));
        }
        return sp;
    }

    private Set<Class> getProviderClasses(Class<?> service) {
        LinkedHashSet<Class> sp = new LinkedHashSet<Class>();
        for (Class<?> p : this.providers) {
            if (!service.isAssignableFrom(p)) continue;
            sp.add(p);
        }
        return sp;
    }

    private Set<Class> getProviderAndServiceClasses(Class<?> service) {
        LinkedHashSet<Class> sp = new LinkedHashSet<Class>(this.getProviderClasses(service));
        this.getServiceClasses(service, sp);
        return sp;
    }

    private Set<Class> getServiceClasses(Class<?> service) {
        LinkedHashSet<Class> sp = new LinkedHashSet<Class>();
        this.getServiceClasses(service, sp);
        return sp;
    }

    private void getServiceClasses(Class<?> service, Set<Class> sp) {
        Class<?>[] pca;
        LOGGER.log(Level.CONFIG, "Searching for providers that implement: " + service);
        for (Class<?> pc : pca = ServiceFinder.find(service, true).toClassArray()) {
            LOGGER.log(Level.CONFIG, "    Provider found: " + pc);
        }
        for (Class<?> pc : pca) {
            sp.add(pc);
        }
    }
}

