/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.generator.database;

import com.sun.jdo.spi.persistence.generator.database.LogHelperDatabaseGenerator;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public class DatabaseOutputStream
extends OutputStream {
    private static final Logger logger = LogHelperDatabaseGenerator.getLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle(DatabaseOutputStream.class);
    private Connection conn_ = null;

    public DatabaseOutputStream(Connection conn) {
        this.setConnection(conn);
    }

    public DatabaseOutputStream() {
    }

    public void close() {
        block3: {
            try {
                if (this.conn_ != null) {
                    this.conn_.commit();
                    this.conn_.close();
                }
            }
            catch (SQLException e) {
                if (!logger.isLoggable(500)) break block3;
                logger.fine("Exception in cleanup", (Object)e);
            }
        }
    }

    public void flush() {
        block3: {
            try {
                if (this.conn_ != null) {
                    this.conn_.commit();
                }
            }
            catch (SQLException e) {
                if (!logger.isLoggable(500)) break block3;
                logger.fine("Exception in cleanup", (Object)e);
            }
        }
    }

    public void write(int b) {
        throw new UnsupportedOperationException();
    }

    public void write(String stmt) throws SQLException {
        if (stmt == null || stmt.trim().length() == 0) {
            return;
        }
        PreparedStatement pstmt = this.conn_.prepareStatement(stmt);
        pstmt.execute();
    }

    public void setConnection(Connection conn) {
        this.conn_ = conn;
    }
}

