/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.enterprise.deployment.Application;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.LogHelperEJBCompiler;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.database.DatabaseConstants;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ResourceBundle;

public abstract class BaseProcessor
implements DatabaseConstants {
    protected static final Logger logger = LogHelperEJBCompiler.getLogger();
    protected static final ResourceBundle messages = I18NHelper.loadBundle((String)"com.sun.jdo.spi.persistence.support.ejb.ejbc.Bundle", (ClassLoader)BaseProcessor.class.getClassLoader());
    protected Application application;
    protected boolean create;
    protected String cliCreateTables;
    protected String cliDropAndCreateTables;
    protected String cliDropTables;
    protected String appRegisteredName;
    protected String appDeployedLocation;
    protected String appGeneratedLocation;
    protected String createJdbcFileName;
    protected String dropJdbcFileName;
    protected boolean debug = logger.isLoggable(500);

    protected abstract void processApplication();

    protected File getDDLFile(String fileName, boolean create) {
        File file = null;
        try {
            file = new File(fileName);
            if (this.debug) {
                logger.fine(create ? "ejb.BaseProcessor.createfilename" : "ejb.BaseProcessor.dropfilename", (Object)file.getName());
            }
        }
        catch (Exception e) {
            this.logI18NWarnMessage("Exception caught in BaseProcessor.getDDLFile()", this.appRegisteredName, null, e);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeDDLs(File f, Statement sql) throws IOException {
        BufferedReader reader = null;
        StringBuffer warningBuf = new StringBuffer();
        try {
            String s;
            reader = new BufferedReader(new FileReader(f));
            while ((s = reader.readLine()) != null) {
                try {
                    if (this.debug) {
                        logger.fine("ejb.BaseProcessor.executestatement", (Object)s);
                    }
                    sql.execute(s);
                }
                catch (SQLException ex) {
                    String msg = this.getI18NMessage("ejb.BaseProcessor.sqlexception", s, null, ex);
                    logger.warning(msg);
                    warningBuf.append("\n\t").append(msg);
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
            if (warningBuf.length() > 0) {
                String warning = this.getI18NMessage("ejb.BaseProcessor.tablewarning");
                this.warnUser(warning + warningBuf.toString());
            }
        }
    }

    protected void warnUser(String msg) {
    }

    protected void cannotConnect(String connName, Throwable ex) {
        this.logI18NWarnMessage("ejb.BaseProcessor.cannotConnect", connName, null, ex);
    }

    protected void fileIOError(String regName, Throwable ex) {
        this.logI18NWarnMessage("ejb.BaseProcessor.ioexception", regName, null, ex);
    }

    protected static void closeConn(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void logI18NInfoMessage(String errorCode, String regName, String fileName, Throwable ex) {
        String msg = this.getI18NMessage(errorCode, regName, fileName, ex);
        logger.info(msg);
    }

    protected void logI18NWarnMessage(String errorCode, String regName, String fileName, Throwable ex) {
        String msg = this.getI18NMessage(errorCode, regName, fileName, ex);
        logger.warning(msg);
        this.warnUser(msg);
    }

    protected String getI18NMessage(String errorCode) {
        return this.getI18NMessage(errorCode, null, null, null);
    }

    protected String getI18NMessage(String errorCode, String regName, String fileName, Throwable ex) {
        String msg = null;
        msg = null != ex ? I18NHelper.getMessage((ResourceBundle)messages, (String)errorCode, (String)regName, (String)ex.toString()) : (null != fileName ? I18NHelper.getMessage((ResourceBundle)messages, (String)errorCode, (String)regName, (String)fileName) : I18NHelper.getMessage((ResourceBundle)messages, (String)errorCode));
        return msg;
    }

    protected void setApplicationLocation() {
        if (null != this.appDeployedLocation) {
            return;
        }
    }

    protected void setGeneratedLocation() {
        if (null != this.appGeneratedLocation) {
            return;
        }
    }
}

