/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.jdo.spi.persistence.support.ejb.codegen.GeneratorException;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.util.ResourceBundle;

public class JDOCodeGeneratorHelper {
    private static final ResourceBundle messages = I18NHelper.loadBundle(JDOCodeGeneratorHelper.class);

    public static String getModuleName(EjbBundleDescriptor bundle) {
        String moduleName = null;
        Application application = bundle.getApplication();
        if (application.isVirtual()) {
            moduleName = application.getRegistrationName();
        } else {
            String jarName = bundle.getModuleDescriptor().getArchiveUri();
            int l = jarName.length();
            moduleName = jarName.substring(0, l - 4);
        }
        return moduleName;
    }

    public static GeneratorException createGeneratorException(String key, EjbBundleDescriptor bundle) {
        return new GeneratorException(I18NHelper.getMessage((ResourceBundle)messages, (String)key, (String)bundle.getApplication().getRegistrationName(), (String)JDOCodeGeneratorHelper.getModuleName(bundle)));
    }

    public static GeneratorException createGeneratorException(String key, EjbBundleDescriptor bundle, Exception e) {
        return new GeneratorException(I18NHelper.getMessage((ResourceBundle)messages, (String)key, (String)bundle.getApplication().getRegistrationName(), (String)JDOCodeGeneratorHelper.getModuleName(bundle), (String)e.getMessage()));
    }

    public static GeneratorException createGeneratorException(String key, String beanName, EjbBundleDescriptor bundle) {
        return new GeneratorException(I18NHelper.getMessage((ResourceBundle)messages, (String)key, (String)beanName, (String)bundle.getApplication().getRegistrationName(), (String)JDOCodeGeneratorHelper.getModuleName(bundle)));
    }

    public static GeneratorException createGeneratorException(String key, String beanName, EjbBundleDescriptor bundle, Exception e) {
        return JDOCodeGeneratorHelper.createGeneratorException(key, beanName, bundle, e.getMessage());
    }

    public static GeneratorException createGeneratorException(String key, String beanName, EjbBundleDescriptor bundle, Exception e, StringBuffer buf) {
        String msg = buf == null ? e.getMessage() : buf.append(e.getMessage()).append('\n').toString();
        return JDOCodeGeneratorHelper.createGeneratorException(key, beanName, bundle, msg);
    }

    public static GeneratorException createGeneratorException(String key, String beanName, EjbBundleDescriptor bundle, String msg) {
        return new GeneratorException(I18NHelper.getMessage((ResourceBundle)messages, (String)key, (Object[])new Object[]{beanName, bundle.getApplication().getRegistrationName(), JDOCodeGeneratorHelper.getModuleName(bundle), msg}));
    }
}

