// $ANTLR 2.7.6 (2005-12-22): "EJBQL.g" -> "EJBQLParser.java"$

    package com.sun.jdo.spi.persistence.support.ejb.ejbqlc;

    import antlr.MismatchedTokenException;
    import antlr.MismatchedCharException;
    import antlr.NoViableAltException;
    import antlr.NoViableAltForCharException;
    import antlr.TokenStreamRecognitionException;
    
    import java.util.ResourceBundle;
    import org.glassfish.persistence.common.I18NHelper;

import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;
import antlr.collections.AST;
import java.util.Hashtable;
import antlr.ASTFactory;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;

/**
 * This class defines the syntax analysis (parser) of the EJBQL compiler.
 *
 * @author  Michael Bouschen
 */
public class EJBQLParser extends antlr.LLkParser       implements EJBQLTokenTypes
 {

    /** I18N support. */
    protected final static ResourceBundle msgs = 
        I18NHelper.loadBundle(EJBQLParser.class);
    
    /** ANTLR method called when an error was detected. */
    public void reportError(RecognitionException ex)
    {
        EJBQLLexer.handleANTLRException(ex);
    }

    /** ANTLR method called when an error was detected. */
    public void reportError(String s)
    {
        ErrorMsg.error(0, 0, s);
    }

    /** */
    public void reportError(int line, int column, String s)
    {
        ErrorMsg.error(line, column, s);
    }

    /** ANTLR method called when a warning was detected. */
    public void reportWarning(String s)
    {
        throw new EJBQLException(s);
    }

    /** 
     * This method wraps the root rule in order to handle 
     * ANTLRExceptions thrown during parsing.
     */
    public void query ()
    {
        try {
            root();
        }
        catch (ANTLRException ex) {
            EJBQLLexer.handleANTLRException(ex);
        }
    }

protected EJBQLParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public EJBQLParser(TokenBuffer tokenBuf) {
  this(tokenBuf,2);
}

protected EJBQLParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public EJBQLParser(TokenStream lexer) {
  this(lexer,2);
}

public EJBQLParser(ParserSharedInputState state) {
  super(state,2);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

	public final void root() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST root_AST = null;
		EJBQLAST s_AST = null;
		EJBQLAST f_AST = null;
		EJBQLAST w_AST = null;
		EJBQLAST o_AST = null;
		
		try {      // for error handling
			selectClause();
			s_AST = (EJBQLAST)returnAST;
			fromClause();
			f_AST = (EJBQLAST)returnAST;
			whereClause();
			w_AST = (EJBQLAST)returnAST;
			orderbyClause();
			o_AST = (EJBQLAST)returnAST;
			match(Token.EOF_TYPE);
			if ( inputState.guessing==0 ) {
				root_AST = (EJBQLAST)currentAST.root;
				
				// switch the order of subnodes: the fromClause should come first, 
				// because it declares the identification variables used in the 
				// selectClause and the whereClause
				root_AST = (EJBQLAST)astFactory.make( (new ASTArray(4)).add((EJBQLAST)astFactory.create(QUERY,"QUERY")).add(f_AST).add(s_AST).add(w_AST)); //NOI18N
				if (o_AST != null) {
				root_AST.addChild(o_AST);
				}
				
				currentAST.root = root_AST;
				currentAST.child = root_AST!=null &&root_AST.getFirstChild()!=null ?
					root_AST.getFirstChild() : root_AST;
				currentAST.advanceChildToEnd();
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_0);
			} else {
			  throw ex;
			}
		}
		returnAST = root_AST;
	}
	
	public final void selectClause() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST selectClause_AST = null;
		
		try {      // for error handling
			EJBQLAST tmp2_AST = null;
			tmp2_AST = (EJBQLAST)astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp2_AST);
			match(SELECT);
			{
			switch ( LA(1)) {
			case DISTINCT:
			{
				EJBQLAST tmp3_AST = null;
				tmp3_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp3_AST);
				match(DISTINCT);
				break;
			}
			case OBJECT:
			case AVG:
			case MAX:
			case MIN:
			case SUM:
			case COUNT:
			case IDENT:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			projection();
			astFactory.addASTChild(currentAST, returnAST);
			selectClause_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_1);
			} else {
			  throw ex;
			}
		}
		returnAST = selectClause_AST;
	}
	
	public final void fromClause() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST fromClause_AST = null;
		
		try {      // for error handling
			EJBQLAST tmp4_AST = null;
			tmp4_AST = (EJBQLAST)astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp4_AST);
			match(FROM);
			identificationVarDecl();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop83:
			do {
				if ((LA(1)==COMMA)) {
					match(COMMA);
					identificationVarDecl();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop83;
				}
				
			} while (true);
			}
			fromClause_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_2);
			} else {
			  throw ex;
			}
		}
		returnAST = fromClause_AST;
	}
	
	public final void whereClause() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST whereClause_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case WHERE:
			{
				EJBQLAST tmp6_AST = null;
				tmp6_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp6_AST);
				match(WHERE);
				conditionalExpr();
				astFactory.addASTChild(currentAST, returnAST);
				whereClause_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case EOF:
			case ORDER:
			{
				if ( inputState.guessing==0 ) {
					whereClause_AST = (EJBQLAST)currentAST.root;
					
					// Add where true in the case the where clause is omitted
					whereClause_AST = (EJBQLAST)astFactory.make( (new ASTArray(2)).add((EJBQLAST)astFactory.create(WHERE,"WHERE")).add((EJBQLAST)astFactory.create(TRUE,"TRUE"))); //NOI18N
					
					currentAST.root = whereClause_AST;
					currentAST.child = whereClause_AST!=null &&whereClause_AST.getFirstChild()!=null ?
						whereClause_AST.getFirstChild() : whereClause_AST;
					currentAST.advanceChildToEnd();
				}
				whereClause_AST = (EJBQLAST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_3);
			} else {
			  throw ex;
			}
		}
		returnAST = whereClause_AST;
	}
	
	public final void orderbyClause() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST orderbyClause_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case ORDER:
			{
				EJBQLAST tmp7_AST = null;
				tmp7_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp7_AST);
				match(ORDER);
				match(BY);
				orderbyItem();
				astFactory.addASTChild(currentAST, returnAST);
				{
				_loop153:
				do {
					if ((LA(1)==COMMA)) {
						match(COMMA);
						orderbyItem();
						astFactory.addASTChild(currentAST, returnAST);
					}
					else {
						break _loop153;
					}
					
				} while (true);
				}
				orderbyClause_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case EOF:
			{
				orderbyClause_AST = (EJBQLAST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_0);
			} else {
			  throw ex;
			}
		}
		returnAST = orderbyClause_AST;
	}
	
	public final void projection() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST projection_AST = null;
		EJBQLAST p_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case IDENT:
			{
				pathExpr();
				p_AST = (EJBQLAST)returnAST;
				astFactory.addASTChild(currentAST, returnAST);
				if ( inputState.guessing==0 ) {
					
					if (p_AST.getType() != DOT) {
					ErrorMsg.error(p_AST.getLine(), p_AST.getColumn(), 
					I18NHelper.getMessage(msgs, "EXC_SyntaxErrorAt", //NOI18N
					p_AST.getText())); 
					}
					
				}
				projection_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case OBJECT:
			{
				EJBQLAST tmp10_AST = null;
				tmp10_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp10_AST);
				match(OBJECT);
				match(LPAREN);
				EJBQLAST tmp12_AST = null;
				tmp12_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp12_AST);
				match(IDENT);
				match(RPAREN);
				projection_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case AVG:
			case MAX:
			case MIN:
			case SUM:
			case COUNT:
			{
				{
				switch ( LA(1)) {
				case AVG:
				{
					EJBQLAST tmp14_AST = null;
					tmp14_AST = (EJBQLAST)astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp14_AST);
					match(AVG);
					break;
				}
				case MAX:
				{
					EJBQLAST tmp15_AST = null;
					tmp15_AST = (EJBQLAST)astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp15_AST);
					match(MAX);
					break;
				}
				case MIN:
				{
					EJBQLAST tmp16_AST = null;
					tmp16_AST = (EJBQLAST)astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp16_AST);
					match(MIN);
					break;
				}
				case SUM:
				{
					EJBQLAST tmp17_AST = null;
					tmp17_AST = (EJBQLAST)astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp17_AST);
					match(SUM);
					break;
				}
				case COUNT:
				{
					EJBQLAST tmp18_AST = null;
					tmp18_AST = (EJBQLAST)astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp18_AST);
					match(COUNT);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				match(LPAREN);
				{
				switch ( LA(1)) {
				case DISTINCT:
				{
					EJBQLAST tmp20_AST = null;
					tmp20_AST = (EJBQLAST)astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp20_AST);
					match(DISTINCT);
					break;
				}
				case IDENT:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				pathExpr();
				astFactory.addASTChild(currentAST, returnAST);
				match(RPAREN);
				projection_AST = (EJBQLAST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_1);
			} else {
			  throw ex;
			}
		}
		returnAST = projection_AST;
	}
	
	public final void pathExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST pathExpr_AST = null;
		
		try {      // for error handling
			EJBQLAST tmp22_AST = null;
			tmp22_AST = (EJBQLAST)astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp22_AST);
			match(IDENT);
			{
			_loop92:
			do {
				if ((LA(1)==DOT)) {
					EJBQLAST tmp23_AST = null;
					tmp23_AST = (EJBQLAST)astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp23_AST);
					match(DOT);
					EJBQLAST tmp24_AST = null;
					tmp24_AST = (EJBQLAST)astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp24_AST);
					match(IDENT);
				}
				else {
					break _loop92;
				}
				
			} while (true);
			}
			pathExpr_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_4);
			} else {
			  throw ex;
			}
		}
		returnAST = pathExpr_AST;
	}
	
	public final void identificationVarDecl() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST identificationVarDecl_AST = null;
		
		try {      // for error handling
			if ((LA(1)==IN) && (LA(2)==LPAREN)) {
				collectionMemberDecl();
				astFactory.addASTChild(currentAST, returnAST);
				identificationVarDecl_AST = (EJBQLAST)currentAST.root;
			}
			else if (((LA(1) >= SELECT && LA(1) <= NOT_MEMBER)) && (LA(2)==AS||LA(2)==IDENT)) {
				rangeVarDecl();
				astFactory.addASTChild(currentAST, returnAST);
				identificationVarDecl_AST = (EJBQLAST)currentAST.root;
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_5);
			} else {
			  throw ex;
			}
		}
		returnAST = identificationVarDecl_AST;
	}
	
	public final void collectionMemberDecl() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST collectionMemberDecl_AST = null;
		
		try {      // for error handling
			EJBQLAST tmp25_AST = null;
			tmp25_AST = (EJBQLAST)astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp25_AST);
			match(IN);
			match(LPAREN);
			pathExpr();
			astFactory.addASTChild(currentAST, returnAST);
			match(RPAREN);
			{
			switch ( LA(1)) {
			case AS:
			{
				match(AS);
				break;
			}
			case IDENT:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			EJBQLAST tmp29_AST = null;
			tmp29_AST = (EJBQLAST)astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp29_AST);
			match(IDENT);
			collectionMemberDecl_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_5);
			} else {
			  throw ex;
			}
		}
		returnAST = collectionMemberDecl_AST;
	}
	
	public final void rangeVarDecl() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST rangeVarDecl_AST = null;
		Token  abstractSchemaName = null;
		EJBQLAST abstractSchemaName_AST = null;
		Token  i = null;
		EJBQLAST i_AST = null;
		
		try {      // for error handling
			abstractSchemaName = LT(1);
			abstractSchemaName_AST = (EJBQLAST)astFactory.create(abstractSchemaName);
			matchNot(EOF);
			{
			switch ( LA(1)) {
			case AS:
			{
				match(AS);
				break;
			}
			case IDENT:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			i = LT(1);
			i_AST = (EJBQLAST)astFactory.create(i);
			match(IDENT);
			if ( inputState.guessing==0 ) {
				rangeVarDecl_AST = (EJBQLAST)currentAST.root;
				
				abstractSchemaName_AST.setType(ABSTRACT_SCHEMA_NAME);
				rangeVarDecl_AST = (EJBQLAST)astFactory.make( (new ASTArray(3)).add((EJBQLAST)astFactory.create(RANGE,"RANGE")).add(abstractSchemaName_AST).add(i_AST)); //NOI18N
				
				currentAST.root = rangeVarDecl_AST;
				currentAST.child = rangeVarDecl_AST!=null &&rangeVarDecl_AST.getFirstChild()!=null ?
					rangeVarDecl_AST.getFirstChild() : rangeVarDecl_AST;
				currentAST.advanceChildToEnd();
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_5);
			} else {
			  throw ex;
			}
		}
		returnAST = rangeVarDecl_AST;
	}
	
	public final void conditionalExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST conditionalExpr_AST = null;
		
		try {      // for error handling
			conditionalTerm();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop95:
			do {
				if ((LA(1)==OR)) {
					EJBQLAST tmp31_AST = null;
					tmp31_AST = (EJBQLAST)astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp31_AST);
					match(OR);
					conditionalTerm();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop95;
				}
				
			} while (true);
			}
			conditionalExpr_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_6);
			} else {
			  throw ex;
			}
		}
		returnAST = conditionalExpr_AST;
	}
	
	public final void conditionalTerm() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST conditionalTerm_AST = null;
		
		try {      // for error handling
			conditionalFactor();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop98:
			do {
				if ((LA(1)==AND)) {
					EJBQLAST tmp32_AST = null;
					tmp32_AST = (EJBQLAST)astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp32_AST);
					match(AND);
					conditionalFactor();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop98;
				}
				
			} while (true);
			}
			conditionalTerm_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_7);
			} else {
			  throw ex;
			}
		}
		returnAST = conditionalTerm_AST;
	}
	
	public final void conditionalFactor() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST conditionalFactor_AST = null;
		
		try {      // for error handling
			{
			switch ( LA(1)) {
			case NOT:
			{
				EJBQLAST tmp33_AST = null;
				tmp33_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp33_AST);
				match(NOT);
				break;
			}
			case TRUE:
			case FALSE:
			case CONCAT:
			case SUBSTRING:
			case LOCATE:
			case LENGTH:
			case ABS:
			case SQRT:
			case MOD:
			case PLUS:
			case MINUS:
			case STRING_LITERAL:
			case INT_LITERAL:
			case LONG_LITERAL:
			case FLOAT_LITERAL:
			case DOUBLE_LITERAL:
			case IDENT:
			case INPUT_PARAMETER:
			case LPAREN:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			conditionalPrimary();
			astFactory.addASTChild(currentAST, returnAST);
			conditionalFactor_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_8);
			} else {
			  throw ex;
			}
		}
		returnAST = conditionalFactor_AST;
	}
	
	public final void conditionalPrimary() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST conditionalPrimary_AST = null;
		
		try {      // for error handling
			boolean synPredMatched103 = false;
			if (((_tokenSet_9.member(LA(1))) && (_tokenSet_10.member(LA(2))))) {
				int _m103 = mark();
				synPredMatched103 = true;
				inputState.guessing++;
				try {
					{
					betweenExpr();
					}
				}
				catch (RecognitionException pe) {
					synPredMatched103 = false;
				}
				rewind(_m103);
inputState.guessing--;
			}
			if ( synPredMatched103 ) {
				betweenExpr();
				astFactory.addASTChild(currentAST, returnAST);
				conditionalPrimary_AST = (EJBQLAST)currentAST.root;
			}
			else {
				boolean synPredMatched105 = false;
				if (((LA(1)==IDENT) && (LA(2)==NOT||LA(2)==LIKE||LA(2)==DOT))) {
					int _m105 = mark();
					synPredMatched105 = true;
					inputState.guessing++;
					try {
						{
						likeExpr();
						}
					}
					catch (RecognitionException pe) {
						synPredMatched105 = false;
					}
					rewind(_m105);
inputState.guessing--;
				}
				if ( synPredMatched105 ) {
					likeExpr();
					astFactory.addASTChild(currentAST, returnAST);
					conditionalPrimary_AST = (EJBQLAST)currentAST.root;
				}
				else {
					boolean synPredMatched107 = false;
					if (((LA(1)==IDENT) && (LA(2)==NOT||LA(2)==IN||LA(2)==DOT))) {
						int _m107 = mark();
						synPredMatched107 = true;
						inputState.guessing++;
						try {
							{
							inExpr();
							}
						}
						catch (RecognitionException pe) {
							synPredMatched107 = false;
						}
						rewind(_m107);
inputState.guessing--;
					}
					if ( synPredMatched107 ) {
						inExpr();
						astFactory.addASTChild(currentAST, returnAST);
						conditionalPrimary_AST = (EJBQLAST)currentAST.root;
					}
					else {
						boolean synPredMatched109 = false;
						if (((LA(1)==IDENT||LA(1)==INPUT_PARAMETER) && (LA(2)==IS||LA(2)==DOT))) {
							int _m109 = mark();
							synPredMatched109 = true;
							inputState.guessing++;
							try {
								{
								nullComparisonExpr();
								}
							}
							catch (RecognitionException pe) {
								synPredMatched109 = false;
							}
							rewind(_m109);
inputState.guessing--;
						}
						if ( synPredMatched109 ) {
							nullComparisonExpr();
							astFactory.addASTChild(currentAST, returnAST);
							conditionalPrimary_AST = (EJBQLAST)currentAST.root;
						}
						else {
							boolean synPredMatched111 = false;
							if (((LA(1)==IDENT) && (LA(2)==IS||LA(2)==DOT))) {
								int _m111 = mark();
								synPredMatched111 = true;
								inputState.guessing++;
								try {
									{
									emptyCollectionComparisonExpr();
									}
								}
								catch (RecognitionException pe) {
									synPredMatched111 = false;
								}
								rewind(_m111);
inputState.guessing--;
							}
							if ( synPredMatched111 ) {
								emptyCollectionComparisonExpr();
								astFactory.addASTChild(currentAST, returnAST);
								conditionalPrimary_AST = (EJBQLAST)currentAST.root;
							}
							else {
								boolean synPredMatched113 = false;
								if (((LA(1)==IDENT||LA(1)==INPUT_PARAMETER) && (LA(2)==NOT||LA(2)==MEMBER||LA(2)==DOT))) {
									int _m113 = mark();
									synPredMatched113 = true;
									inputState.guessing++;
									try {
										{
										collectionMemberExpr();
										}
									}
									catch (RecognitionException pe) {
										synPredMatched113 = false;
									}
									rewind(_m113);
inputState.guessing--;
								}
								if ( synPredMatched113 ) {
									collectionMemberExpr();
									astFactory.addASTChild(currentAST, returnAST);
									conditionalPrimary_AST = (EJBQLAST)currentAST.root;
								}
								else if ((_tokenSet_9.member(LA(1))) && (_tokenSet_11.member(LA(2)))) {
									comparisonExpr();
									astFactory.addASTChild(currentAST, returnAST);
									conditionalPrimary_AST = (EJBQLAST)currentAST.root;
								}
								else {
									throw new NoViableAltException(LT(1), getFilename());
								}
								}}}}}
							}
							catch (RecognitionException ex) {
								if (inputState.guessing==0) {
									reportError(ex);
									recover(ex,_tokenSet_8);
								} else {
								  throw ex;
								}
							}
							returnAST = conditionalPrimary_AST;
						}
						
	public final void betweenExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST betweenExpr_AST = null;
		Token  n = null;
		EJBQLAST n_AST = null;
		
		try {      // for error handling
			arithmeticExpr();
			astFactory.addASTChild(currentAST, returnAST);
			{
			switch ( LA(1)) {
			case NOT:
			{
				n = LT(1);
				n_AST = (EJBQLAST)astFactory.create(n);
				match(NOT);
				break;
			}
			case BETWEEN:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			EJBQLAST tmp34_AST = null;
			tmp34_AST = (EJBQLAST)astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp34_AST);
			match(BETWEEN);
			arithmeticExpr();
			astFactory.addASTChild(currentAST, returnAST);
			match(AND);
			arithmeticExpr();
			astFactory.addASTChild(currentAST, returnAST);
			if ( inputState.guessing==0 ) {
				
				// map NOT BETWEEN to single operator NOT_BETWEEN
				if (n_AST != null)
				tmp34_AST.setType(NOT_BETWEEN);
				
			}
			betweenExpr_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_8);
			} else {
			  throw ex;
			}
		}
		returnAST = betweenExpr_AST;
	}
	
	public final void likeExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST likeExpr_AST = null;
		Token  n = null;
		EJBQLAST n_AST = null;
		
		try {      // for error handling
			pathExpr();
			astFactory.addASTChild(currentAST, returnAST);
			{
			switch ( LA(1)) {
			case NOT:
			{
				n = LT(1);
				n_AST = (EJBQLAST)astFactory.create(n);
				match(NOT);
				break;
			}
			case LIKE:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			EJBQLAST tmp36_AST = null;
			tmp36_AST = (EJBQLAST)astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp36_AST);
			match(LIKE);
			{
			switch ( LA(1)) {
			case STRING_LITERAL:
			{
				stringLiteral();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case INPUT_PARAMETER:
			{
				parameter();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			escape();
			astFactory.addASTChild(currentAST, returnAST);
			if ( inputState.guessing==0 ) {
				
				// map NOT LIKE to single operator NOT_LIKE
				if(n_AST != null)
				tmp36_AST.setType(NOT_LIKE);
				
			}
			likeExpr_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_8);
			} else {
			  throw ex;
			}
		}
		returnAST = likeExpr_AST;
	}
	
	public final void inExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST inExpr_AST = null;
		Token  n = null;
		EJBQLAST n_AST = null;
		
		try {      // for error handling
			pathExpr();
			astFactory.addASTChild(currentAST, returnAST);
			{
			switch ( LA(1)) {
			case NOT:
			{
				n = LT(1);
				n_AST = (EJBQLAST)astFactory.create(n);
				match(NOT);
				break;
			}
			case IN:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			EJBQLAST tmp37_AST = null;
			tmp37_AST = (EJBQLAST)astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp37_AST);
			match(IN);
			match(LPAREN);
			inCollectionElement();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop124:
			do {
				if ((LA(1)==COMMA)) {
					match(COMMA);
					inCollectionElement();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop124;
				}
				
			} while (true);
			}
			match(RPAREN);
			if ( inputState.guessing==0 ) {
				
				// map NOT BETWEEN to single operator NOT_IN
				if (n_AST != null)
				tmp37_AST.setType(NOT_IN);
				
			}
			inExpr_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_8);
			} else {
			  throw ex;
			}
		}
		returnAST = inExpr_AST;
	}
	
	public final void nullComparisonExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST nullComparisonExpr_AST = null;
		Token  n = null;
		EJBQLAST n_AST = null;
		
		try {      // for error handling
			{
			switch ( LA(1)) {
			case IDENT:
			{
				pathExpr();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case INPUT_PARAMETER:
			{
				parameter();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(IS);
			{
			switch ( LA(1)) {
			case NOT:
			{
				n = LT(1);
				n_AST = (EJBQLAST)astFactory.create(n);
				match(NOT);
				break;
			}
			case NULL:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			EJBQLAST tmp42_AST = null;
			tmp42_AST = (EJBQLAST)astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp42_AST);
			match(NULL);
			if ( inputState.guessing==0 ) {
				
				// map NOT NULL to single operator NOT_NULL
				if (n_AST != null)
				tmp42_AST.setType(NOT_NULL);
				
			}
			nullComparisonExpr_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_8);
			} else {
			  throw ex;
			}
		}
		returnAST = nullComparisonExpr_AST;
	}
	
	public final void emptyCollectionComparisonExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST emptyCollectionComparisonExpr_AST = null;
		Token  n = null;
		EJBQLAST n_AST = null;
		
		try {      // for error handling
			pathExpr();
			astFactory.addASTChild(currentAST, returnAST);
			match(IS);
			{
			switch ( LA(1)) {
			case NOT:
			{
				n = LT(1);
				n_AST = (EJBQLAST)astFactory.create(n);
				match(NOT);
				break;
			}
			case EMPTY:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			EJBQLAST tmp44_AST = null;
			tmp44_AST = (EJBQLAST)astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp44_AST);
			match(EMPTY);
			if ( inputState.guessing==0 ) {
				
				// map IS NOT EMPTY to single operator NOT_EMPTY
				if (n_AST != null)
				tmp44_AST.setType(NOT_EMPTY);
				
			}
			emptyCollectionComparisonExpr_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_8);
			} else {
			  throw ex;
			}
		}
		returnAST = emptyCollectionComparisonExpr_AST;
	}
	
	public final void collectionMemberExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST collectionMemberExpr_AST = null;
		Token  n = null;
		EJBQLAST n_AST = null;
		
		try {      // for error handling
			{
			switch ( LA(1)) {
			case IDENT:
			{
				pathExpr();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case INPUT_PARAMETER:
			{
				parameter();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			{
			switch ( LA(1)) {
			case NOT:
			{
				n = LT(1);
				n_AST = (EJBQLAST)astFactory.create(n);
				match(NOT);
				break;
			}
			case MEMBER:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			EJBQLAST tmp45_AST = null;
			tmp45_AST = (EJBQLAST)astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp45_AST);
			match(MEMBER);
			{
			switch ( LA(1)) {
			case OF:
			{
				match(OF);
				break;
			}
			case IDENT:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			pathExpr();
			astFactory.addASTChild(currentAST, returnAST);
			if ( inputState.guessing==0 ) {
				
				// map NOT MEMBER to single operator NOT_MEMBER
				if (n_AST != null)
				tmp45_AST.setType(NOT_MEMBER);
				
			}
			collectionMemberExpr_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_8);
			} else {
			  throw ex;
			}
		}
		returnAST = collectionMemberExpr_AST;
	}
	
	public final void comparisonExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST comparisonExpr_AST = null;
		
		try {      // for error handling
			arithmeticExpr();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop137:
			do {
				if (((LA(1) >= EQUAL && LA(1) <= LT))) {
					{
					switch ( LA(1)) {
					case EQUAL:
					{
						EJBQLAST tmp47_AST = null;
						tmp47_AST = (EJBQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp47_AST);
						match(EQUAL);
						break;
					}
					case NOT_EQUAL:
					{
						EJBQLAST tmp48_AST = null;
						tmp48_AST = (EJBQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp48_AST);
						match(NOT_EQUAL);
						break;
					}
					case LT:
					{
						EJBQLAST tmp49_AST = null;
						tmp49_AST = (EJBQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp49_AST);
						match(LT);
						break;
					}
					case LE:
					{
						EJBQLAST tmp50_AST = null;
						tmp50_AST = (EJBQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp50_AST);
						match(LE);
						break;
					}
					case GT:
					{
						EJBQLAST tmp51_AST = null;
						tmp51_AST = (EJBQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp51_AST);
						match(GT);
						break;
					}
					case GE:
					{
						EJBQLAST tmp52_AST = null;
						tmp52_AST = (EJBQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp52_AST);
						match(GE);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					arithmeticExpr();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop137;
				}
				
			} while (true);
			}
			comparisonExpr_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_8);
			} else {
			  throw ex;
			}
		}
		returnAST = comparisonExpr_AST;
	}
	
	public final void arithmeticExpr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST arithmeticExpr_AST = null;
		
		try {      // for error handling
			arithmeticTerm();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop141:
			do {
				if ((LA(1)==PLUS||LA(1)==MINUS)) {
					{
					switch ( LA(1)) {
					case PLUS:
					{
						EJBQLAST tmp53_AST = null;
						tmp53_AST = (EJBQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp53_AST);
						match(PLUS);
						break;
					}
					case MINUS:
					{
						EJBQLAST tmp54_AST = null;
						tmp54_AST = (EJBQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp54_AST);
						match(MINUS);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					arithmeticTerm();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop141;
				}
				
			} while (true);
			}
			arithmeticExpr_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_12);
			} else {
			  throw ex;
			}
		}
		returnAST = arithmeticExpr_AST;
	}
	
	public final void stringLiteral() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST stringLiteral_AST = null;
		Token  s = null;
		EJBQLAST s_AST = null;
		
		try {      // for error handling
			s = LT(1);
			s_AST = (EJBQLAST)astFactory.create(s);
			astFactory.addASTChild(currentAST, s_AST);
			match(STRING_LITERAL);
			if ( inputState.guessing==0 ) {
				
				// strip quotes from the token text
				String text = s_AST.getText();
				s_AST.setText(text.substring(1,text.length()-1));
				
			}
			stringLiteral_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_13);
			} else {
			  throw ex;
			}
		}
		returnAST = stringLiteral_AST;
	}
	
	public final void parameter() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST parameter_AST = null;
		
		try {      // for error handling
			EJBQLAST tmp55_AST = null;
			tmp55_AST = (EJBQLAST)astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp55_AST);
			match(INPUT_PARAMETER);
			parameter_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_14);
			} else {
			  throw ex;
			}
		}
		returnAST = parameter_AST;
	}
	
	public final void escape() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST escape_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case ESCAPE:
			{
				EJBQLAST tmp56_AST = null;
				tmp56_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp56_AST);
				match(ESCAPE);
				{
				switch ( LA(1)) {
				case STRING_LITERAL:
				{
					stringLiteral();
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case INPUT_PARAMETER:
				{
					parameter();
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				escape_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case EOF:
			case AND:
			case OR:
			case ORDER:
			case RPAREN:
			case COMMA:
			{
				escape_AST = (EJBQLAST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_8);
			} else {
			  throw ex;
			}
		}
		returnAST = escape_AST;
	}
	
	public final void inCollectionElement() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST inCollectionElement_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case TRUE:
			case FALSE:
			case STRING_LITERAL:
			case INT_LITERAL:
			case LONG_LITERAL:
			case FLOAT_LITERAL:
			case DOUBLE_LITERAL:
			{
				literal();
				astFactory.addASTChild(currentAST, returnAST);
				inCollectionElement_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case INPUT_PARAMETER:
			{
				parameter();
				astFactory.addASTChild(currentAST, returnAST);
				inCollectionElement_AST = (EJBQLAST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_15);
			} else {
			  throw ex;
			}
		}
		returnAST = inCollectionElement_AST;
	}
	
	public final void arithmeticTerm() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST arithmeticTerm_AST = null;
		
		try {      // for error handling
			arithmeticFactor();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop145:
			do {
				if ((LA(1)==STAR||LA(1)==DIV)) {
					{
					switch ( LA(1)) {
					case STAR:
					{
						EJBQLAST tmp57_AST = null;
						tmp57_AST = (EJBQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp57_AST);
						match(STAR);
						break;
					}
					case DIV:
					{
						EJBQLAST tmp58_AST = null;
						tmp58_AST = (EJBQLAST)astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp58_AST);
						match(DIV);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					arithmeticFactor();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop145;
				}
				
			} while (true);
			}
			arithmeticTerm_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_16);
			} else {
			  throw ex;
			}
		}
		returnAST = arithmeticTerm_AST;
	}
	
	public final void arithmeticFactor() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST arithmeticFactor_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case MINUS:
			{
				EJBQLAST tmp59_AST = null;
				tmp59_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp59_AST);
				match(MINUS);
				if ( inputState.guessing==0 ) {
					tmp59_AST.setType(UNARY_MINUS);
				}
				arithmeticFactor();
				astFactory.addASTChild(currentAST, returnAST);
				arithmeticFactor_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case PLUS:
			{
				EJBQLAST tmp60_AST = null;
				tmp60_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp60_AST);
				match(PLUS);
				if ( inputState.guessing==0 ) {
					tmp60_AST.setType(UNARY_PLUS);
				}
				arithmeticFactor();
				astFactory.addASTChild(currentAST, returnAST);
				arithmeticFactor_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case TRUE:
			case FALSE:
			case CONCAT:
			case SUBSTRING:
			case LOCATE:
			case LENGTH:
			case ABS:
			case SQRT:
			case MOD:
			case STRING_LITERAL:
			case INT_LITERAL:
			case LONG_LITERAL:
			case FLOAT_LITERAL:
			case DOUBLE_LITERAL:
			case IDENT:
			case INPUT_PARAMETER:
			case LPAREN:
			{
				arithmeticPrimary();
				astFactory.addASTChild(currentAST, returnAST);
				arithmeticFactor_AST = (EJBQLAST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_17);
			} else {
			  throw ex;
			}
		}
		returnAST = arithmeticFactor_AST;
	}
	
	public final void arithmeticPrimary() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST arithmeticPrimary_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case IDENT:
			{
				pathExpr();
				astFactory.addASTChild(currentAST, returnAST);
				arithmeticPrimary_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case TRUE:
			case FALSE:
			case STRING_LITERAL:
			case INT_LITERAL:
			case LONG_LITERAL:
			case FLOAT_LITERAL:
			case DOUBLE_LITERAL:
			{
				literal();
				astFactory.addASTChild(currentAST, returnAST);
				arithmeticPrimary_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case LPAREN:
			{
				match(LPAREN);
				conditionalExpr();
				astFactory.addASTChild(currentAST, returnAST);
				match(RPAREN);
				arithmeticPrimary_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case INPUT_PARAMETER:
			{
				parameter();
				astFactory.addASTChild(currentAST, returnAST);
				arithmeticPrimary_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case CONCAT:
			case SUBSTRING:
			case LOCATE:
			case LENGTH:
			case ABS:
			case SQRT:
			case MOD:
			{
				function();
				astFactory.addASTChild(currentAST, returnAST);
				arithmeticPrimary_AST = (EJBQLAST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_17);
			} else {
			  throw ex;
			}
		}
		returnAST = arithmeticPrimary_AST;
	}
	
	public final void literal() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST literal_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case TRUE:
			{
				EJBQLAST tmp63_AST = null;
				tmp63_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp63_AST);
				match(TRUE);
				literal_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case FALSE:
			{
				EJBQLAST tmp64_AST = null;
				tmp64_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp64_AST);
				match(FALSE);
				literal_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case STRING_LITERAL:
			{
				stringLiteral();
				astFactory.addASTChild(currentAST, returnAST);
				literal_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case INT_LITERAL:
			{
				EJBQLAST tmp65_AST = null;
				tmp65_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp65_AST);
				match(INT_LITERAL);
				literal_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case LONG_LITERAL:
			{
				EJBQLAST tmp66_AST = null;
				tmp66_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp66_AST);
				match(LONG_LITERAL);
				literal_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case FLOAT_LITERAL:
			{
				EJBQLAST tmp67_AST = null;
				tmp67_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp67_AST);
				match(FLOAT_LITERAL);
				literal_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case DOUBLE_LITERAL:
			{
				EJBQLAST tmp68_AST = null;
				tmp68_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp68_AST);
				match(DOUBLE_LITERAL);
				literal_AST = (EJBQLAST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_17);
			} else {
			  throw ex;
			}
		}
		returnAST = literal_AST;
	}
	
	public final void function() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST function_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case CONCAT:
			{
				EJBQLAST tmp69_AST = null;
				tmp69_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp69_AST);
				match(CONCAT);
				match(LPAREN);
				conditionalExpr();
				astFactory.addASTChild(currentAST, returnAST);
				match(COMMA);
				conditionalExpr();
				astFactory.addASTChild(currentAST, returnAST);
				match(RPAREN);
				function_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case SUBSTRING:
			{
				EJBQLAST tmp73_AST = null;
				tmp73_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp73_AST);
				match(SUBSTRING);
				match(LPAREN);
				conditionalExpr();
				astFactory.addASTChild(currentAST, returnAST);
				match(COMMA);
				conditionalExpr();
				astFactory.addASTChild(currentAST, returnAST);
				match(COMMA);
				conditionalExpr();
				astFactory.addASTChild(currentAST, returnAST);
				match(RPAREN);
				function_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case LENGTH:
			{
				EJBQLAST tmp78_AST = null;
				tmp78_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp78_AST);
				match(LENGTH);
				match(LPAREN);
				conditionalExpr();
				astFactory.addASTChild(currentAST, returnAST);
				match(RPAREN);
				function_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case LOCATE:
			{
				EJBQLAST tmp81_AST = null;
				tmp81_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp81_AST);
				match(LOCATE);
				match(LPAREN);
				conditionalExpr();
				astFactory.addASTChild(currentAST, returnAST);
				match(COMMA);
				conditionalExpr();
				astFactory.addASTChild(currentAST, returnAST);
				{
				switch ( LA(1)) {
				case COMMA:
				{
					match(COMMA);
					conditionalExpr();
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case RPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				match(RPAREN);
				function_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case ABS:
			{
				EJBQLAST tmp86_AST = null;
				tmp86_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp86_AST);
				match(ABS);
				match(LPAREN);
				conditionalExpr();
				astFactory.addASTChild(currentAST, returnAST);
				match(RPAREN);
				function_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case SQRT:
			{
				EJBQLAST tmp89_AST = null;
				tmp89_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp89_AST);
				match(SQRT);
				match(LPAREN);
				conditionalExpr();
				astFactory.addASTChild(currentAST, returnAST);
				match(RPAREN);
				function_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case MOD:
			{
				EJBQLAST tmp92_AST = null;
				tmp92_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp92_AST);
				match(MOD);
				match(LPAREN);
				conditionalExpr();
				astFactory.addASTChild(currentAST, returnAST);
				match(COMMA);
				conditionalExpr();
				astFactory.addASTChild(currentAST, returnAST);
				match(RPAREN);
				function_AST = (EJBQLAST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_17);
			} else {
			  throw ex;
			}
		}
		returnAST = function_AST;
	}
	
	public final void orderbyItem() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST orderbyItem_AST = null;
		
		try {      // for error handling
			pathExpr();
			astFactory.addASTChild(currentAST, returnAST);
			direction();
			astFactory.addASTChild(currentAST, returnAST);
			orderbyItem_AST = (EJBQLAST)currentAST.root;
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_18);
			} else {
			  throw ex;
			}
		}
		returnAST = orderbyItem_AST;
	}
	
	public final void direction() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		EJBQLAST direction_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case ASC:
			{
				EJBQLAST tmp96_AST = null;
				tmp96_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp96_AST);
				match(ASC);
				direction_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case DESC:
			{
				EJBQLAST tmp97_AST = null;
				tmp97_AST = (EJBQLAST)astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp97_AST);
				match(DESC);
				direction_AST = (EJBQLAST)currentAST.root;
				break;
			}
			case EOF:
			case COMMA:
			{
				if ( inputState.guessing==0 ) {
					direction_AST = (EJBQLAST)currentAST.root;
					
					// ASC is added as default
					direction_AST = (EJBQLAST)astFactory.create(ASC,"ASC"); //NOI18N
					
					currentAST.root = direction_AST;
					currentAST.child = direction_AST!=null &&direction_AST.getFirstChild()!=null ?
						direction_AST.getFirstChild() : direction_AST;
					currentAST.advanceChildToEnd();
				}
				direction_AST = (EJBQLAST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			if (inputState.guessing==0) {
				reportError(ex);
				recover(ex,_tokenSet_18);
			} else {
			  throw ex;
			}
		}
		returnAST = direction_AST;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"\"select\"",
		"\"from\"",
		"\"where\"",
		"\"distinct\"",
		"\"object\"",
		"\"null\"",
		"\"true\"",
		"\"false\"",
		"\"not\"",
		"\"and\"",
		"\"or\"",
		"\"between\"",
		"\"like\"",
		"\"in\"",
		"\"as\"",
		"\"unknown\"",
		"\"empty\"",
		"\"member\"",
		"\"of\"",
		"\"is\"",
		"\"escape\"",
		"\"concat\"",
		"\"substring\"",
		"\"locate\"",
		"\"length\"",
		"\"abs\"",
		"\"sqrt\"",
		"\"mod\"",
		"\"avg\"",
		"\"max\"",
		"\"min\"",
		"\"sum\"",
		"\"count\"",
		"\"order\"",
		"\"by\"",
		"\"asc\"",
		"\"desc\"",
		"EQUAL",
		"NOT_EQUAL",
		"GE",
		"GT",
		"LE",
		"LT",
		"PLUS",
		"MINUS",
		"STAR",
		"DIV",
		"STRING_LITERAL",
		"INT_LITERAL",
		"LONG_LITERAL",
		"FLOAT_LITERAL",
		"DOUBLE_LITERAL",
		"an identifier",
		"DOT",
		"INPUT_PARAMETER",
		"LPAREN",
		"RPAREN",
		"COMMA",
		"WS",
		"HEX_DIGIT",
		"EXPONENT",
		"FLOAT_SUFFIX",
		"UNICODE_DIGIT",
		"UNICODE_STR",
		"NEWLINE",
		"ESC",
		"FLOATINGPOINT_SUFFIX",
		"UNICODE_ESCAPE",
		"QUERY",
		"RANGE",
		"CMP_FIELD_ACCESS",
		"SINGLE_CMR_FIELD_ACCESS",
		"COLLECTION_CMR_FIELD_ACCESS",
		"IDENTIFICATION_VAR",
		"IDENTIFICATION_VAR_DECL",
		"ABSTRACT_SCHEMA_NAME",
		"CMP_FIELD",
		"SINGLE_CMR_FIELD",
		"COLLECTION_CMR_FIELD",
		"UNARY_MINUS",
		"UNARY_PLUS",
		"NOT_BETWEEN",
		"NOT_LIKE",
		"NOT_IN",
		"NOT_NULL",
		"NOT_EMPTY",
		"NOT_MEMBER"
	};
	
	protected void buildTokenTypeASTClassMap() {
		tokenTypeToASTClassMap=null;
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 2L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	private static final long[] mk_tokenSet_1() {
		long[] data = { 32L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
	private static final long[] mk_tokenSet_2() {
		long[] data = { 137438953538L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
	private static final long[] mk_tokenSet_3() {
		long[] data = { 137438953474L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());
	private static final long[] mk_tokenSet_4() {
		long[] data = { 3461015901328109602L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_4 = new BitSet(mk_tokenSet_4());
	private static final long[] mk_tokenSet_5() {
		long[] data = { 2305843146652647490L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_5 = new BitSet(mk_tokenSet_5());
	private static final long[] mk_tokenSet_6() {
		long[] data = { 3458764651259494402L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_6 = new BitSet(mk_tokenSet_6());
	private static final long[] mk_tokenSet_7() {
		long[] data = { 3458764651259510786L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_7 = new BitSet(mk_tokenSet_7());
	private static final long[] mk_tokenSet_8() {
		long[] data = { 3458764651259518978L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_8 = new BitSet(mk_tokenSet_8());
	private static final long[] mk_tokenSet_9() {
		long[] data = { 1006976733443787776L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_9 = new BitSet(mk_tokenSet_9());
	private static final long[] mk_tokenSet_10() {
		long[] data = { 1152780771379944448L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_10 = new BitSet(mk_tokenSet_10());
	private static final long[] mk_tokenSet_11() {
		long[] data = { 4611683961104530434L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_11 = new BitSet(mk_tokenSet_11());
	private static final long[] mk_tokenSet_12() {
		long[] data = { 3458903189724655618L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_12 = new BitSet(mk_tokenSet_12());
	private static final long[] mk_tokenSet_13() {
		long[] data = { 3461014252066762754L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_13 = new BitSet(mk_tokenSet_13());
	private static final long[] mk_tokenSet_14() {
		long[] data = { 3461014252077248514L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_14 = new BitSet(mk_tokenSet_14());
	private static final long[] mk_tokenSet_15() {
		long[] data = { 3458764513820540928L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_15 = new BitSet(mk_tokenSet_15());
	private static final long[] mk_tokenSet_16() {
		long[] data = { 3459325402189721602L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_16 = new BitSet(mk_tokenSet_16());
	private static final long[] mk_tokenSet_17() {
		long[] data = { 3461014252049985538L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_17 = new BitSet(mk_tokenSet_17());
	private static final long[] mk_tokenSet_18() {
		long[] data = { 2305843009213693954L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_18 = new BitSet(mk_tokenSet_18());
	
	}
