/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility;

import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.LogHelperUtility;
import com.sun.jdo.spi.persistence.utility.Semaphore;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.ResourceBundle;

public class SemaphoreImpl
implements Semaphore {
    private static final Logger _logger = LogHelperUtility.getLogger();
    private final String _owner;
    private final Object _lock = new Object();
    private Thread _holder = null;
    private int _counter = 0;
    private static final ResourceBundle messages = I18NHelper.loadBundle(SemaphoreImpl.class);

    public SemaphoreImpl(String owner) {
        this._owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() {
        boolean debug = _logger.isLoggable(300);
        if (debug) {
            Object[] items = new Object[]{this._owner, Thread.currentThread(), new Integer(this._counter)};
            _logger.finest("utility.semaphoreimpl.acquire", items);
        }
        Object object = this._lock;
        synchronized (object) {
            if (Thread.currentThread() == this._holder) {
                ++this._counter;
            } else {
                while (this._counter > 0) {
                    try {
                        this._lock.wait();
                    }
                    catch (InterruptedException e) {}
                }
                this._holder = Thread.currentThread();
                ++this._counter;
                if (debug) {
                    Object[] items = new Object[]{this._owner, Thread.currentThread(), new Integer(this._counter)};
                    _logger.finest("utility.semaphoreimpl.gotlock", items);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        boolean debug = _logger.isLoggable(300);
        if (debug) {
            Object[] items = new Object[]{this._owner, Thread.currentThread(), new Integer(this._counter)};
            _logger.finest("utility.semaphoreimpl.release", items);
        }
        Object object = this._lock;
        synchronized (object) {
            if (Thread.currentThread() == this._holder) {
                if (--this._counter == 0) {
                    this._holder = null;
                    this._lock.notify();
                }
            } else {
                throw new IllegalMonitorStateException(I18NHelper.getMessage(messages, "utility.semaphoreimpl.wrongthread", new Object[]{this._owner, Thread.currentThread()}));
            }
        }
    }
}

