/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MergedBundle
extends ResourceBundle {
    private final ResourceBundle _mainBundle;
    private final ResourceBundle _parentBundle;

    public MergedBundle(ResourceBundle mainBundle, ResourceBundle parentBundle) {
        this._mainBundle = mainBundle;
        this._parentBundle = parentBundle;
    }

    public Enumeration getKeys() {
        return this.mergeKeys();
    }

    private Enumeration mergeKeys() {
        HashSet noDuplicatesMerge = new HashSet(this.getCollection(this._mainBundle.getKeys()));
        noDuplicatesMerge.addAll(this.getCollection(this._parentBundle.getKeys()));
        return Collections.enumeration(noDuplicatesMerge);
    }

    private Collection getCollection(Enumeration enumeration) {
        ArrayList returnList = new ArrayList();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                returnList.add(enumeration.nextElement());
            }
        }
        return returnList;
    }

    protected Object handleGetObject(String key) throws MissingResourceException {
        try {
            return this._mainBundle.getObject(key);
        }
        catch (MissingResourceException mre) {
            return this._parentBundle.getObject(key);
        }
    }
}

