/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.archivist.EARBasedPersistenceHelper;
import com.sun.enterprise.deployment.archivist.PersistenceArchivist;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import java.util.Enumeration;
import java.util.Set;
import org.glassfish.api.container.CompositeSniffer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.glassfish.persistence.jpa.JPASniffer;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="jpaCompositeSniffer")
@Scoped(value=Singleton.class)
public class JPACompositeSniffer
extends JPASniffer
implements CompositeSniffer {
    public boolean handles(DeploymentContext context) {
        boolean isJPAApplication = false;
        ApplicationHolder holder = (ApplicationHolder)context.getModuleMetaData(ApplicationHolder.class);
        ReadableArchive appRoot = context.getSource();
        if (holder != null && holder.app != null && !(isJPAApplication = this.scanForPURootsInLibDir(appRoot, holder.app.getLibraryDirectory())) && DeploymentUtils.useV2Compatibility((DeploymentContext)context)) {
            isJPAApplication = this.scanForPURRootsInEarRoot(context, holder.app.getModules());
        }
        return isJPAApplication;
    }

    private boolean scanForPURRootsInEarRoot(DeploymentContext ctx, Set<ModuleDescriptor<BundleDescriptor>> modules) {
        boolean puPresentInEarRoot = false;
        Enumeration entriesInEar = ctx.getSource().entries();
        while (entriesInEar.hasMoreElements() && !puPresentInEarRoot) {
            String entry = (String)entriesInEar.nextElement();
            puPresentInEarRoot = PersistenceArchivist.isProbablePuRootJar((String)entry) && !EARBasedPersistenceHelper.isComponentJar((String)entry, modules);
        }
        return puPresentInEarRoot;
    }
}

