/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration.impl;

import com.sun.enterprise.registration.RegistrationException;
import com.sun.enterprise.registration.impl.RegistrationLogger;
import com.sun.enterprise.registration.impl.RepositoryManager;
import com.sun.enterprise.registration.impl.ServiceTag;
import com.sun.enterprise.registration.impl.environment.EnvironmentInformation;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelayService {
    private static final Logger logger = RegistrationLogger.getLogger();
    private static final String ENV_TOKEN = "@@@ENVIRONMENT@@@";
    private static final String TAG_TOKEN = "@@@SERVICE_TAGS@@@";
    private static final String PRODUCTNAME_TOKEN = "@@@PRODUCTNAME@@@";
    private static final String TEMPLATE_FILE = "com/sun/enterprise/registration/impl/relay-template.html";
    private static final String STRING_TOKEN = "@@@STRING.";
    private static final String END_TOKEN = "@@@";
    private RepositoryManager rm;
    private ResourceBundle bundle;
    Pattern stringPattern = Pattern.compile("@@@STRING.");

    public RelayService(String repositoryFile) throws RegistrationException {
        this.rm = new RepositoryManager(new File(repositoryFile));
        this.rm.updateRuntimeValues();
    }

    public void generateRegistrationPage(String outputFile) throws Exception {
        this.generateRegistrationPage(outputFile, Locale.getDefault());
    }

    public void generateRegistrationPage(String outputFile, Locale locale) throws Exception {
        String line;
        this.bundle = this.getResourceBundle(locale);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(TEMPLATE_FILE);
        if (is == null) {
            throw new RegistrationException("Template file [com/sun/enterprise/registration/impl/relay-template.html] not found");
        }
        List<ServiceTag> serviceTags = this.rm.getServiceTags();
        String productName = "";
        for (ServiceTag tag : serviceTags) {
            if (productName.length() > 0) {
                productName = productName + " + ";
            }
            productName = productName + tag.getSource();
        }
        String tags = this.getHtml(serviceTags);
        String env = this.getEnvironmentInformation();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
        while ((line = br.readLine()) != null) {
            if (line.indexOf(ENV_TOKEN) >= 0) {
                line = line.replaceAll(ENV_TOKEN, env);
            }
            if (line.indexOf(TAG_TOKEN) >= 0) {
                line = line.replaceAll(TAG_TOKEN, tags);
            }
            if (line.indexOf(PRODUCTNAME_TOKEN) >= 0) {
                line = line.replaceAll(PRODUCTNAME_TOKEN, productName);
            }
            line = this.replaceStringTokens(line);
            bw.write(line);
            bw.newLine();
        }
        bw.flush();
    }

    private String replaceStringTokens(String line) {
        int start = 0;
        int end = 0;
        StringBuffer buf = new StringBuffer("");
        while (start != -1) {
            start = line.indexOf(STRING_TOKEN, end);
            if (start == -1) continue;
            buf.append(line.substring(end, start));
            end = line.indexOf(END_TOKEN, start += STRING_TOKEN.length());
            if (end != -1) {
                try {
                    buf.append(this.bundle.getString(line.substring(start, end)));
                }
                catch (MissingResourceException ex) {
                    buf.append(STRING_TOKEN + line.substring(start, end) + END_TOKEN);
                }
                end += END_TOKEN.length();
                continue;
            }
            buf.append(END_TOKEN);
            end = start;
        }
        buf.append(line.substring(end));
        return buf.toString();
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle("com.sun.enterprise.registration.impl.LocalStrings", locale);
    }

    private String getHtml(List<ServiceTag> serviceTags) {
        if (serviceTags.isEmpty()) {
            logger.log(Level.WARNING, "No tags found");
            return "";
        }
        StringBuilder tags = new StringBuilder();
        for (ServiceTag serviceTag : serviceTags) {
            tags.append(this.getHtml(serviceTag));
        }
        return tags.toString();
    }

    private String getEnvironmentInformation() throws RegistrationException {
        StringBuilder html = new StringBuilder();
        EnvironmentInformation se = new EnvironmentInformation();
        Formatter fmt = new Formatter(html);
        html.append("<environment>");
        fmt.format("<hostname>%s</hostname>\r\n", se.getHostname());
        fmt.format("<hostId>%s</hostId>\r\n", se.getHostId());
        fmt.format("<osName>%s</osName>\r\n", se.getOsName());
        fmt.format("<osVersion>%s</osVersion>\r\n", se.getOsVersion());
        fmt.format("<osArchitecture>%s</osArchitecture>\r\n", se.getOsArchitecture());
        fmt.format("<systemModel>%s</systemModel>\r\n", se.getSystemModel());
        fmt.format("<systemManufacturer>%s</systemManufacturer>\r\n", se.getSystemManufacturer());
        fmt.format("<cpuManufacturer>%s</cpuManufacturer>\r\n", se.getCpuManufacturer());
        fmt.format("<serialNumber>%s</serialNumber>\r\n", se.getSerialNumber());
        this.addNumericTag(fmt, "physmem", se.getPhysMem());
        html.append("<cpuinfo>\r\n");
        this.addNumericTag(fmt, "sockets", se.getSockets());
        this.addNumericTag(fmt, "cores", se.getCores());
        this.addNumericTag(fmt, "virtcpus", se.getVirtCpus());
        fmt.format("<name>%s</name>\r\n", se.getCpuName());
        this.addNumericTag(fmt, "clockrate", se.getClockRate());
        html.append("</cpuinfo>\r\n");
        html.append("</environment>\r\n");
        return html.toString();
    }

    private void addNumericTag(Formatter fmt, String tag, String value) {
        try {
            int i = Integer.valueOf(value);
            fmt.format("<" + tag + ">%s</" + tag + ">\r\n", i);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private String getHtml(ServiceTag tag) {
        StringBuilder html = new StringBuilder();
        Formatter fmt = new Formatter(html);
        fmt.format("<service_tag>\r\n", new Object[0]);
        fmt.format("<instance_urn>%s</instance_urn>\r\n", tag.getInstanceURN());
        fmt.format("<product_name>%s</product_name>\r\n", tag.getProductName());
        fmt.format("<product_version>%s</product_version>\r\n", tag.getProductVersion());
        fmt.format("<product_urn>%s</product_urn>\r\n", tag.getProductURN());
        fmt.format("<product_parent_urn/>\r\n", new Object[0]);
        fmt.format("<product_parent>%s</product_parent>\r\n", tag.getProductParent());
        fmt.format("<product_defined_inst_id>%s</product_defined_inst_id>\r\n", tag.getProductDefinedInstID());
        fmt.format("<product_vendor>%s</product_vendor>\r\n", tag.getProductVendor());
        fmt.format("<platform_arch>%s</platform_arch>\r\n", tag.getPlatformArch());
        fmt.format("<timestamp>%s</timestamp>", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(new Date()));
        fmt.format("<container>%s</container>\r\n", tag.getContainer());
        fmt.format("<source>%s</source>\r\n", tag.getSource());
        fmt.format("<installer_uid>-1</installer_uid>", new Object[0]);
        fmt.format("</service_tag>\r\n", new Object[0]);
        return html.toString();
    }
}

