/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration.impl;

import com.sun.enterprise.registration.RegistrationDescriptor;
import com.sun.enterprise.registration.impl.SvcTag;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceTag
implements RegistrationDescriptor {
    private final SvcTag svcTag;
    private String platformArch;
    private String productParent;
    public static final String PRODUCT_NAME = "product_name";
    public static final String PRODUCT_VERSION = "product_version";
    public static final String PRODUCT_URN = "product_urn";
    public static final String PRODUCT_PARENT_URN = "product_parent_urn";
    public static final String PRODUCT_PARENT = "product_parent";
    public static final String PRODUCT_DEFINED_INST_ID = "product_defined_inst_id";
    public static final String PLATFORM_ARCH = "platform_arch";
    public static final String CONTAINER = "container";
    public static final String SOURCE = "source";
    public static final String INSTANCE_URN = "instance_urn";
    public static final String PRODUCT_VENDOR = "product_vendor";
    public static final String STATUS = "status";
    public static final String REGISTRATION_STATUS = "registration_status";
    public static final String SERVICE_TAG = "service_tag";

    public ServiceTag(Element tagData) {
        String instanceURN = this.getValue(tagData, INSTANCE_URN);
        if (instanceURN == null) {
            instanceURN = ServiceTag.getNewInstanceURN();
        }
        this.svcTag = new SvcTag(instanceURN);
        this.svcTag.setTimestamp(new Date());
        this.setProductName(this.getValue(tagData, PRODUCT_NAME));
        this.setProductVersion(this.getValue(tagData, PRODUCT_VERSION));
        this.setProductURN(this.getValue(tagData, PRODUCT_URN));
        this.setProductParentURN(this.getValue(tagData, PRODUCT_PARENT_URN));
        this.setProductParent(this.getValue(tagData, PRODUCT_PARENT));
        this.setProductDefinedInstID(this.getValue(tagData, PRODUCT_DEFINED_INST_ID));
        this.setPlatformArch(this.getValue(tagData, PLATFORM_ARCH));
        this.setProductVendor(this.getValue(tagData, PRODUCT_VENDOR));
        this.setContainer(this.getValue(tagData, CONTAINER));
        this.setSource(this.getValue(tagData, SOURCE));
        this.setStatus(this.getValue(tagData, STATUS));
    }

    public ServiceTag(Properties tagData) {
        String instanceURN = tagData.getProperty(INSTANCE_URN);
        if (instanceURN == null) {
            instanceURN = ServiceTag.getNewInstanceURN();
        }
        this.svcTag = new SvcTag(instanceURN);
        this.svcTag.setTimestamp(new Date());
        this.setProductName(tagData.getProperty(PRODUCT_NAME));
        this.setProductVersion(tagData.getProperty(PRODUCT_VERSION));
        this.setProductURN(tagData.getProperty(PRODUCT_URN));
        this.setProductParentURN(tagData.getProperty(PRODUCT_PARENT_URN));
        this.setProductParent(tagData.getProperty(PRODUCT_PARENT));
        this.setProductDefinedInstID(tagData.getProperty(PRODUCT_DEFINED_INST_ID));
        this.setPlatformArch(tagData.getProperty(PLATFORM_ARCH));
        this.setProductVendor(tagData.getProperty(PRODUCT_VENDOR));
        this.setContainer(tagData.getProperty(CONTAINER));
        this.setSource(tagData.getProperty(SOURCE));
        this.setStatus(tagData.getProperty(STATUS));
    }

    public void setProductName(String str) {
        this.svcTag.setProductName(str);
    }

    public void setProductURN(String str) {
        this.svcTag.setProductURN(str);
    }

    public void setProductVersion(String str) {
        this.svcTag.setProductVersion(str);
    }

    public void setProductParentURN(String str) {
        this.svcTag.setProductParentURN(str);
    }

    public void setProductParent(String str) {
        this.productParent = str;
    }

    public void setProductDefinedInstID(String str) {
        this.svcTag.setProductDefinedInstID(str);
    }

    public void setPlatformArch(String str) {
        this.platformArch = str;
    }

    public void setProductVendor(String str) {
        this.svcTag.setProductVendor(str);
    }

    public void setContainer(String str) {
        this.svcTag.setContainer(str);
    }

    public void setSource(String str) {
        this.svcTag.setSource(str);
    }

    public void setStatus(String status) {
        this.svcTag.setStatus(status);
    }

    public SvcTag getSvcTag() {
        return this.svcTag;
    }

    private String getValue(Element rootElement, String subElementName) {
        NodeList nodes = rootElement.getElementsByTagName(subElementName);
        if (nodes.getLength() > 0) {
            return ((Element)nodes.item(0)).getTextContent();
        }
        return null;
    }

    public static List<SvcTag> getSvcTags(List<ServiceTag> serviceTags) {
        ArrayList<SvcTag> list = new ArrayList<SvcTag>();
        for (ServiceTag s : serviceTags) {
            list.add(s.getSvcTag());
        }
        return list;
    }

    public static String getNewInstanceURN() {
        return "urn:st:" + UUID.randomUUID().toString();
    }

    public static String getDefaultProductDefinedInstID() {
        StringBuilder definedId = new StringBuilder();
        definedId.append(ServiceTag.getPropertyString("os.name"));
        definedId.append(ServiceTag.getPropertyString("os.version"));
        definedId.append(ServiceTag.getPropertyString("java.version"));
        definedId.append(ServiceTag.getPropertyString("java.home"));
        return definedId.toString();
    }

    private static String getPropertyString(String name) {
        String prop = System.getProperty(name);
        if (prop != null) {
            return name + "=" + prop + ";";
        }
        return "";
    }

    public String getInstanceURN() {
        return this.svcTag.getInstanceURN();
    }

    public String getProductName() {
        return this.svcTag.getProductName();
    }

    public String getProductURN() {
        return this.svcTag.getProductURN();
    }

    public String getProductVersion() {
        return this.svcTag.getProductVersion();
    }

    public String getProductParentURN() {
        return this.svcTag.getProductParentURN();
    }

    public String getProductDefinedInstID() {
        return this.svcTag.getProductDefinedInstID();
    }

    public String getContainer() {
        return this.svcTag.getContainer();
    }

    public String getSource() {
        return this.svcTag.getSource();
    }

    public String getProductVendor() {
        return this.svcTag.getProductVendor();
    }

    public String getPlatformArch() {
        if (this.platformArch == null || this.platformArch.length() == 0) {
            this.platformArch = System.getProperty("os.arch");
        }
        return this.platformArch;
    }

    public String getProductParent() {
        return this.productParent;
    }

    public Element getElement(Document doc) {
        Element rootElem = doc.createElement(SERVICE_TAG);
        this.addChild(doc, rootElem, INSTANCE_URN, this.getInstanceURN());
        this.addChild(doc, rootElem, PRODUCT_NAME, this.getProductName());
        this.addChild(doc, rootElem, PRODUCT_VERSION, this.getProductVersion());
        this.addChild(doc, rootElem, PRODUCT_URN, this.getProductURN());
        this.addChild(doc, rootElem, PRODUCT_PARENT_URN, this.getProductParentURN());
        this.addChild(doc, rootElem, PRODUCT_PARENT, this.getProductParent());
        this.addChild(doc, rootElem, PRODUCT_DEFINED_INST_ID, this.getProductDefinedInstID());
        this.addChild(doc, rootElem, PRODUCT_VENDOR, this.getProductVendor());
        this.addChild(doc, rootElem, PLATFORM_ARCH, this.getPlatformArch());
        this.addChild(doc, rootElem, CONTAINER, this.getContainer());
        this.addChild(doc, rootElem, SOURCE, this.getSource());
        this.addChild(doc, rootElem, STATUS, Status.NOT_TRANSFERRED.toString());
        this.addChild(doc, rootElem, REGISTRATION_STATUS, RegistrationDescriptor.RegistrationStatus.NOT_REGISTERED.toString());
        return rootElem;
    }

    private void addChild(Document doc, Element rootElem, String name, String value) {
        Element element = doc.createElement(name);
        element.setTextContent(value);
        rootElem.appendChild(element);
    }

    public String toString() {
        return "ServiceTag:\n" + this.svcTag.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        TRANSFERRED,
        NOT_TRANSFERRED;

    }
}

