/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration.impl.environment;

import com.sun.enterprise.registration.impl.environment.SystemEnvironment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashSet;

class WindowsSystemEnvironment
extends SystemEnvironment {
    WindowsSystemEnvironment() {
        String procId;
        this.getWmicResult("computersystem", "get", "model");
        this.setSystemModel(this.getWmicResult("computersystem", "get", "model"));
        this.setSystemManufacturer(this.getWmicResult("computersystem", "get", "manufacturer"));
        this.setSerialNumber(this.getWmicResult("bios", "get", "serialnumber"));
        String cpuMfr = this.getWmicResult("cpu", "get", "manufacturer");
        if (cpuMfr.length() == 0 && (procId = System.getenv("processor_identifer")) != null) {
            String[] s = procId.split(",");
            cpuMfr = s[s.length - 1].trim();
        }
        this.setCpuManufacturer(cpuMfr);
        this.setSockets(this.getWindowsSockets());
        this.setCores(this.getWindowsCores());
        this.setVirtCpus(this.getWindowsVirtCpus());
        this.setPhysMem(this.getWindowsPhysMem());
        this.setCpuName(this.getWmicResult("cpu", "get", "Name"));
        this.setClockRate(this.getWmicResult("cpu", "get", "MaxClockSpeed"));
        try {
            File f = new File("TempWmicBatchFile.bat");
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getWindowsVirtCpus() {
        String res = this.getWmicResult("cpu", "get", "NumberOfLogicalProcessors");
        if (res == null || res.equals("")) {
            res = "1";
        }
        return res;
    }

    private String getWindowsCores() {
        String res = this.getWmicResult("cpu", "get", "NumberOfCores");
        if (res == null || res.equals("")) {
            res = "1";
        }
        return res;
    }

    private String getWindowsSockets() {
        String res = this.getFullWmicResult("cpu", "get", "DeviceID");
        HashSet<String> set = new HashSet<String>();
        for (String line : res.split("\n")) {
            if ((line = line.trim()).equals("")) continue;
            set.add(line);
        }
        if (set.size() == 0) {
            return "1";
        }
        return "" + set.size();
    }

    private String getWindowsPhysMem() {
        String mem = this.getWmicResult("computersystem", "get", "TotalPhysicalMemory");
        if (mem == null || mem.trim().equals("")) {
            return "0";
        }
        try {
            long l = Long.parseLong(mem);
            return "" + l / 0x100000L;
        }
        catch (Exception e) {
            return "0";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWmicResult(String alias, String verb, String property) {
        String res = "";
        BufferedReader in = null;
        try {
            ProcessBuilder pb = new ProcessBuilder("cmd", "/C", "WMIC", alias, verb, property);
            Process p = pb.start();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
            bw.write(13);
            bw.flush();
            bw.close();
            p.waitFor();
            if (p.exitValue() == 0) {
                in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = null;
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() == 0) continue;
                    res = line;
                }
                String string = res;
                return string;
            }
        }
        catch (Exception e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return res.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFullWmicResult(String alias, String verb, String property) {
        StringBuilder res = new StringBuilder();
        BufferedReader in = null;
        try {
            ProcessBuilder pb = new ProcessBuilder("cmd", "/C", "WMIC", alias, verb, property);
            Process p = pb.start();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
            bw.write(13);
            bw.flush();
            bw.close();
            p.waitFor();
            if (p.exitValue() == 0) {
                in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = null;
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() == 0 || line.toLowerCase().indexOf(property.toLowerCase()) != -1) continue;
                    res.append(line).append("\n");
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return res.toString();
    }
}

