/*
 * Decompiled with CFR 0.152.
 */
package samples.connectors.mailconnector.ra;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.mail.Message;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.AuthenticationMechanism;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.Connector;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.WorkRejectedException;
import javax.transaction.xa.XAResource;
import samples.connectors.mailconnector.api.JavaMailMessageListener;
import samples.connectors.mailconnector.ra.inbound.ActivationSpecImpl;
import samples.connectors.mailconnector.ra.inbound.EndpointConsumer;
import samples.connectors.mailconnector.ra.inbound.PollingThread;

@Connector(description={"Sample adapter using the JavaMail API"}, displayName={"InboundResourceAdapter"}, vendorName="Sun Microsystems, Inc.", eisType="MAIL", version="1.0", authMechanisms={@AuthenticationMechanism(authMechanism="BasicPassword", credentialInterface=AuthenticationMechanism.CredentialInterface.PasswordCredential)})
public class ResourceAdapterImpl
implements ResourceAdapter,
Serializable {
    protected transient BootstrapContext bootCtx;
    protected transient WorkManager workManager;
    public transient Context jndiContext = null;
    private Work pollingThread;
    public Method onMessage = null;
    static Logger logger = Logger.getLogger("samples.connectors.mailconnector.ra", "samples.connectors.mailconnector.ra.LocalStrings");
    ResourceBundle resource = ResourceBundle.getBundle("samples.connectors.mailconnector.ra.LocalStrings");

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        this.bootCtx = ctx;
        try {
            this.jndiContext = new InitialContext();
            this.workManager = ctx.getWorkManager();
        }
        catch (Exception ex) {
            logger.severe(this.resource.getString("resourceadapterimpl.noservice"));
            ex.printStackTrace();
            throw new ResourceAdapterInternalException(this.resource.getString("resourceadapterimpl.noservice"));
        }
        this.setOnMessageMethod();
        try {
            this.pollingThread = new PollingThread(this.workManager);
            this.workManager.scheduleWork(this.pollingThread);
        }
        catch (WorkRejectedException ex) {
            ResourceAdapterInternalException newEx = new ResourceAdapterInternalException(MessageFormat.format(this.resource.getString("resourceadapterimpl.worker_activation_rejected"), ex.getMessage()));
            newEx.initCause((Throwable)ex);
            throw newEx;
        }
        catch (Exception ex) {
            ResourceAdapterInternalException newEx = new ResourceAdapterInternalException(MessageFormat.format(this.resource.getString("resourceadapterimpl.worker_activation_failed"), ex.getMessage()));
            newEx.initCause((Throwable)ex);
            throw newEx;
        }
    }

    private void setOnMessageMethod() {
        Method onMessageMethod = null;
        try {
            Class<JavaMailMessageListener> msgListenerClass = JavaMailMessageListener.class;
            Class[] paramTypes = new Class[]{Message.class};
            onMessageMethod = msgListenerClass.getMethod("onMessage", paramTypes);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        this.onMessage = onMessageMethod;
    }

    public Method getOnMessageMethod() {
        return this.onMessage;
    }

    public void stop() {
        logger.info("[RA.stop()] Stopping the polling thread");
        try {
            ((PollingThread)this.pollingThread).stopPolling();
        }
        catch (Exception ex) {
            logger.severe(this.resource.getString("resourceadapterimpl.noservice"));
        }
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws NotSupportedException {
        logger.finest("[RA.endpointActivation()] Entered");
        try {
            EndpointConsumer ec = new EndpointConsumer(endpointFactory, (ActivationSpecImpl)spec);
            ((PollingThread)this.pollingThread).addEndpointConsumer(endpointFactory, ec);
        }
        catch (Exception ex) {
            logger.finest("[RA.endpointActivation()] An Exception was caught while activating the endpoint");
            logger.finest("[RA.endpointActivation()] Please check the server logs for details");
            NotSupportedException newEx = new NotSupportedException(MessageFormat.format(this.resource.getString("resourceadapterimpl.endpoint_activation_fail"), ex.getMessage()));
            newEx.initCause((Throwable)ex);
        }
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        logger.finest("[RA.endpointdeactivation()] Entered");
        ((PollingThread)this.pollingThread).removeEndpointConsumer(endpointFactory);
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return null;
    }
}

