/*
 * Decompiled with CFR 0.152.
 */
package samples.connectors.mailconnector.ra.inbound;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkContext;
import javax.resource.spi.work.WorkContextProvider;
import samples.connectors.mailconnector.ra.inbound.EndpointConsumer;
import samples.connectors.mailconnector.ra.inbound.MySecurityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliveryThread
implements Work,
WorkContextProvider {
    public static final Logger logger = Logger.getLogger("samples.connectors.mailconnector.ra.inbound");
    static ResourceBundle resource = ResourceBundle.getBundle("samples.connectors.mailconnector.ra.inbound.LocalStrings");
    private EndpointConsumer endpointConsumer;
    private Message msg;
    private List<WorkContext> workContexts = new ArrayList<WorkContext>();

    public DeliveryThread(EndpointConsumer endpointConsumer, Message msg) {
        this.endpointConsumer = endpointConsumer;
        this.msg = msg;
        this.initializeWorkContexts(msg);
        logger.fine("[DeliveryThread::Constructor] Leaving");
    }

    public void release() {
        logger.fine("[DT] Worker Manager called release for deliveryThread ");
    }

    public void run() {
        logger.fine("[DT] WorkManager started delivery thread ");
        try {
            this.endpointConsumer.deliverMessage(this.msg);
        }
        catch (Exception te) {
            logger.info("deliveryThread::run got an exception");
            te.printStackTrace();
        }
        logger.fine("[DT] DeliveryThread leaving");
    }

    public List<WorkContext> getWorkContexts() {
        return this.workContexts;
    }

    private void initializeWorkContexts(Message msg) {
        try {
            Address[] recepients = msg.getFrom();
            if (recepients != null && recepients.length > 0) {
                Address recepient = recepients[0];
                String recepientId = recepient.toString();
                if (recepientId.indexOf("@") > 0) {
                    recepientId = recepientId.substring(0, recepientId.indexOf("@"));
                }
                MySecurityContext mysc = new MySecurityContext(recepientId, recepientId, recepientId);
                this.getWorkContexts().add((WorkContext)mysc);
            }
        }
        catch (MessagingException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }
}

