/*
 * Decompiled with CFR 0.152.
 */
package samples.connectors.mailconnector.ra.inbound;

import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import samples.connectors.mailconnector.ra.inbound.ActivationSpecImpl;

public class MailServerFolder {
    private Session session;
    private Authenticator authenticator;
    private Store store;
    private Folder folder;
    private Properties mailProperties;
    private String folderName;
    private String userName;
    private String password;
    private String serverName;
    private String protocol;
    public static final Logger logger = Logger.getLogger("samples.connectors.mailconnector.ra.inbound");

    public MailServerFolder(ActivationSpecImpl spec) throws Exception {
        this.folderName = spec.getFolderName();
        this.userName = spec.getUserName();
        this.password = spec.getPassword();
        this.serverName = spec.getServerName();
        this.protocol = spec.getProtocol();
        this.authenticator = null;
        this.mailProperties = new Properties();
        this.mailProperties.setProperty("mail.transport.protocol", "smtp");
        this.mailProperties.setProperty("mail.store.protocol", this.protocol);
        this.mailProperties.setProperty("mail.smtp.host", this.serverName);
        try {
            this.open();
        }
        catch (Exception te) {
            logger.severe("[S] Caught an exception when opening the Folder");
            throw te;
        }
    }

    public void close() throws Exception {
        this.store.close();
        this.store = null;
        this.session = null;
        this.authenticator = null;
    }

    private void open() throws Exception {
        try {
            this.session = Session.getDefaultInstance((Properties)this.mailProperties);
            this.store = this.session.getStore();
        }
        catch (Exception te) {
            logger.info("[MSF] Caught an exception when obtaining a JavaMail Session");
            throw te;
        }
        this.store.connect(this.serverName, this.userName, this.password);
        this.folder = this.store.getFolder(this.folderName);
        if (this.folder == null || !this.folder.exists()) {
            Exception e = new Exception("Folder " + this.folderName + " does not exist or is not found");
            throw e;
        }
        this.folder.open(2);
    }

    private void reopen() throws Exception {
        if (!this.folder.isOpen()) {
            this.folder.open(2);
        }
    }

    public Message[] getNewMessages() throws Exception {
        this.reopen();
        try {
            if (this.folder.hasNewMessages()) {
                int newMsgs = this.folder.getNewMessageCount();
                int msgCount = this.folder.getMessageCount();
                Message[] msgs = this.folder.getMessages(msgCount - newMsgs + 1, msgCount);
                return msgs;
            }
        }
        catch (Exception e) {
            logger.info("[MSF] Exception obtaining messages from mail server");
        }
        return null;
    }

    public String[] getNewMessageHeaders() throws Exception {
        this.reopen();
        try {
            if (this.folder.hasNewMessages()) {
                int newMsgs = this.folder.getNewMessageCount();
                int msgCount = this.folder.getMessageCount();
                Message[] msgs = this.folder.getMessages(msgCount - newMsgs + 1, msgCount);
                String[] headers = new String[msgs.length];
                logger.info("messages length: " + msgs.length);
                logger.info("headers length: " + headers.length);
                for (int i = 0; i < headers.length; ++i) {
                    logger.info("[MSF] Packing message with SUBJECT: " + msgs[i].getSubject());
                    headers[i] = msgs[i].getSubject();
                }
                return headers;
            }
        }
        catch (Exception e) {
            logger.severe("[MSF] Exception obtaining messages from mail server:");
            e.printStackTrace();
        }
        return null;
    }

    public boolean hasNewMessages() throws Exception {
        this.reopen();
        return this.folder.hasNewMessages();
    }
}

