/*
 * Decompiled with CFR 0.152.
 */
package samples.connectors.mailconnector.ra.inbound;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.resource.spi.work.SecurityContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import org.glassfish.security.common.PrincipalImpl;

public class MySecurityContext
extends SecurityContext {
    private String userName;
    private String password;
    private String principalName;
    private Subject subject;
    static Logger logger = Logger.getLogger("samples.connectors.mailconnector.ra.inbound");

    public MySecurityContext(String userName, String password, String principalName) {
        this.userName = userName;
        this.password = password;
        this.principalName = principalName;
        logger.fine("[MySecurityContext] constructor");
    }

    public void setupSecurityContext(CallbackHandler callbackHandler, Subject execSubject, Subject serviceSubject) {
        execSubject.getPrincipals().add((Principal)new PrincipalImpl(this.principalName));
        ArrayList<Object> callbacks = new ArrayList<Object>();
        CallerPrincipalCallback cpc = new CallerPrincipalCallback(execSubject, (Principal)new PrincipalImpl(this.principalName));
        logger.fine("[SC] setting caller principal callback with principal : " + this.principalName);
        callbacks.add(cpc);
        PasswordValidationCallback pvc = null;
        pvc = new PasswordValidationCallback(execSubject, this.userName, this.password.toCharArray());
        logger.fine("[SC] setting password validation callback with user [ " + this.userName + " ] + password [ " + this.password + " ]");
        callbacks.add(pvc);
        Callback[] callbackArray = new Callback[callbacks.size()];
        try {
            callbackHandler.handle(callbacks.toArray(callbackArray));
        }
        catch (UnsupportedCallbackException e) {
            this.debug("exception occured : " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.debug("exception occured : " + e.getMessage());
        }
        if (!pvc.getResult()) {
            logger.info("[SC] Password validation callback failure for user : " + this.userName);
            throw new IllegalStateException("User [ " + this.userName + " ] not authorized to send message");
        }
        logger.info("[SC] Password validation callback succeded for user : " + this.userName);
    }

    public String toString() {
        StringBuffer toString = new StringBuffer("{");
        toString.append("userName : " + this.userName);
        toString.append(", password : " + this.password);
        toString.append(", principalName : " + this.principalName);
        toString.append("}");
        return toString.toString();
    }

    public void debug(String message) {
        logger.fine("[SC]: " + message);
    }
}

