/*
 * Decompiled with CFR 0.152.
 */
package samples.connectors.mailconnector.ra.outbound;

import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.mail.Folder;
import javax.mail.Message;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.LocalTransaction;
import samples.connectors.mailconnector.api.JavaMailConnection;
import samples.connectors.mailconnector.ra.outbound.ConnectionMetaDataImpl;
import samples.connectors.mailconnector.ra.outbound.ManagedConnectionImpl;

public class JavaMailConnectionImpl
implements JavaMailConnection {
    private ManagedConnectionImpl mc;
    private Folder folder;
    static Logger logger = Logger.getLogger("samples.connectors.mailconnector.ra.outbound", "samples.connectors.mailconnector.ra.outbound.LocalStrings");
    ResourceBundle resource = ResourceBundle.getBundle("samples.connectors.mailconnector.ra.outbound.LocalStrings");

    JavaMailConnectionImpl(ManagedConnectionImpl mc, Folder folder) {
        this.mc = mc;
        this.folder = folder;
        logger.fine(" 5. JavaMailConnectionImpl::Constructor");
    }

    public ManagedConnectionImpl getManagedConnection() {
        logger.finest(" -- In JavaMailConnectionImpl::getManagedConnection mc=" + this.mc);
        return this.mc;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new ResourceException(this.resource.getString("NO_TRANSACTION"));
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        logger.finest(" -- In JavaMailConnectionImpl:: getMetaData mc=" + this.mc);
        return new ConnectionMetaDataImpl(this.mc);
    }

    public void close() throws ResourceException {
        logger.finest(" -- In JavaMailConnectionImpl:: close mc=" + this.mc);
        if (this.mc == null) {
            return;
        }
        this.mc.removeJavaMailConnection(this);
        this.mc.sendEvent(1, null, this);
        this.mc = null;
    }

    public void associateConnection(ManagedConnectionImpl newMc) throws ResourceException {
        this.checkIfValid();
        this.mc.removeJavaMailConnection(this);
        newMc.addJavaMailConnection(this);
        this.mc = newMc;
    }

    void checkIfValid() throws ResourceException {
        logger.finest(" -- In JavaMailConnectionImpl::checkIfValid mc=" + this.mc);
        if (this.mc == null) {
            throw new ResourceException(this.resource.getString("INVALID_CONNECTION"));
        }
    }

    void invalidate() {
        logger.fine(" -- In JavaMailConnectionImpl::invalidate mc=" + this.mc);
        this.mc = null;
    }

    public Message[] getNewMessages() throws ResourceException {
        this.checkIfValid();
        try {
            return this.mc.getNewMessages(this.folder);
        }
        catch (Exception e) {
            logger.warning("ManagedConnectionImpl::getNewMessages threw exception: " + e);
            throw new ResourceException(e.getMessage());
        }
    }

    public String[] getNewMessageHeaders() throws ResourceException {
        this.checkIfValid();
        try {
            return this.mc.getNewMessageHeaders(this.folder);
        }
        catch (Exception e) {
            logger.warning("ManagedConnectionImpl::getNewMessageHeaders threw exception: " + e);
            throw new ResourceException(e.getMessage());
        }
    }
}

