/*
 * Decompiled with CFR 0.152.
 */
package samples.connectors.mailconnector.ra.outbound;

import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import samples.connectors.mailconnector.ra.outbound.ConnectionRequestInfoImpl;
import samples.connectors.mailconnector.share.ConnectionSpecImpl;

public class MailServerStore {
    private Session session;
    private Authenticator authenticator;
    private Store store;
    private Properties mailProperties;
    private String userName;
    private String password;
    private String serverName;
    private String protocol;
    public static final Logger logger = Logger.getLogger("samples.connectors.mailconnector.ra.outbound");

    public MailServerStore(ConnectionSpecImpl spec) throws Exception {
        this.userName = spec.getUserName();
        this.password = spec.getPassword();
        this.serverName = spec.getServerName();
        this.protocol = spec.getProtocol();
        this.authenticator = null;
        this.mailProperties = new Properties();
        this.mailProperties.setProperty("mail.transport.protocol", "smtp");
        this.mailProperties.setProperty("mail.store.protocol", this.protocol);
        this.mailProperties.setProperty("mail.smtp.host", this.serverName);
        this.connectStore();
    }

    public void closeStore() throws Exception {
        this.store.close();
        this.store = null;
        this.authenticator = null;
        this.session = null;
    }

    private void connectStore() throws Exception {
        try {
            this.session = Session.getDefaultInstance((Properties)this.mailProperties);
            this.store = this.session.getStore();
            this.store.connect(this.serverName, this.userName, this.password);
        }
        catch (Exception te) {
            logger.info("[S] Caught an exception when obtaining a JavaMail Session");
            throw new Exception(te.getMessage());
        }
    }

    public Folder getFolder(String folderName) throws Exception {
        Folder folder = this.store.getFolder(folderName);
        if (folder == null || !folder.exists()) {
            Exception e = new Exception("Folder " + folderName + " does not exist or is not found");
            throw e;
        }
        return folder;
    }

    public Message[] getNewMessages(Folder folder) throws Exception {
        if (folder == null || !folder.exists()) {
            Exception e = new Exception("Folder " + folder + " does not exist or is not found");
            throw e;
        }
        if (!folder.isOpen()) {
            folder.open(2);
        }
        try {
            int newMsgs = folder.getNewMessageCount();
            if (newMsgs > 0) {
                int msgCount = folder.getMessageCount();
                Message[] msgs = folder.getMessages(msgCount - newMsgs + 1, msgCount);
                return msgs;
            }
        }
        catch (Exception e) {
            logger.info("[S] Exception obtaining messages from mail server");
        }
        return null;
    }

    public String[] getNewMessageHeaders(Folder folder) throws Exception {
        if (folder == null || !folder.exists()) {
            Exception e = new Exception("Folder " + folder + " does not exist or is not found");
            throw e;
        }
        if (!folder.isOpen()) {
            folder.open(2);
        }
        try {
            int newMsgs = folder.getNewMessageCount();
            if (newMsgs > 0) {
                int msgCount = folder.getMessageCount();
                Message[] msgs = folder.getMessages(msgCount - newMsgs + 1, msgCount);
                String[] headers = new String[msgs.length];
                logger.info("messages length: " + msgs.length);
                logger.info("headers length: " + headers.length);
                for (int i = 0; i < headers.length; ++i) {
                    logger.info("<MSF> Packing message with SUBJECT: " + msgs[i].getSubject());
                    headers[i] = msgs[i].getSubject();
                }
                return headers;
            }
        }
        catch (Exception e) {
            logger.severe("[S] Exception obtaining messages from mail server:");
            e.printStackTrace();
        }
        return null;
    }

    public boolean isTheSameStore(ConnectionRequestInfoImpl cxRequestInfo) {
        if (!this.userName.equals(cxRequestInfo.getUserName())) {
            return false;
        }
        if (!this.password.equals(cxRequestInfo.getPassword())) {
            return false;
        }
        if (!this.serverName.equals(cxRequestInfo.getServerName())) {
            return false;
        }
        if (!this.protocol.equals(cxRequestInfo.getProtocol())) {
            return false;
        }
        logger.info("isTheSameStore: found match!");
        return true;
    }
}

