/*
 * Decompiled with CFR 0.152.
 */
package samples.connectors.mailconnector.ra.outbound;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.mail.Folder;
import javax.mail.Message;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import samples.connectors.mailconnector.api.JavaMailConnection;
import samples.connectors.mailconnector.ra.outbound.ConnectionRequestInfoImpl;
import samples.connectors.mailconnector.ra.outbound.JavaMailConnectionEventListener;
import samples.connectors.mailconnector.ra.outbound.JavaMailConnectionImpl;
import samples.connectors.mailconnector.ra.outbound.MailServerStore;
import samples.connectors.mailconnector.ra.outbound.ManagedConnectionFactoryImpl;
import samples.connectors.mailconnector.ra.outbound.ManagedConnectionMetaDataImpl;
import samples.connectors.mailconnector.ra.outbound.Util;
import samples.connectors.mailconnector.share.ConnectionSpecImpl;

public class ManagedConnectionImpl
implements ManagedConnection {
    private ManagedConnectionFactoryImpl mcf;
    private JavaMailConnectionEventListener eventListener;
    private Set connectionSet;
    private PrintWriter logWriter;
    private boolean destroyed;
    private MailServerStore store = null;
    private static int testCounter = 0;
    private int myId = 0;
    private PasswordCredential passCred = null;
    static Logger logger = Logger.getLogger("samples.connectors.mailconnector.ra.outbound", "samples.connectors.mailconnector.ra.outbound.LocalStrings");
    ResourceBundle resource = ResourceBundle.getBundle("samples.connectors.mailconnector.ra.outbound.LocalStrings");

    ManagedConnectionImpl(ManagedConnectionFactoryImpl mcf, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        this.myId = testCounter++;
        logger.fine(" 3B.- (" + this.myId + ") ManagedConnection::constructor");
        this.mcf = mcf;
        this.passCred = Util.getPasswordCredential(mcf, subject, cxRequestInfo);
        this.openStore(cxRequestInfo);
        this.connectionSet = new HashSet();
        this.eventListener = new JavaMailConnectionEventListener(this);
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        Folder folder;
        logger.fine(" 4.- (" + this.myId + ") testManagedConnection::getConnection: ConnectionManager requested a Connection handle");
        this.checkIfDestroyed();
        PasswordCredential pc = Util.getPasswordCredential(this.mcf, subject, cxRequestInfo);
        if (!Util.isPasswordCredentialEqual(pc, this.passCred)) {
            throw new SecurityException(this.resource.getString("PRINCIPAL_DOES_NOT_MATCH"));
        }
        String folderName = cxRequestInfo != null ? ((ConnectionRequestInfoImpl)cxRequestInfo).getFolderName() : this.mcf.getFolderName();
        try {
            folder = this.store.getFolder(folderName);
        }
        catch (Exception e) {
            logger.warning("ManagedConnectionImpl::getConnection threw exception: " + e);
            throw new ResourceException(e.getMessage());
        }
        JavaMailConnectionImpl javaMailCon = new JavaMailConnectionImpl(this, folder);
        this.addJavaMailConnection(javaMailCon);
        return javaMailCon;
    }

    public void destroy() throws ResourceException {
        if (this.destroyed) {
            return;
        }
        logger.fine(" 9.- (" + this.myId + ") ManagedConnection::destroy called");
        this.destroyed = true;
        --testCounter;
        this.invalidateJavaMailConnections();
        try {
            this.store.closeStore();
        }
        catch (Exception e) {
            logger.warning("ManagedConnectionImpl::destroy threw exception: " + e);
            throw new ResourceException(e.getMessage());
        }
    }

    public void cleanup() throws ResourceException {
        this.checkIfDestroyed();
        logger.fine(" 8.- (" + this.myId + ") ManagedConnection::cleanup called");
        this.invalidateJavaMailConnections();
    }

    private void invalidateJavaMailConnections() {
        for (JavaMailConnectionImpl javaMailCon : this.connectionSet) {
            javaMailCon.invalidate();
        }
        this.connectionSet.clear();
    }

    public void associateConnection(Object connection) throws ResourceException {
        this.checkIfDestroyed();
        if (!(connection instanceof JavaMailConnection)) {
            throw new IllegalStateException(this.resource.getString("INVALID_CONNECTION"));
        }
        JavaMailConnectionImpl javaMailCon = (JavaMailConnectionImpl)connection;
        javaMailCon.associateConnection(this);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.eventListener.addConnectorListener(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.eventListener.removeConnectorListener(listener);
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException(this.resource.getString("NO_XATRANSACTION"));
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException(this.resource.getString("NO_TRANSACTION"));
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.checkIfDestroyed();
        return new ManagedConnectionMetaDataImpl(this);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public String getUserName() {
        if (this.passCred != null) {
            return this.passCred.getUserName();
        }
        return null;
    }

    public PasswordCredential getPasswordCredential() {
        return this.passCred;
    }

    public void addJavaMailConnection(JavaMailConnection javaMailCon) {
        this.connectionSet.add(javaMailCon);
    }

    private void checkIfDestroyed() throws ResourceException {
        if (this.destroyed) {
            throw new IllegalStateException(this.resource.getString("DESTROYED_CONNECTION"));
        }
    }

    public void removeJavaMailConnection(JavaMailConnection javaMailCon) {
        this.connectionSet.remove(javaMailCon);
    }

    boolean isDestroyed() {
        return this.destroyed;
    }

    public ManagedConnectionFactoryImpl getManagedConnectionFactory() {
        return this.mcf;
    }

    public void sendEvent(int eventType, Exception ex) {
        this.eventListener.sendEvent(eventType, ex, null);
    }

    public void sendEvent(int eventType, Exception ex, Object connectionHandle) {
        this.eventListener.sendEvent(eventType, ex, connectionHandle);
    }

    public boolean isTheSameStore(ConnectionRequestInfoImpl cxRequestInfo) {
        logger.fine(" X.- (" + this.myId + ") ManagedConnection::isTheSame called");
        return this.store.isTheSameStore(cxRequestInfo);
    }

    private boolean openStore(ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        ConnectionSpecImpl connectionInfo = new ConnectionSpecImpl();
        if (cxRequestInfo != null) {
            connectionInfo.setUserName(((ConnectionRequestInfoImpl)cxRequestInfo).getUserName());
            connectionInfo.setPassword(((ConnectionRequestInfoImpl)cxRequestInfo).getPassword());
            connectionInfo.setServerName(((ConnectionRequestInfoImpl)cxRequestInfo).getServerName());
            connectionInfo.setProtocol(((ConnectionRequestInfoImpl)cxRequestInfo).getProtocol());
        } else {
            connectionInfo.setUserName(this.mcf.getUserName());
            connectionInfo.setPassword(this.mcf.getPassword());
            connectionInfo.setServerName(this.mcf.getServerName());
            connectionInfo.setProtocol(this.mcf.getProtocol());
        }
        try {
            this.store = new MailServerStore(connectionInfo);
        }
        catch (Exception e) {
            logger.severe("JavaMailConnectionImpl::openStore threw exception: " + e);
            throw new ResourceException(e.getMessage());
        }
        return true;
    }

    private Folder getFolder(String folderName) throws ResourceException {
        try {
            Folder folder = this.store.getFolder(folderName);
            return folder;
        }
        catch (Exception e) {
            logger.severe("JavaMailConnectionImpl::getFolder threw exception: " + e);
            return null;
        }
    }

    public Message[] getNewMessages(Folder folder) throws ResourceException {
        try {
            return this.store.getNewMessages(folder);
        }
        catch (Exception e) {
            logger.warning("ManagedConnectionImpl::getNewMessages threw exception: " + e);
            throw new ResourceException(e.getMessage());
        }
    }

    public String[] getNewMessageHeaders(Folder folder) throws ResourceException {
        try {
            return this.store.getNewMessageHeaders(folder);
        }
        catch (Exception e) {
            logger.warning("ManagedConnectionImpl::getNewMessageHeaders threw exception: " + e);
            throw new ResourceException(e.getMessage());
        }
    }
}

