/*
 * Decompiled with CFR 0.152.
 */
package samples.connectors.mailconnector.ra.outbound;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import samples.connectors.mailconnector.ra.outbound.ConnectionRequestInfoImpl;

public class Util {
    static Logger logger = Logger.getLogger("samples.connectors.mailconnector.ra.outbound", "samples.connectors.mailconnector.ra.outbound.LocalStrings");
    static ResourceBundle resource = ResourceBundle.getBundle("samples.connectors.mailconnector.ra.outbound.LocalStrings");

    public static PasswordCredential getPasswordCredential(final ManagedConnectionFactory mcf, final Subject subject, ConnectionRequestInfo info) throws ResourceException {
        if (subject == null) {
            if (info == null) {
                logger.fine("\tUtil::GetPasswordCred: INFO is null");
                return null;
            }
            ConnectionRequestInfoImpl myinfo = (ConnectionRequestInfoImpl)info;
            if (myinfo.getUserName() == null || myinfo.getPassword() == null) {
                logger.fine("\tUtil::GetPasswordCred: User or password is null");
                return null;
            }
            char[] password = myinfo.getPassword().toCharArray();
            PasswordCredential pc = new PasswordCredential(myinfo.getUserName(), password);
            pc.setManagedConnectionFactory(mcf);
            logger.fine("\tUtil::GetPasswordCred: returning a created PC");
            return pc;
        }
        PasswordCredential pc = (PasswordCredential)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Set<PasswordCredential> creds = subject.getPrivateCredentials(PasswordCredential.class);
                for (PasswordCredential temp : creds) {
                    if (temp == null || temp.getManagedConnectionFactory() == null || !temp.getManagedConnectionFactory().equals(mcf)) continue;
                    return temp;
                }
                return null;
            }
        });
        if (pc == null) {
            throw new SecurityException(resource.getString("util.no_credential"));
        }
        logger.fine("\tUtil::GetPasswordCred: returning a FOUND PC");
        return pc;
    }

    public static boolean isEqual(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static boolean isPasswordCredentialEqual(PasswordCredential a, PasswordCredential b) {
        if (a == b) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        if (!Util.isEqual(a.getUserName(), b.getUserName())) {
            return false;
        }
        String p1 = null;
        String p2 = null;
        if (a.getPassword() != null) {
            p1 = new String(a.getPassword());
        }
        if (b.getPassword() != null) {
            p2 = new String(b.getPassword());
        }
        return Util.isEqual(p1, p2);
    }
}

