/*
 * Decompiled with CFR 0.152.
 */
package samples.connectors.mailconnector.ra.inbound;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.AuthenticationFailedException;
import javax.mail.Flags;
import javax.mail.Message;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import samples.connectors.mailconnector.api.JavaMailMessageListener;
import samples.connectors.mailconnector.ra.inbound.ActivationSpecImpl;
import samples.connectors.mailconnector.ra.inbound.MailServerFolder;

public class EndpointConsumer {
    ActivationSpecImpl activationSpec;
    MessageEndpointFactory endpointFactory;
    MailServerFolder folder = null;
    static Logger logger = Logger.getLogger("samples.connectors.mailconnector.ra.inbound", "samples.connectors.mailconnector.ra.inbound.LocalStrings");
    public Method onMessage = null;

    public EndpointConsumer(MessageEndpointFactory endpointFactory, ActivationSpecImpl activationSpec) throws Exception {
        this.endpointFactory = endpointFactory;
        this.activationSpec = activationSpec;
        try {
            this.folder = new MailServerFolder(activationSpec);
        }
        catch (AuthenticationFailedException ie) {
            logger.info("[EC] Authentication problem when opening Mail Folder: " + this.getUniqueKey() + " Wrong password?, fix ejb-jar.xml, rebuild and redeploy");
            throw ie;
        }
        catch (Exception ie) {
            logger.info("[EC] Unexpected Error while opening Mail Folder: " + this.getUniqueKey() + " check for typos with foldername, username, password or hostname in ejb-jar.xml, rebuild and redeploy");
            throw ie;
        }
        logger.info("[EC] Created EndpointConsumer for: " + this.getUniqueKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverMessage(Message message) throws RemoteException {
        MessageEndpoint endpoint = null;
        Object[] args = new Object[]{message};
        try {
            endpoint = this.endpointFactory.createEndpoint(null);
            if (endpoint != null) {
                ((JavaMailMessageListener)endpoint).onMessage(message);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "messagereceiver.onmessageexception", e.getMessage());
        }
        catch (Error error) {
            logger.log(Level.WARNING, "messagereceiver.onmessageexception", error.getMessage());
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "messagereceiver.onmessageexception", t.getMessage());
        }
        finally {
            if (endpoint != null) {
                endpoint.release();
            }
        }
    }

    public boolean hasNewMessages() throws Exception {
        logger.fine("[EC] Checking for new messages on: " + this.getUniqueKey());
        return this.folder.hasNewMessages();
    }

    public String getUniqueKey() {
        return this.activationSpec.getUserName() + "::" + this.activationSpec.getFolderName() + "@" + this.activationSpec.getServerName();
    }

    public Message[] getNewMessages() {
        Message[] msgs = null;
        try {
            msgs = this.folder.getNewMessages();
            if (msgs != null) {
                for (int i = 0; i < msgs.length; ++i) {
                    if (msgs[i].isSet(Flags.Flag.SEEN)) continue;
                    msgs[i].setFlag(Flags.Flag.SEEN, true);
                }
            }
        }
        catch (Exception ie) {
            logger.info("[EC] getNewMessages caught an exception. Bailing out");
            ie.printStackTrace();
        }
        return msgs;
    }
}

