/*
 * Decompiled with CFR 0.152.
 */
package samples.connectors.mailconnector.ra.inbound;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.mail.Message;
import javax.resource.NotSupportedException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.WorkRejectedException;
import samples.connectors.mailconnector.ra.inbound.DeliveryThread;
import samples.connectors.mailconnector.ra.inbound.EndpointConsumer;

public class PollingThread
implements Work {
    public static final Logger logger = Logger.getLogger("samples.connectors.mailconnector.ra.inbound");
    static ResourceBundle resource = ResourceBundle.getBundle("samples.connectors.mailconnector.ra.inbound.LocalStrings");
    private boolean active = true;
    protected transient WorkManager workManager;
    private transient HashMap endpointConsumers = null;
    private static int QUANTUM = 30;

    public PollingThread(WorkManager workManager) {
        this.workManager = workManager;
        this.endpointConsumers = new HashMap(10);
        logger.info("[PollingThread::Constructor] Leaving");
    }

    public void release() {
        logger.info("[S] Worker Manager called release for PollingThread ");
        this.active = false;
    }

    public void run() {
        logger.info("[PT] WorkManager started polling thread ");
        while (this.active) {
            try {
                this.pollEndpoints();
                Thread.sleep((long)QUANTUM * 1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.fine("[PT] Polling Thread Leaving");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollEndpoints() {
        logger.fine("[PT] Polling endpoints entering");
        HashMap hashMap = this.endpointConsumers;
        synchronized (hashMap) {
            Set consumers = this.endpointConsumers.entrySet();
            if (consumers != null) {
                for (Map.Entry entry : consumers) {
                    EndpointConsumer ec = (EndpointConsumer)entry.getValue();
                    try {
                        Message[] messages;
                        if (!ec.hasNewMessages() || (messages = ec.getNewMessages()) == null) continue;
                        for (Message msg : messages) {
                            this.scheduleMessageDeliveryThread(ec, msg);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        logger.fine("[PT] Polling endpoints Leaving");
    }

    private void scheduleMessageDeliveryThread(EndpointConsumer ec, Message msg) throws Exception {
        logger.info("[PT] scheduling a delivery FROM: " + ec.getUniqueKey());
        try {
            DeliveryThread deliveryThread = new DeliveryThread(ec, msg);
            this.workManager.scheduleWork((Work)deliveryThread);
        }
        catch (WorkRejectedException ex) {
            NotSupportedException newEx = new NotSupportedException(MessageFormat.format(resource.getString("resourceadapterimpl.worker_activation_rejected"), ex.getMessage()));
            newEx.initCause((Throwable)ex);
            throw newEx;
        }
        catch (Exception ex) {
            NotSupportedException newEx = new NotSupportedException(MessageFormat.format(resource.getString("resourceadapterimpl.worker_activation_failed"), ex.getMessage()));
            newEx.initCause((Throwable)ex);
            throw newEx;
        }
    }

    public void stopPolling() {
        this.removeAllEndpointConsumers();
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEndpointConsumer(MessageEndpointFactory endpointFactory, EndpointConsumer ec) {
        logger.finest("[PT.addEndpointConsumer()] Entered");
        HashMap hashMap = this.endpointConsumers;
        synchronized (hashMap) {
            this.endpointConsumers.put(endpointFactory, ec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEndpointConsumer(MessageEndpointFactory endpointFactory) {
        logger.finest("[PT.removeEndpointConsumer()] Entered");
        EndpointConsumer ec = (EndpointConsumer)this.endpointConsumers.get(endpointFactory);
        HashMap hashMap = this.endpointConsumers;
        synchronized (hashMap) {
            this.endpointConsumers.remove(ec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllEndpointConsumers() {
        HashMap hashMap = this.endpointConsumers;
        synchronized (hashMap) {
            Set consumers = this.endpointConsumers.entrySet();
            if (consumers != null) {
                for (Map.Entry entry : consumers) {
                    EndpointConsumer ec = (EndpointConsumer)entry.getValue();
                    try {
                        this.endpointConsumers.remove(ec);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.endpointConsumers = null;
    }
}

