/*
 * Decompiled with CFR 0.152.
 */
package samples.connectors.mailconnector.ra.outbound;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionSpec;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import samples.connectors.mailconnector.api.JavaMailConnection;
import samples.connectors.mailconnector.api.JavaMailConnectionFactory;
import samples.connectors.mailconnector.ra.outbound.ConnectionManagerImpl;
import samples.connectors.mailconnector.ra.outbound.ConnectionRequestInfoImpl;
import samples.connectors.mailconnector.share.ConnectionSpecImpl;

public class JavaMailConnectionFactoryImpl
implements JavaMailConnectionFactory,
Serializable,
Referenceable {
    static Logger logger = Logger.getLogger("samples.connectors.mailconnector.ra.outbound");
    ResourceBundle resource = ResourceBundle.getBundle("samples.connectors.mailconnector.ra.outbound.ConnectionFactory");
    private ManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Reference reference;
    private transient PrintWriter out;
    private transient int milliseconds;

    public JavaMailConnectionFactoryImpl() {
    }

    public JavaMailConnectionFactoryImpl(ManagedConnectionFactory mcf, ConnectionManager cm) {
        logger.fine(" 3. JavaMailConnectionFactoryImpl::Constructor");
        this.mcf = mcf;
        this.cm = cm == null ? new ConnectionManagerImpl() : cm;
    }

    public JavaMailConnection createConnection() throws ResourceException {
        JavaMailConnection con = null;
        logger.fine(" 3.- JMCFI::createConnection -- Client requested a connection. Get it from Connection Manager");
        con = (JavaMailConnection)this.cm.allocateConnection(this.mcf, null);
        logger.fine(" 6.- JMCFI::createConnection -- Returning Connection to Client");
        return con;
    }

    public JavaMailConnection createConnection(ConnectionSpec properties) throws ResourceException {
        JavaMailConnection con = null;
        logger.fine(" 3.- JMCFI::createConnection -- Client requested a connection. Get it from Connection Manager");
        ConnectionRequestInfoImpl info = new ConnectionRequestInfoImpl(((ConnectionSpecImpl)properties).getUserName(), ((ConnectionSpecImpl)properties).getPassword(), ((ConnectionSpecImpl)properties).getFolderName(), ((ConnectionSpecImpl)properties).getServerName(), ((ConnectionSpecImpl)properties).getProtocol());
        con = (JavaMailConnection)this.cm.allocateConnection(this.mcf, (ConnectionRequestInfo)info);
        logger.fine(" 6.- JMCFI::createConnection -- Returning Connection to user");
        return con;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.out = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.out;
    }

    public void setTimeout(int milliseconds) throws ResourceException {
        this.milliseconds = milliseconds;
    }

    public int getTimeout() throws ResourceException {
        return this.milliseconds;
    }

    public void setReference(Reference reference) {
        logger.fine("In JavaMailConnectionFactoryImpl::setReference");
        this.reference = reference;
    }

    public Reference getReference() {
        logger.fine("In JavaMailConnectionFactoryImpl::getReference");
        return this.reference;
    }
}

