/*
 * Decompiled with CFR 0.152.
 */
package samples.connectors.mailconnector.ra.outbound;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Set;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConfigProperty;
import javax.resource.spi.ConnectionDefinition;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import samples.connectors.mailconnector.api.JavaMailConnection;
import samples.connectors.mailconnector.api.JavaMailConnectionFactory;
import samples.connectors.mailconnector.ra.outbound.ConnectionRequestInfoImpl;
import samples.connectors.mailconnector.ra.outbound.JavaMailConnectionFactoryImpl;
import samples.connectors.mailconnector.ra.outbound.JavaMailConnectionImpl;
import samples.connectors.mailconnector.ra.outbound.ManagedConnectionImpl;
import samples.connectors.mailconnector.ra.outbound.Util;

@ConnectionDefinition(connectionFactory=JavaMailConnectionFactory.class, connectionFactoryImpl=JavaMailConnectionFactoryImpl.class, connection=JavaMailConnection.class, connectionImpl=JavaMailConnectionImpl.class)
public class ManagedConnectionFactoryImpl
implements ManagedConnectionFactory,
Serializable {
    private transient PrintWriter out;
    private transient PropertyChangeSupport changes = new PropertyChangeSupport(this);
    static Logger logger = Logger.getLogger("samples.connectors.mailconnector.ra.outbound", "samples.connectors.mailconnector.ra.outbound.LocalStrings");
    private String serverName = new String("unknownServerName");
    private String userName = new String("unknownUserName");
    @ConfigProperty(type=String.class, defaultValue="UnknownPassword")
    private String password = new String("unknownPassword");
    @ConfigProperty(type=String.class, defaultValue="UnknownFolderName")
    private String folderName = new String("Inbox");
    private String protocol = new String("imap");

    public ManagedConnectionFactoryImpl() {
        logger.fine(" 1.- ManagedConnectionFactoryImpl::Constructor");
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        logger.fine(" 2.- MCF::createConnectionFactory(cxManager)");
        JavaMailConnectionFactoryImpl cf = null;
        try {
            cf = new JavaMailConnectionFactoryImpl(this, cxManager);
        }
        catch (Exception e) {
            throw new ResourceException(e.getMessage());
        }
        return cf;
    }

    public Object createConnectionFactory() throws ResourceException {
        logger.fine(" 2.- MCF::createConnectionFactory()");
        return new JavaMailConnectionFactoryImpl(this, null);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        logger.fine(" 3A.- ManagedConnectionFactory::createManagedConnection(Subject, cxM)");
        Object userName = null;
        ManagedConnectionImpl mc = null;
        mc = new ManagedConnectionImpl(this, subject, cxRequestInfo);
        return mc;
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        PasswordCredential pc = Util.getPasswordCredential(this, subject, cxRequestInfo);
        String userName = null;
        if (pc != null) {
            userName = pc.getUserName();
        }
        for (Object obj : connectionSet) {
            if (!(obj instanceof ManagedConnectionImpl)) continue;
            ManagedConnectionImpl mc = (ManagedConnectionImpl)obj;
            ManagedConnectionFactoryImpl mcf = mc.getManagedConnectionFactory();
            if (!Util.isPasswordCredentialEqual(mc.getPasswordCredential(), pc) || !mc.isTheSameStore((ConnectionRequestInfoImpl)cxRequestInfo)) continue;
            logger.finest("MCF::matchManagedConnections: found match mc = " + mc);
            return mc;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.out = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.out;
    }

    public int hashCode() {
        int hashcode = new String("").hashCode();
        if (this.userName != null) {
            hashcode += this.userName.hashCode();
        }
        if (this.password != null) {
            hashcode += this.password.hashCode();
        }
        if (this.serverName != null) {
            hashcode += this.serverName.hashCode();
        }
        if (this.protocol != null) {
            hashcode += this.protocol.hashCode();
        }
        if (this.folderName != null) {
            this.folderName = this.folderName + this.folderName.hashCode();
        }
        return hashcode;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ManagedConnectionFactoryImpl) {
            ManagedConnectionFactoryImpl other = (ManagedConnectionFactoryImpl)obj;
            if (!this.userName.equals(other.getUserName())) {
                return false;
            }
            if (!this.password.equals(other.getPassword())) {
                return false;
            }
            if (!this.serverName.equals(other.getServerName())) {
                return false;
            }
            if (!this.folderName.equals(other.getFolderName())) {
                return false;
            }
            return this.protocol.equals(other.getProtocol());
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener lis) {
        this.changes.addPropertyChangeListener(lis);
    }

    public void removePropertyChangeListener(PropertyChangeListener lis) {
        this.changes.removePropertyChangeListener(lis);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        logger.finest("Before readObject mcf");
        in.defaultReadObject();
        this.changes = new PropertyChangeSupport(this);
        this.out = null;
        logger.finest("after readObject mcf");
    }

    public String getServerName() {
        return this.serverName;
    }

    @ConfigProperty(type=String.class, defaultValue="UnknownHostName")
    public void setServerName(String serverName) {
        String oldName = this.serverName;
        this.serverName = serverName;
        this.changes.firePropertyChange("serverName", oldName, serverName);
    }

    public String getUserName() {
        return this.userName;
    }

    @ConfigProperty(type=String.class, defaultValue="UnknownUserName")
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public String getProtocol() {
        return this.protocol;
    }

    @ConfigProperty(description="Typically Imap", type=String.class, defaultValue="Imap")
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

