/*
 * Copyright (c) 2010, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.shoal.ha.cache.api;

/**
 * @author Mahesh Kannan
 */
public class ShoalCacheLoggerConstants {

    public static final String CACHE = "org.shoal.ha.cache";

    public static final String CACHE_STATS = "org.shoal.ha.cache.stats";

    public static final String CACHE_CONFIG = "org.shoal.ha.cache.config";

    public static final String CACHE_KEY_MAPPER = "org.shoal.ha.cache.mapper";

    public static final String CACHE_COMMAND = "org.shoal.ha.cache.command";

    public static final String CACHE_SAVE_COMMAND = "org.shoal.ha.cache.command.save";

    public static final String CACHE_REPLICATION_FRAME_COMMAND = "org.shoal.ha.cache.command.frame";

    public static final String CACHE_REMOVE_COMMAND = "org.shoal.ha.cache.command.remove";

    public static final String CACHE_STALE_REMOVE_COMMAND = "org.shoal.ha.cache.command.remove";

    public static final String CACHE_LOAD_REQUEST_COMMAND = "org.shoal.ha.cache.command.load_request";

    public static final String CACHE_LOAD_RESPONSE_COMMAND = "org.shoal.ha.cache.command.load_response";

    public static final String CACHE_TOUCH_COMMAND = "org.shoal.ha.cache.command.touch";

    public static final String CACHE_TRANSMIT_INTERCEPTOR = "org.shoal.ha.cache.interceptor.transmit";

    public static final String CACHE_REVEIVE_INTERCEPTOR = "org.shoal.ha.cache.interceptor.receive";

    public static final String CACHE_DATA_STORE = "org.shoal.ha.cache.store";

    public static final String CACHE_MONITOR = "org.shoal.ha.monitor";

    public static final String CACHE_SIZE_REQUEST_COMMAND = "org.shoal.ha.cache.command.size";

    public static final String CACHE_SIZE_RESPONSE_COMMAND = "org.shoal.ha.cache.command.size";

    public static final String CACHE_REMOVE_EXPIRED_COMMAND = "org.shoal.ha.cache.command.remove_expired";

}
