/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.authorization;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;

public class JACC {
    public static Subject getSubject() {
        return (Subject)JACC.getFromContext("javax.security.auth.Subject.container");
    }

    public static boolean isCallerInRole(String role) {
        return JACC.hasPermission(JACC.getSubject(), (Permission)new WebRoleRefPermission("", role));
    }

    public static boolean hasAccessToWebResource(String resource, String ... methods) {
        return JACC.hasPermission(JACC.getSubject(), (Permission)new WebResourcePermission(resource, methods));
    }

    public static Set<String> getAllDeclaredCallerRoles() {
        PermissionCollection permissionCollection = JACC.getPermissionCollection(JACC.getSubject());
        permissionCollection.implies((Permission)new WebRoleRefPermission("", "nothing"));
        return JACC.filterRoles(permissionCollection);
    }

    public static boolean hasPermission(Subject subject, Permission permission) {
        return Policy.getPolicy().implies(JACC.fromSubject(subject), permission);
    }

    public static PermissionCollection getPermissionCollection(Subject subject) {
        return Policy.getPolicy().getPermissions(JACC.fromSubject(subject));
    }

    public static Set<String> filterRoles(PermissionCollection permissionCollection) {
        HashSet<String> roles = new HashSet<String>();
        for (Permission permission : Collections.list(permissionCollection.elements())) {
            String role;
            if (!(permission instanceof WebRoleRefPermission) || roles.contains(role = permission.getActions()) || !JACC.isCallerInRole(role)) continue;
            roles.add(role);
        }
        return roles;
    }

    public static ProtectionDomain fromSubject(Subject subject) {
        return new ProtectionDomain(new CodeSource(null, (Certificate[])null), null, null, subject.getPrincipals().toArray(new Principal[subject.getPrincipals().size()]));
    }

    public static <T> T getFromContext(String contextName) {
        try {
            return (T)PolicyContext.getContext((String)contextName);
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }
}

